/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.search_pipeline.RequestProcessor;
import org.opensearch.client.opensearch.search_pipeline.RequestProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class OversampleRequestProcessor
implements RequestProcessorVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, OversampleRequestProcessor> {
    @Nullable
    private final String contentPrefix;
    @Nullable
    private final String description;
    @Nullable
    private final Boolean ignoreFailure;
    private final float sampleFactor;
    @Nullable
    private final String tag;
    public static final JsonpDeserializer<OversampleRequestProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OversampleRequestProcessor::setupOversampleRequestProcessorDeserializer);

    private OversampleRequestProcessor(Builder builder) {
        this.contentPrefix = builder.contentPrefix;
        this.description = builder.description;
        this.ignoreFailure = builder.ignoreFailure;
        this.sampleFactor = ApiTypeHelper.requireNonNull(builder.sampleFactor, this, "sampleFactor").floatValue();
        this.tag = builder.tag;
    }

    public static OversampleRequestProcessor of(Function<Builder, ObjectBuilder<OversampleRequestProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public RequestProcessor.Kind _requestProcessorKind() {
        return RequestProcessor.Kind.Oversample;
    }

    @Nullable
    public final String contentPrefix() {
        return this.contentPrefix;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    public final float sampleFactor() {
        return this.sampleFactor;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.contentPrefix != null) {
            generator.writeKey("content_prefix");
            generator.write(this.contentPrefix);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure.booleanValue());
        }
        generator.writeKey("sample_factor");
        generator.write((double)this.sampleFactor);
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupOversampleRequestProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::contentPrefix, JsonpDeserializer.stringDeserializer(), "content_prefix");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure");
        op.add(Builder::sampleFactor, JsonpDeserializer.floatDeserializer(), "sample_factor");
        op.add(Builder::tag, JsonpDeserializer.stringDeserializer(), "tag");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.contentPrefix);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.ignoreFailure);
        result = 31 * result + Float.hashCode(this.sampleFactor);
        result = 31 * result + Objects.hashCode(this.tag);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OversampleRequestProcessor other = (OversampleRequestProcessor)o;
        return Objects.equals(this.contentPrefix, other.contentPrefix) && Objects.equals(this.description, other.description) && Objects.equals(this.ignoreFailure, other.ignoreFailure) && this.sampleFactor == other.sampleFactor && Objects.equals(this.tag, other.tag);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, OversampleRequestProcessor> {
        @Nullable
        private String contentPrefix;
        @Nullable
        private String description;
        @Nullable
        private Boolean ignoreFailure;
        private Float sampleFactor;
        @Nullable
        private String tag;

        public Builder() {
        }

        private Builder(OversampleRequestProcessor o) {
            this.contentPrefix = o.contentPrefix;
            this.description = o.description;
            this.ignoreFailure = o.ignoreFailure;
            this.sampleFactor = Float.valueOf(o.sampleFactor);
            this.tag = o.tag;
        }

        private Builder(Builder o) {
            this.contentPrefix = o.contentPrefix;
            this.description = o.description;
            this.ignoreFailure = o.ignoreFailure;
            this.sampleFactor = o.sampleFactor;
            this.tag = o.tag;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder contentPrefix(@Nullable String value) {
            this.contentPrefix = value;
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return this;
        }

        @Nonnull
        public final Builder sampleFactor(float value) {
            this.sampleFactor = Float.valueOf(value);
            return this;
        }

        @Nonnull
        public final Builder tag(@Nullable String value) {
            this.tag = value;
            return this;
        }

        @Override
        @Nonnull
        public OversampleRequestProcessor build() {
            this._checkSingleUse();
            return new OversampleRequestProcessor(this);
        }
    }
}

