/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ProhibitDNInSubtreeArgumentValueValidator
extends ArgumentValueValidator
implements Serializable {
    private static final long serialVersionUID = 171827460774234825L;
    @NotNull
    private final List<DN> baseDNs;

    public ProhibitDNInSubtreeArgumentValueValidator(DN ... baseDNs) {
        this(StaticUtils.toList(baseDNs));
    }

    public ProhibitDNInSubtreeArgumentValueValidator(@NotNull Collection<DN> baseDNs) {
        Validator.ensureNotNull(baseDNs);
        Validator.ensureFalse(baseDNs.isEmpty());
        this.baseDNs = Collections.unmodifiableList(new ArrayList<DN>(baseDNs));
    }

    @NotNull
    public List<DN> getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public void validateArgumentValue(@NotNull Argument argument, @NotNull String valueString) throws ArgumentException {
        DN dn;
        try {
            dn = new DN(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ArgumentException(ArgsMessages.ERR_PROHIBIT_DN_IN_SUBTREE_VALIDATOR_VALUE_NOT_DN.get(valueString, argument.getIdentifierString()), e);
        }
        for (DN baseDN : this.baseDNs) {
            if (!dn.isDescendantOf(baseDN, true)) continue;
            throw new ArgumentException(ArgsMessages.ERR_PROHIBIT_DN_IN_SUBTREE_VALIDATOR_VALUE_IN_SUBTREE.get(valueString, argument.getIdentifierString(), String.valueOf(baseDN)));
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ProhibitDNInSubtreeArgumentValueValidator(baseDNs={");
        Iterator<DN> iterator = this.baseDNs.iterator();
        while (iterator.hasNext()) {
            buffer.append('\'');
            buffer.append(iterator.next().toString());
            buffer.append('\'');
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

