/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONArray
extends JSONValue {
    @NotNull
    public static final JSONArray EMPTY_ARRAY = new JSONArray(new JSONValue[0]);
    private static final long serialVersionUID = -5493008945333225318L;
    @Nullable
    private Integer hashCode;
    @NotNull
    private final List<JSONValue> values;
    @Nullable
    private String stringRepresentation;

    public JSONArray(JSONValue ... values) {
        this(values == null ? null : Arrays.asList(values));
    }

    public JSONArray(@Nullable List<? extends JSONValue> values) {
        this.values = values == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<JSONValue>(values));
        this.hashCode = null;
        this.stringRepresentation = null;
    }

    @NotNull
    public List<JSONValue> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int size() {
        return this.values.size();
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            int hc = 0;
            for (JSONValue v : this.values) {
                hc = hc * 31 + v.hashCode();
            }
            this.hashCode = hc;
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JSONArray) {
            JSONArray a = (JSONArray)o;
            return this.values.equals(a.values);
        }
        return false;
    }

    public boolean equals(@NotNull JSONArray array, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        if (!(ignoreFieldNameCase || ignoreValueCase || ignoreArrayOrder)) {
            return this.values.equals(array.values);
        }
        if (this.values.size() != array.values.size()) {
            return false;
        }
        if (!ignoreArrayOrder) {
            Iterator<JSONValue> thisIterator = this.values.iterator();
            Iterator<JSONValue> thatIterator = array.values.iterator();
            while (thisIterator.hasNext()) {
                JSONValue thatValue;
                JSONValue thisValue = thisIterator.next();
                if (thisValue.equals(thatValue = thatIterator.next(), ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder)) continue;
                return false;
            }
            return true;
        }
        ArrayList<JSONValue> thatValues = new ArrayList<JSONValue>(array.values);
        for (JSONValue thisValue : this.values) {
            boolean found = false;
            Iterator<JSONValue> thatIterator = thatValues.iterator();
            while (thatIterator.hasNext()) {
                JSONValue thatValue = thatIterator.next();
                if (!thisValue.equals(thatValue, ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder)) continue;
                found = true;
                thatIterator.remove();
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(@NotNull JSONValue v, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        return v instanceof JSONArray && this.equals((JSONArray)v, ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder);
    }

    public boolean contains(@NotNull JSONValue value, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder, boolean recursive) {
        for (JSONValue v : this.values) {
            if (v.equals(value, ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder)) {
                return true;
            }
            if (!recursive || !(v instanceof JSONArray) || !((JSONArray)v).contains(value, ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder, recursive)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuilder buffer = new StringBuilder();
            this.toString(buffer);
            this.stringRepresentation = buffer.toString();
        }
        return this.stringRepresentation;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        if (this.stringRepresentation != null) {
            buffer.append(this.stringRepresentation);
            return;
        }
        buffer.append("[ ");
        Iterator<JSONValue> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (iterator.hasNext()) {
                buffer.append(',');
            }
            buffer.append(' ');
        }
        buffer.append(']');
    }

    @Override
    @NotNull
    public String toSingleLineString() {
        StringBuilder buffer = new StringBuilder();
        this.toSingleLineString(buffer);
        return buffer.toString();
    }

    @Override
    public void toSingleLineString(@NotNull StringBuilder buffer) {
        buffer.append("[ ");
        Iterator<JSONValue> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            iterator.next().toSingleLineString(buffer);
            if (iterator.hasNext()) {
                buffer.append(',');
            }
            buffer.append(' ');
        }
        buffer.append(']');
    }

    @Override
    @NotNull
    public String toNormalizedString() {
        StringBuilder buffer = new StringBuilder();
        this.toNormalizedString(buffer);
        return buffer.toString();
    }

    @Override
    public void toNormalizedString(@NotNull StringBuilder buffer) {
        this.toNormalizedString(buffer, false, true, false);
    }

    @Override
    @NotNull
    public String toNormalizedString(boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        StringBuilder buffer = new StringBuilder();
        this.toNormalizedString(buffer, ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder);
        return buffer.toString();
    }

    @Override
    public void toNormalizedString(@NotNull StringBuilder buffer, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        ArrayList<String> normalizedValues = new ArrayList<String>(this.values.size());
        for (JSONValue v : this.values) {
            normalizedValues.add(v.toNormalizedString(ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder));
        }
        if (ignoreArrayOrder) {
            Collections.sort(normalizedValues);
        }
        buffer.append('[');
        Iterator iterator = normalizedValues.iterator();
        while (iterator.hasNext()) {
            buffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append(']');
    }

    @Override
    @NotNull
    public JSONArray toNormalizedValue(boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        ArrayList<JSONValue> normalizedValues = new ArrayList<JSONValue>(this.values.size());
        for (JSONValue v : this.values) {
            normalizedValues.add(v.toNormalizedValue(ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder));
        }
        if (ignoreArrayOrder) {
            Collections.sort(normalizedValues);
        }
        return new JSONArray(normalizedValues);
    }

    @Override
    public void appendToJSONBuffer(@NotNull JSONBuffer buffer) {
        buffer.beginArray();
        for (JSONValue value : this.values) {
            value.appendToJSONBuffer(buffer);
        }
        buffer.endArray();
    }

    @Override
    public void appendToJSONBuffer(@NotNull String fieldName, @NotNull JSONBuffer buffer) {
        buffer.beginArray(fieldName);
        for (JSONValue value : this.values) {
            value.appendToJSONBuffer(buffer);
        }
        buffer.endArray();
    }
}

