/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore.validation;

import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import java.util.function.Supplier;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.modules.blobstore.validation.EventsourcingStorageStrategy;
import org.apache.james.server.blob.deduplication.StorageStrategy;

public class BlobStoreConfigurationValidationStartUpCheck
implements StartUpCheck {
    private static final String BLOB_STORE_CONFIGURATION_VALIDATION = "blobStore-configuration-validation";
    private final StorageStrategySupplier storageStrategySupplier;
    private final EventsourcingStorageStrategy eventsourcingStorageStrategy;

    @Inject
    @VisibleForTesting
    public BlobStoreConfigurationValidationStartUpCheck(StorageStrategySupplier storageStrategySupplier, EventsourcingStorageStrategy eventsourcingStorageStrategy) {
        this.storageStrategySupplier = storageStrategySupplier;
        this.eventsourcingStorageStrategy = eventsourcingStorageStrategy;
    }

    public StartUpCheck.CheckResult check() {
        try {
            this.eventsourcingStorageStrategy.registerStorageStrategy((StorageStrategy)this.storageStrategySupplier.get());
            return StartUpCheck.CheckResult.builder().checkName(BLOB_STORE_CONFIGURATION_VALIDATION).resultType(StartUpCheck.ResultType.GOOD).build();
        }
        catch (IllegalStateException e) {
            return StartUpCheck.CheckResult.builder().checkName(BLOB_STORE_CONFIGURATION_VALIDATION).resultType(StartUpCheck.ResultType.BAD).description(e.getMessage()).build();
        }
    }

    public String checkName() {
        return BLOB_STORE_CONFIGURATION_VALIDATION;
    }

    @FunctionalInterface
    public static interface StorageStrategySupplier
    extends Supplier<StorageStrategy> {
    }
}

