/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import java.util.Objects;
import org.apache.jena.rdfconnection.Isolation;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkDataset;
import org.apache.jena.sparql.core.DatasetGraph;

public class RDFLinkDatasetBuilder {
    private DatasetGraph dataset = null;
    private Isolation isolation = Isolation.NONE;

    public static RDFLink connect(DatasetGraph dsg) {
        return new RDFLinkDataset(dsg, Isolation.NONE);
    }

    public static RDFLink connect(DatasetGraph dsg, Isolation isolation) {
        return new RDFLinkDataset(dsg, isolation);
    }

    public static RDFLinkDatasetBuilder newBuilder() {
        return new RDFLinkDatasetBuilder();
    }

    private RDFLinkDatasetBuilder() {
    }

    public RDFLinkDatasetBuilder dataset(DatasetGraph dataset) {
        Objects.requireNonNull(dataset);
        this.dataset = dataset;
        return this;
    }

    public RDFLinkDatasetBuilder isolation(Isolation isolation) {
        Objects.requireNonNull(isolation);
        this.isolation = isolation;
        return this;
    }

    public RDFLink build() {
        Objects.requireNonNull(this.dataset, "No dataset for RDFLinkDataset");
        return new RDFLinkDataset(this.dataset, this.isolation);
    }
}

