/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90.compressing;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.compressing.MatchingReaders;
import org.apache.lucene.codecs.lucene90.compressing.FieldsIndex;
import org.apache.lucene.codecs.lucene90.compressing.FieldsIndexWriter;
import org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingTermVectorsReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.internal.hppc.IntHashSet;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.packed.BlockPackedWriter;
import org.apache.lucene.util.packed.DirectWriter;
import org.apache.lucene.util.packed.PackedInts;

public final class Lucene90CompressingTermVectorsWriter
extends TermVectorsWriter {
    static final String VECTORS_EXTENSION = "tvd";
    static final String VECTORS_INDEX_EXTENSION = "tvx";
    static final String VECTORS_META_EXTENSION = "tvm";
    static final String VECTORS_INDEX_CODEC_NAME = "Lucene90TermVectorsIndex";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    static final int META_VERSION_START = 0;
    static final int PACKED_BLOCK_SIZE = 64;
    static final int POSITIONS = 1;
    static final int OFFSETS = 2;
    static final int PAYLOADS = 4;
    static final int FLAGS_BITS = DirectWriter.bitsRequired(7L);
    private final String segment;
    private FieldsIndexWriter indexWriter;
    private IndexOutput metaStream;
    private IndexOutput vectorsStream;
    private final CompressionMode compressionMode;
    private final Compressor compressor;
    private final int chunkSize;
    private long numChunks;
    private long numDirtyChunks;
    private long numDirtyDocs;
    private int numDocs;
    private final Deque<DocData> pendingDocs;
    private DocData curDoc;
    private FieldData curField;
    private final BytesRef lastTerm;
    private int[] positionsBuf;
    private int[] startOffsetsBuf;
    private int[] lengthsBuf;
    private int[] payloadLengthsBuf;
    private final ByteBuffersDataOutput termSuffixes;
    private final ByteBuffersDataOutput payloadBytes;
    private final BlockPackedWriter writer;
    private final int maxDocsPerChunk;
    private final ByteBuffersDataOutput scratchBuffer = ByteBuffersDataOutput.newResettableInstance();
    static final String BULK_MERGE_ENABLED_SYSPROP = Lucene90CompressingTermVectorsWriter.class.getName() + ".enableBulkMerge";
    static final boolean BULK_MERGE_ENABLED;

    private DocData addDocData(int numVectorFields) {
        DocData doc;
        FieldData last = null;
        Iterator<DocData> it = this.pendingDocs.descendingIterator();
        while (it.hasNext()) {
            DocData doc2 = it.next();
            if (doc2.fields.isEmpty()) continue;
            last = doc2.fields.getLast();
            break;
        }
        if (last == null) {
            doc = new DocData(numVectorFields, 0, 0, 0);
        } else {
            int posStart = last.posStart + (last.hasPositions ? last.totalPositions : 0);
            int offStart = last.offStart + (last.hasOffsets ? last.totalPositions : 0);
            int payStart = last.payStart + (last.hasPayloads ? last.totalPositions : 0);
            doc = new DocData(numVectorFields, posStart, offStart, payStart);
        }
        this.pendingDocs.add(doc);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene90CompressingTermVectorsWriter(Directory directory, SegmentInfo si, String segmentSuffix, IOContext context2, String formatName, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockShift) throws IOException {
        assert (directory != null);
        this.segment = si.name;
        this.compressionMode = compressionMode;
        this.compressor = compressionMode.newCompressor();
        this.chunkSize = chunkSize;
        this.maxDocsPerChunk = maxDocsPerChunk;
        this.numDocs = 0;
        this.pendingDocs = new ArrayDeque<DocData>();
        this.termSuffixes = ByteBuffersDataOutput.newResettableInstance();
        this.payloadBytes = ByteBuffersDataOutput.newResettableInstance();
        this.lastTerm = new BytesRef(ArrayUtil.oversize(30, 1));
        boolean success = false;
        try {
            this.metaStream = directory.createOutput(IndexFileNames.segmentFileName(this.segment, segmentSuffix, VECTORS_META_EXTENSION), context2);
            CodecUtil.writeIndexHeader(this.metaStream, "Lucene90TermVectorsIndexMeta", 0, si.getId(), segmentSuffix);
            assert ((long)CodecUtil.indexHeaderLength("Lucene90TermVectorsIndexMeta", segmentSuffix) == this.metaStream.getFilePointer());
            this.vectorsStream = directory.createOutput(IndexFileNames.segmentFileName(this.segment, segmentSuffix, VECTORS_EXTENSION), context2);
            CodecUtil.writeIndexHeader(this.vectorsStream, formatName, 0, si.getId(), segmentSuffix);
            assert ((long)CodecUtil.indexHeaderLength(formatName, segmentSuffix) == this.vectorsStream.getFilePointer());
            this.indexWriter = new FieldsIndexWriter(directory, this.segment, segmentSuffix, VECTORS_INDEX_EXTENSION, VECTORS_INDEX_CODEC_NAME, si.getId(), blockShift, context2);
            this.metaStream.writeVInt(2);
            this.metaStream.writeVInt(chunkSize);
            this.writer = new BlockPackedWriter(this.vectorsStream, 64);
            this.positionsBuf = new int[1024];
            this.startOffsetsBuf = new int[1024];
            this.lengthsBuf = new int[1024];
            this.payloadLengthsBuf = new int[1024];
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.metaStream, this.vectorsStream, this.indexWriter, this.indexWriter);
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.metaStream, this.vectorsStream, this.indexWriter);
        }
        finally {
            this.metaStream = null;
            this.vectorsStream = null;
            this.indexWriter = null;
        }
    }

    @Override
    public void startDocument(int numVectorFields) throws IOException {
        this.curDoc = this.addDocData(numVectorFields);
    }

    @Override
    public void finishDocument() throws IOException {
        this.payloadBytes.copyTo(this.termSuffixes);
        this.payloadBytes.reset();
        ++this.numDocs;
        if (this.triggerFlush()) {
            this.flush(false);
        }
        this.curDoc = null;
    }

    @Override
    public void startField(FieldInfo info, int numTerms, boolean positions, boolean offsets, boolean payloads) throws IOException {
        this.curField = this.curDoc.addField(info.number, numTerms, positions, offsets, payloads);
        this.lastTerm.length = 0;
    }

    @Override
    public void finishField() throws IOException {
        this.curField = null;
    }

    @Override
    public void startTerm(BytesRef term, int freq) throws IOException {
        assert (freq >= 1);
        int prefix = this.lastTerm.length == 0 ? 0 : StringHelper.bytesDifference(this.lastTerm, term);
        this.curField.addTerm(freq, prefix, term.length - prefix);
        this.termSuffixes.writeBytes(term.bytes, term.offset + prefix, term.length - prefix);
        if (this.lastTerm.bytes.length < term.length) {
            this.lastTerm.bytes = new byte[ArrayUtil.oversize(term.length, 1)];
        }
        this.lastTerm.offset = 0;
        this.lastTerm.length = term.length;
        System.arraycopy(term.bytes, term.offset, this.lastTerm.bytes, 0, term.length);
    }

    @Override
    public void addPosition(int position, int startOffset, int endOffset, BytesRef payload) throws IOException {
        assert (this.curField.flags != 0);
        this.curField.addPosition(position, startOffset, endOffset - startOffset, payload == null ? 0 : payload.length);
        if (this.curField.hasPayloads && payload != null) {
            this.payloadBytes.writeBytes(payload.bytes, payload.offset, payload.length);
        }
    }

    private boolean triggerFlush() {
        return this.termSuffixes.size() >= (long)this.chunkSize || this.pendingDocs.size() >= this.maxDocsPerChunk;
    }

    private void flush(boolean force) throws IOException {
        assert (force != this.triggerFlush());
        int chunkDocs = this.pendingDocs.size();
        assert (chunkDocs > 0) : chunkDocs;
        ++this.numChunks;
        if (force) {
            ++this.numDirtyChunks;
            this.numDirtyDocs += (long)this.pendingDocs.size();
        }
        this.indexWriter.writeIndex(chunkDocs, this.vectorsStream.getFilePointer());
        int docBase = this.numDocs - chunkDocs;
        this.vectorsStream.writeVInt(docBase);
        int dirtyBit = force ? 1 : 0;
        this.vectorsStream.writeVInt(chunkDocs << 1 | dirtyBit);
        int totalFields = this.flushNumFields(chunkDocs);
        if (totalFields > 0) {
            int[] fieldNums = this.flushFieldNums();
            this.flushFields(totalFields, fieldNums);
            this.flushFlags(totalFields, fieldNums);
            this.flushNumTerms(totalFields);
            this.flushTermLengths();
            this.flushTermFreqs();
            this.flushPositions();
            this.flushOffsets(fieldNums);
            this.flushPayloadLengths();
            ByteBuffersDataInput content = this.termSuffixes.toDataInput();
            this.compressor.compress(content, this.vectorsStream);
        }
        this.pendingDocs.clear();
        this.curDoc = null;
        this.curField = null;
        this.termSuffixes.reset();
    }

    private int flushNumFields(int chunkDocs) throws IOException {
        if (chunkDocs == 1) {
            int numFields = this.pendingDocs.getFirst().numFields;
            this.vectorsStream.writeVInt(numFields);
            return numFields;
        }
        this.writer.reset(this.vectorsStream);
        int totalFields = 0;
        for (DocData dd : this.pendingDocs) {
            this.writer.add(dd.numFields);
            totalFields += dd.numFields;
        }
        this.writer.finish();
        return totalFields;
    }

    private int[] flushFieldNums() throws IOException {
        IntHashSet fieldNumsSet = new IntHashSet();
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                fieldNumsSet.add(fd.fieldNum);
            }
        }
        int[] fieldNums = fieldNumsSet.toArray();
        Arrays.sort(fieldNums);
        int numDistinctFields = fieldNums.length;
        assert (numDistinctFields > 0);
        int bitsRequired = PackedInts.bitsRequired(fieldNums[numDistinctFields - 1]);
        int token = Math.min(numDistinctFields - 1, 7) << 5 | bitsRequired;
        this.vectorsStream.writeByte((byte)token);
        if (numDistinctFields - 1 >= 7) {
            this.vectorsStream.writeVInt(numDistinctFields - 1 - 7);
        }
        PackedInts.Writer writer = PackedInts.getWriterNoHeader(this.vectorsStream, PackedInts.Format.PACKED, numDistinctFields, bitsRequired, 1);
        int[] nArray = fieldNums;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer fieldNum = nArray[i];
            writer.add(fieldNum.intValue());
        }
        writer.finish();
        return fieldNums;
    }

    private void flushFields(int totalFields, int[] fieldNums) throws IOException {
        this.scratchBuffer.reset();
        DirectWriter writer = DirectWriter.getInstance(this.scratchBuffer, totalFields, DirectWriter.bitsRequired(fieldNums.length - 1));
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                int fieldNumIndex = Arrays.binarySearch(fieldNums, fd.fieldNum);
                assert (fieldNumIndex >= 0);
                writer.add(fieldNumIndex);
            }
        }
        writer.finish();
        this.vectorsStream.writeVLong(this.scratchBuffer.size());
        this.scratchBuffer.copyTo(this.vectorsStream);
    }

    private void flushFlags(int totalFields, int[] fieldNums) throws IOException {
        DirectWriter writer;
        boolean nonChangingFlags = true;
        int[] fieldFlags = new int[fieldNums.length];
        Arrays.fill(fieldFlags, -1);
        block0: for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                int fieldNumOff = Arrays.binarySearch(fieldNums, fd.fieldNum);
                assert (fieldNumOff >= 0);
                if (fieldFlags[fieldNumOff] == -1) {
                    fieldFlags[fieldNumOff] = fd.flags;
                    continue;
                }
                if (fieldFlags[fieldNumOff] == fd.flags) continue;
                nonChangingFlags = false;
                break block0;
            }
        }
        if (nonChangingFlags) {
            this.vectorsStream.writeVInt(0);
            this.scratchBuffer.reset();
            writer = DirectWriter.getInstance(this.scratchBuffer, fieldFlags.length, FLAGS_BITS);
            for (int flags : fieldFlags) {
                assert (flags >= 0);
                writer.add(flags);
            }
            writer.finish();
            this.vectorsStream.writeVInt(Math.toIntExact(this.scratchBuffer.size()));
            this.scratchBuffer.copyTo(this.vectorsStream);
        } else {
            this.vectorsStream.writeVInt(1);
            this.scratchBuffer.reset();
            writer = DirectWriter.getInstance(this.scratchBuffer, totalFields, FLAGS_BITS);
            Object object = this.pendingDocs.iterator();
            while (object.hasNext()) {
                DocData dd = (DocData)object.next();
                for (FieldData fd : dd.fields) {
                    writer.add(fd.flags);
                }
            }
            writer.finish();
            this.vectorsStream.writeVInt(Math.toIntExact(this.scratchBuffer.size()));
            this.scratchBuffer.copyTo(this.vectorsStream);
        }
    }

    private void flushNumTerms(int totalFields) throws IOException {
        int maxNumTerms = 0;
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                maxNumTerms |= fd.numTerms;
            }
        }
        int bitsRequired = DirectWriter.bitsRequired(maxNumTerms);
        this.vectorsStream.writeVInt(bitsRequired);
        this.scratchBuffer.reset();
        DirectWriter writer = DirectWriter.getInstance(this.scratchBuffer, totalFields, bitsRequired);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                writer.add(fd.numTerms);
            }
        }
        writer.finish();
        this.vectorsStream.writeVInt(Math.toIntExact(this.scratchBuffer.size()));
        this.scratchBuffer.copyTo(this.vectorsStream);
    }

    private void flushTermLengths() throws IOException {
        int i;
        this.writer.reset(this.vectorsStream);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                for (i = 0; i < fd.numTerms; ++i) {
                    this.writer.add(fd.prefixLengths[i]);
                }
            }
        }
        this.writer.finish();
        this.writer.reset(this.vectorsStream);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                for (i = 0; i < fd.numTerms; ++i) {
                    this.writer.add(fd.suffixLengths[i]);
                }
            }
        }
        this.writer.finish();
    }

    private void flushTermFreqs() throws IOException {
        this.writer.reset(this.vectorsStream);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                for (int i = 0; i < fd.numTerms; ++i) {
                    this.writer.add(fd.freqs[i] - 1);
                }
            }
        }
        this.writer.finish();
    }

    private void flushPositions() throws IOException {
        this.writer.reset(this.vectorsStream);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                if (!fd.hasPositions) continue;
                int pos = 0;
                for (int i = 0; i < fd.numTerms; ++i) {
                    int previousPosition = 0;
                    for (int j = 0; j < fd.freqs[i]; ++j) {
                        int position = this.positionsBuf[fd.posStart + pos++];
                        this.writer.add(position - previousPosition);
                        previousPosition = position;
                    }
                }
                assert (pos == fd.totalPositions);
            }
        }
        this.writer.finish();
    }

    private void flushOffsets(int[] fieldNums) throws IOException {
        int i;
        int pos;
        boolean hasOffsets = false;
        long[] sumPos = new long[fieldNums.length];
        long[] sumOffsets = new long[fieldNums.length];
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                hasOffsets |= fd.hasOffsets;
                if (!fd.hasOffsets || !fd.hasPositions) continue;
                int fieldNumOff = Arrays.binarySearch(fieldNums, fd.fieldNum);
                pos = 0;
                for (int i2 = 0; i2 < fd.numTerms; ++i2) {
                    int n = fieldNumOff;
                    sumPos[n] = sumPos[n] + (long)this.positionsBuf[fd.posStart + fd.freqs[i2] - 1 + pos];
                    int n2 = fieldNumOff;
                    sumOffsets[n2] = sumOffsets[n2] + (long)this.startOffsetsBuf[fd.offStart + fd.freqs[i2] - 1 + pos];
                    pos += fd.freqs[i2];
                }
                assert (pos == fd.totalPositions);
            }
        }
        if (!hasOffsets) {
            return;
        }
        float[] charsPerTerm = new float[fieldNums.length];
        for (i = 0; i < fieldNums.length; ++i) {
            charsPerTerm[i] = sumPos[i] <= 0L || sumOffsets[i] <= 0L ? 0.0f : (float)((double)sumOffsets[i] / (double)sumPos[i]);
        }
        for (i = 0; i < fieldNums.length; ++i) {
            this.vectorsStream.writeInt(Float.floatToRawIntBits(charsPerTerm[i]));
        }
        this.writer.reset(this.vectorsStream);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                if ((fd.flags & 2) == 0) continue;
                int fieldNumOff = Arrays.binarySearch(fieldNums, fd.fieldNum);
                float cpt = charsPerTerm[fieldNumOff];
                int pos2 = 0;
                for (int i3 = 0; i3 < fd.numTerms; ++i3) {
                    int previousPos = 0;
                    int previousOff = 0;
                    for (int j = 0; j < fd.freqs[i3]; ++j) {
                        int position = fd.hasPositions ? this.positionsBuf[fd.posStart + pos2] : 0;
                        int startOffset = this.startOffsetsBuf[fd.offStart + pos2];
                        this.writer.add(startOffset - previousOff - (int)(cpt * (float)(position - previousPos)));
                        previousPos = position;
                        previousOff = startOffset;
                        ++pos2;
                    }
                }
            }
        }
        this.writer.finish();
        this.writer.reset(this.vectorsStream);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                if ((fd.flags & 2) == 0) continue;
                pos = 0;
                for (int i4 = 0; i4 < fd.numTerms; ++i4) {
                    for (int j = 0; j < fd.freqs[i4]; ++j) {
                        this.writer.add(this.lengthsBuf[fd.offStart + pos++] - fd.prefixLengths[i4] - fd.suffixLengths[i4]);
                    }
                }
                assert (pos == fd.totalPositions);
            }
        }
        this.writer.finish();
    }

    private void flushPayloadLengths() throws IOException {
        this.writer.reset(this.vectorsStream);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.fields) {
                if (!fd.hasPayloads) continue;
                for (int i = 0; i < fd.totalPositions; ++i) {
                    this.writer.add(this.payloadLengthsBuf[fd.payStart + i]);
                }
            }
        }
        this.writer.finish();
    }

    @Override
    public void finish(int numDocs) throws IOException {
        if (!this.pendingDocs.isEmpty()) {
            this.flush(true);
        }
        if (numDocs != this.numDocs) {
            throw new RuntimeException("Wrote " + this.numDocs + " docs, finish called with numDocs=" + numDocs);
        }
        this.indexWriter.finish(numDocs, this.vectorsStream.getFilePointer(), this.metaStream);
        this.metaStream.writeVLong(this.numChunks);
        this.metaStream.writeVLong(this.numDirtyChunks);
        this.metaStream.writeVLong(this.numDirtyDocs);
        CodecUtil.writeFooter(this.metaStream);
        CodecUtil.writeFooter(this.vectorsStream);
    }

    @Override
    public void addProx(int numProx, DataInput positions, DataInput offsets) throws IOException {
        assert (this.curField.hasPositions == (positions != null));
        assert (this.curField.hasOffsets == (offsets != null));
        if (this.curField.hasPositions) {
            int posStart = this.curField.posStart + this.curField.totalPositions;
            if (posStart + numProx > this.positionsBuf.length) {
                this.positionsBuf = ArrayUtil.grow(this.positionsBuf, posStart + numProx);
            }
            int position = 0;
            if (this.curField.hasPayloads) {
                int payStart = this.curField.payStart + this.curField.totalPositions;
                if (payStart + numProx > this.payloadLengthsBuf.length) {
                    this.payloadLengthsBuf = ArrayUtil.grow(this.payloadLengthsBuf, payStart + numProx);
                }
                for (int i = 0; i < numProx; ++i) {
                    int code = positions.readVInt();
                    if ((code & 1) != 0) {
                        int payloadLength;
                        this.payloadLengthsBuf[payStart + i] = payloadLength = positions.readVInt();
                        this.payloadBytes.copyBytes(positions, payloadLength);
                    } else {
                        this.payloadLengthsBuf[payStart + i] = 0;
                    }
                    this.positionsBuf[posStart + i] = position += code >>> 1;
                }
            } else {
                for (int i = 0; i < numProx; ++i) {
                    this.positionsBuf[posStart + i] = position += positions.readVInt() >>> 1;
                }
            }
        }
        if (this.curField.hasOffsets) {
            int offStart = this.curField.offStart + this.curField.totalPositions;
            if (offStart + numProx > this.startOffsetsBuf.length) {
                int newLength = ArrayUtil.oversize(offStart + numProx, 4);
                this.startOffsetsBuf = ArrayUtil.growExact(this.startOffsetsBuf, newLength);
                this.lengthsBuf = ArrayUtil.growExact(this.lengthsBuf, newLength);
            }
            int lastOffset = 0;
            for (int i = 0; i < numProx; ++i) {
                int endOffset;
                int startOffset = lastOffset + offsets.readVInt();
                lastOffset = endOffset = startOffset + offsets.readVInt();
                this.startOffsetsBuf[offStart + i] = startOffset;
                this.lengthsBuf[offStart + i] = endOffset - startOffset;
            }
        }
        this.curField.totalPositions += numProx;
    }

    private void copyChunks(MergeState mergeState, CompressingTermVectorsSub sub, int fromDocID, int toDocID) throws IOException {
        long toPointer;
        Lucene90CompressingTermVectorsReader reader = (Lucene90CompressingTermVectorsReader)mergeState.termVectorsReaders[sub.readerIndex];
        assert (reader.getVersion() == 0);
        assert (reader.getChunkSize() == this.chunkSize);
        assert (reader.getCompressionMode() == this.compressionMode);
        assert (!this.tooDirty(reader));
        assert (mergeState.liveDocs[sub.readerIndex] == null);
        int docID = fromDocID;
        FieldsIndex index = reader.getIndexReader();
        while (docID < toDocID && reader.isLoaded(docID)) {
            this.addAllDocVectors(reader.get(docID++), mergeState);
        }
        if (docID >= toDocID) {
            return;
        }
        long fromPointer = index.getStartPointer(docID);
        long l = toPointer = toDocID == sub.maxDoc ? reader.getMaxPointer() : index.getStartPointer(toDocID);
        if (fromPointer < toPointer) {
            long end;
            if (!this.pendingDocs.isEmpty()) {
                this.flush(true);
            }
            IndexInput rawDocs = reader.getVectorsStream();
            rawDocs.seek(fromPointer);
            do {
                boolean dirtyChunk;
                int base;
                if ((base = rawDocs.readVInt()) != docID) {
                    throw new CorruptIndexException("invalid state: base=" + base + ", docID=" + docID, rawDocs);
                }
                int code = rawDocs.readVInt();
                int bufferedDocs = code >>> 1;
                this.indexWriter.writeIndex(bufferedDocs, this.vectorsStream.getFilePointer());
                this.vectorsStream.writeVInt(this.numDocs);
                this.vectorsStream.writeVInt(code);
                this.numDocs += bufferedDocs;
                if ((docID += bufferedDocs) > toDocID) {
                    throw new CorruptIndexException("invalid state: base=" + base + ", count=" + bufferedDocs + ", toDocID=" + toDocID, rawDocs);
                }
                end = docID == sub.maxDoc ? reader.getMaxPointer() : index.getStartPointer(docID);
                this.vectorsStream.copyBytes(rawDocs, end - rawDocs.getFilePointer());
                ++this.numChunks;
                boolean bl = dirtyChunk = (code & 1) != 0;
                if (!dirtyChunk) continue;
                ++this.numDirtyChunks;
                this.numDirtyDocs += (long)bufferedDocs;
            } while ((fromPointer = end) < toPointer);
        }
        assert (!reader.isLoaded(docID));
        while (docID < toDocID) {
            this.addAllDocVectors(reader.get(docID++), mergeState);
        }
    }

    @Override
    public int merge(MergeState mergeState) throws IOException {
        int numReaders = mergeState.termVectorsReaders.length;
        MatchingReaders matchingReaders = new MatchingReaders(mergeState);
        ArrayList<CompressingTermVectorsSub> subs = new ArrayList<CompressingTermVectorsSub>(numReaders);
        for (int i = 0; i < numReaders; ++i) {
            TermVectorsReader reader = mergeState.termVectorsReaders[i];
            if (reader != null) {
                reader.checkIntegrity();
            }
            boolean bulkMerge = this.canPerformBulkMerge(mergeState, matchingReaders, i);
            subs.add(new CompressingTermVectorsSub(mergeState, bulkMerge, i));
        }
        int docCount = 0;
        DocIDMerger docIDMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
        CompressingTermVectorsSub sub = (CompressingTermVectorsSub)docIDMerger.next();
        while (sub != null) {
            assert (sub.mappedDocID == docCount) : sub.mappedDocID + " != " + docCount;
            if (sub.canPerformBulkMerge) {
                int fromDocID;
                int toDocID = fromDocID = sub.docID;
                CompressingTermVectorsSub current = sub;
                while ((sub = (CompressingTermVectorsSub)docIDMerger.next()) == current) {
                    assert (sub.docID == ++toDocID);
                }
                this.copyChunks(mergeState, current, fromDocID, ++toDocID);
                docCount += toDocID - fromDocID;
                continue;
            }
            TermVectorsReader reader = mergeState.termVectorsReaders[sub.readerIndex];
            Fields vectors = reader != null ? reader.get(sub.docID) : null;
            this.addAllDocVectors(vectors, mergeState);
            ++docCount;
            sub = (CompressingTermVectorsSub)docIDMerger.next();
        }
        this.finish(docCount);
        return docCount;
    }

    boolean tooDirty(Lucene90CompressingTermVectorsReader candidate) {
        return candidate.getNumDirtyDocs() > (long)this.maxDocsPerChunk && candidate.getNumDirtyChunks() * 100L > candidate.getNumChunks();
    }

    private boolean canPerformBulkMerge(MergeState mergeState, MatchingReaders matchingReaders, int readerIndex) {
        if (mergeState.termVectorsReaders[readerIndex] instanceof Lucene90CompressingTermVectorsReader) {
            Lucene90CompressingTermVectorsReader reader = (Lucene90CompressingTermVectorsReader)mergeState.termVectorsReaders[readerIndex];
            return BULK_MERGE_ENABLED && matchingReaders.matchingReaders[readerIndex] && reader.getCompressionMode() == this.compressionMode && reader.getChunkSize() == this.chunkSize && reader.getVersion() == 0 && reader.getPackedIntsVersion() == 2 && mergeState.liveDocs[readerIndex] == null && !this.tooDirty(reader);
        }
        return false;
    }

    @Override
    public long ramBytesUsed() {
        return (long)(this.positionsBuf.length + this.startOffsetsBuf.length + this.lengthsBuf.length + this.payloadLengthsBuf.length) + this.termSuffixes.ramBytesUsed() + this.payloadBytes.ramBytesUsed() + (long)this.lastTerm.bytes.length + this.scratchBuffer.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return List.of(this.termSuffixes, this.payloadBytes);
    }

    static {
        boolean v = true;
        try {
            v = Boolean.parseBoolean(System.getProperty(BULK_MERGE_ENABLED_SYSPROP, "true"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        BULK_MERGE_ENABLED = v;
    }

    private static class CompressingTermVectorsSub
    extends DocIDMerger.Sub {
        final int maxDoc;
        final int readerIndex;
        final boolean canPerformBulkMerge;
        int docID = -1;

        CompressingTermVectorsSub(MergeState mergeState, boolean canPerformBulkMerge, int readerIndex) {
            super(mergeState.docMaps[readerIndex]);
            this.maxDoc = mergeState.maxDocs[readerIndex];
            this.readerIndex = readerIndex;
            this.canPerformBulkMerge = canPerformBulkMerge;
        }

        @Override
        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                return Integer.MAX_VALUE;
            }
            return this.docID;
        }
    }

    private class FieldData {
        final boolean hasPositions;
        final boolean hasOffsets;
        final boolean hasPayloads;
        final int fieldNum;
        final int flags;
        final int numTerms;
        final int[] freqs;
        final int[] prefixLengths;
        final int[] suffixLengths;
        final int posStart;
        final int offStart;
        final int payStart;
        int totalPositions;
        int ord;

        FieldData(int fieldNum, int numTerms, boolean positions, boolean offsets, boolean payloads, int posStart, int offStart, int payStart) {
            this.fieldNum = fieldNum;
            this.numTerms = numTerms;
            this.hasPositions = positions;
            this.hasOffsets = offsets;
            this.hasPayloads = payloads;
            this.flags = (positions ? 1 : 0) | (offsets ? 2 : 0) | (payloads ? 4 : 0);
            this.freqs = new int[numTerms];
            this.prefixLengths = new int[numTerms];
            this.suffixLengths = new int[numTerms];
            this.posStart = posStart;
            this.offStart = offStart;
            this.payStart = payStart;
            this.totalPositions = 0;
            this.ord = 0;
        }

        void addTerm(int freq, int prefixLength, int suffixLength) {
            this.freqs[this.ord] = freq;
            this.prefixLengths[this.ord] = prefixLength;
            this.suffixLengths[this.ord] = suffixLength;
            ++this.ord;
        }

        void addPosition(int position, int startOffset, int length, int payloadLength) {
            if (this.hasPositions) {
                if (this.posStart + this.totalPositions == Lucene90CompressingTermVectorsWriter.this.positionsBuf.length) {
                    Lucene90CompressingTermVectorsWriter.this.positionsBuf = ArrayUtil.grow(Lucene90CompressingTermVectorsWriter.this.positionsBuf);
                }
                Lucene90CompressingTermVectorsWriter.this.positionsBuf[this.posStart + this.totalPositions] = position;
            }
            if (this.hasOffsets) {
                if (this.offStart + this.totalPositions == Lucene90CompressingTermVectorsWriter.this.startOffsetsBuf.length) {
                    int newLength = ArrayUtil.oversize(this.offStart + this.totalPositions, 4);
                    Lucene90CompressingTermVectorsWriter.this.startOffsetsBuf = ArrayUtil.growExact(Lucene90CompressingTermVectorsWriter.this.startOffsetsBuf, newLength);
                    Lucene90CompressingTermVectorsWriter.this.lengthsBuf = ArrayUtil.growExact(Lucene90CompressingTermVectorsWriter.this.lengthsBuf, newLength);
                }
                Lucene90CompressingTermVectorsWriter.this.startOffsetsBuf[this.offStart + this.totalPositions] = startOffset;
                Lucene90CompressingTermVectorsWriter.this.lengthsBuf[this.offStart + this.totalPositions] = length;
            }
            if (this.hasPayloads) {
                if (this.payStart + this.totalPositions == Lucene90CompressingTermVectorsWriter.this.payloadLengthsBuf.length) {
                    Lucene90CompressingTermVectorsWriter.this.payloadLengthsBuf = ArrayUtil.grow(Lucene90CompressingTermVectorsWriter.this.payloadLengthsBuf);
                }
                Lucene90CompressingTermVectorsWriter.this.payloadLengthsBuf[this.payStart + this.totalPositions] = payloadLength;
            }
            ++this.totalPositions;
        }
    }

    private class DocData {
        final int numFields;
        final Deque<FieldData> fields;
        final int posStart;
        final int offStart;
        final int payStart;

        DocData(int numFields, int posStart, int offStart, int payStart) {
            this.numFields = numFields;
            this.fields = new ArrayDeque<FieldData>(numFields);
            this.posStart = posStart;
            this.offStart = offStart;
            this.payStart = payStart;
        }

        FieldData addField(int fieldNum, int numTerms, boolean positions, boolean offsets, boolean payloads) {
            FieldData field;
            if (this.fields.isEmpty()) {
                field = new FieldData(fieldNum, numTerms, positions, offsets, payloads, this.posStart, this.offStart, this.payStart);
            } else {
                FieldData last = this.fields.getLast();
                int posStart = last.posStart + (last.hasPositions ? last.totalPositions : 0);
                int offStart = last.offStart + (last.hasOffsets ? last.totalPositions : 0);
                int payStart = last.payStart + (last.hasPayloads ? last.totalPositions : 0);
                field = new FieldData(fieldNum, numTerms, positions, offsets, payloads, posStart, offStart, payStart);
            }
            this.fields.add(field);
            return field;
        }
    }
}

