/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import org.apache.sis.system.DelayedExecutor;
import org.apache.sis.system.DelayedRunnable;
import org.opengis.referencing.IdentifiedObject;

final class ReferenceKeeper {
    private static final int CAPACITY = 40;
    private static final long EXPIRATION_TIME = 300000000000L;
    private IdentifiedObject[] cache;
    private long[] timestamps;
    private int indexOfLast;
    private boolean hasCleanerTask;

    ReferenceKeeper() {
    }

    final synchronized void markAsUsed(IdentifiedObject object) {
        if (this.cache == null) {
            this.cache = new IdentifiedObject[40];
            this.timestamps = new long[40];
        }
        Long now2 = System.nanoTime();
        if (this.cache[this.indexOfLast] != object && ++this.indexOfLast >= 40) {
            this.indexOfLast = 0;
        }
        this.cache[this.indexOfLast] = object;
        this.timestamps[this.indexOfLast] = now2;
        if (!this.hasCleanerTask) {
            this.scheduleCleanerTask(now2);
        }
    }

    private void scheduleCleanerTask(long now2) {
        DelayedExecutor.schedule(new DelayedRunnable(now2 + 300000000000L){

            @Override
            public void run() {
                ReferenceKeeper.this.clearExpiredEntries();
            }
        });
        this.hasCleanerTask = true;
    }

    private synchronized void clearExpiredEntries() {
        this.hasCleanerTask = false;
        boolean empty = true;
        long now2 = System.nanoTime();
        for (int i = 0; i < 40; ++i) {
            if (now2 - this.timestamps[i] >= 300000000000L) {
                this.cache[i] = null;
                continue;
            }
            empty &= this.cache[i] == null;
        }
        if (empty) {
            this.cache = null;
            this.timestamps = null;
        } else {
            this.scheduleCleanerTask(now2);
        }
    }
}

