/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis.label;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.AxisBreaksProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.BreakLabelsLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalFixedBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalFlexBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.VerticalFixedBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.VerticalFlexBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.Insets;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b \u0018\u0000 &2\u00020\u0001:\u0001&B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001bJ(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0016\u0010 \u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u001f0!H&J9\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0#2\u0016\u0010 \u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u001f0!H\u0000\u00a2\u0006\u0002\b%R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout;", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;)V", "getAxisDomain", "()Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "isHorizontal", "", "()Z", "labelSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "getLabelSpec", "()Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "getOrientation", "()Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "getTheme", "()Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "alignToLabelMargin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "bounds", "alignToLabelMargin$plot_builder", "applyLabelMargins", "applyLabelMargins$plot_builder", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisLength", "", "axisMapper", "Lkotlin/Function1;", "mapToAxis", "", "breaks", "mapToAxis$plot_builder", "Companion", "plot-builder"})
public abstract class AxisLabelsLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final DoubleSpan axisDomain;
    @NotNull
    private final AxisTheme theme;
    @NotNull
    private final LabelSpec labelSpec;
    @NotNull
    public static final String INITIAL_TICK_LABEL = "0000";
    public static final double MIN_TICK_LABEL_DISTANCE = 20.0;

    protected AxisLabelsLayout(@NotNull Orientation orientation, @NotNull DoubleSpan axisDomain, @NotNull AxisTheme theme) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.orientation = orientation;
        this.axisDomain = axisDomain;
        this.theme = theme;
        this.labelSpec = PlotLabelSpecFactory.INSTANCE.axisTick(this.theme);
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final DoubleSpan getAxisDomain() {
        return this.axisDomain;
    }

    @NotNull
    public final AxisTheme getTheme() {
        return this.theme;
    }

    @NotNull
    protected final LabelSpec getLabelSpec() {
        return this.labelSpec;
    }

    protected final boolean isHorizontal() {
        return this.orientation.isHorizontal();
    }

    @NotNull
    public abstract AxisLabelsLayoutInfo doLayout(double var1, @NotNull Function1<? super Double, Double> var3);

    @NotNull
    public final List<Double> mapToAxis$plot_builder(@NotNull List<Double> breaks, @NotNull Function1<? super Double, Double> axisMapper) {
        Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter(axisMapper, (String)"axisMapper");
        return BreakLabelsLayoutUtil.INSTANCE.mapToAxis(breaks, this.axisDomain, axisMapper);
    }

    @NotNull
    public final DoubleRectangle applyLabelMargins$plot_builder(@NotNull DoubleRectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return BreakLabelsLayoutUtil.INSTANCE.applyLabelMargins(bounds, this.theme.showTickMarks() ? this.theme.tickMarkLength() : 0.0, this.theme.tickLabelMargins(), this.orientation);
    }

    @NotNull
    public final DoubleRectangle alignToLabelMargin$plot_builder(@NotNull DoubleRectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return BreakLabelsLayoutUtil.INSTANCE.alignToLabelMargin(bounds, this.theme.showTickMarks() ? this.theme.tickMarkLength() : 0.0, this.theme.tickLabelMargins(), this.orientation);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout$Companion;", "", "()V", "INITIAL_TICK_LABEL", "", "MIN_TICK_LABEL_DISTANCE", "", "horizontalFixedBreaks", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "geomAreaInsets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "horizontalFlexBreaks", "breaksProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisBreaksProvider;", "verticalFixedBreaks", "verticalFlexBreaks", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nAxisLabelsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxisLabelsLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AxisLabelsLayout horizontalFlexBreaks(@NotNull Orientation orientation, @NotNull DoubleSpan axisDomain, @NotNull AxisBreaksProvider breaksProvider, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
            Intrinsics.checkNotNullParameter((Object)breaksProvider, (String)"breaksProvider");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            if (!orientation.isHorizontal()) {
                boolean $i$a$-require-AxisLabelsLayout$Companion$horizontalFlexBreaks$32 = false;
                String $i$a$-require-AxisLabelsLayout$Companion$horizontalFlexBreaks$32 = orientation.toString();
                throw new IllegalArgumentException($i$a$-require-AxisLabelsLayout$Companion$horizontalFlexBreaks$32.toString());
            }
            if (!(!breaksProvider.isFixedBreaks())) {
                boolean bl = false;
                String string = "fixed breaks";
                throw new IllegalArgumentException(string.toString());
            }
            return new HorizontalFlexBreaksLabelsLayout(orientation, axisDomain, breaksProvider, theme);
        }

        @NotNull
        public final AxisLabelsLayout horizontalFixedBreaks(@NotNull Orientation orientation, @NotNull DoubleSpan axisDomain, @NotNull ScaleBreaks breaks, @NotNull Insets geomAreaInsets, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)geomAreaInsets, (String)"geomAreaInsets");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            if (!orientation.isHorizontal()) {
                boolean bl = false;
                String string = orientation.toString();
                throw new IllegalArgumentException(string.toString());
            }
            return new HorizontalFixedBreaksLabelsLayout(orientation, axisDomain, breaks, geomAreaInsets, theme);
        }

        @NotNull
        public final AxisLabelsLayout verticalFlexBreaks(@NotNull Orientation orientation, @NotNull DoubleSpan axisDomain, @NotNull AxisBreaksProvider breaksProvider, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
            Intrinsics.checkNotNullParameter((Object)breaksProvider, (String)"breaksProvider");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            if (!(!orientation.isHorizontal())) {
                boolean $i$a$-require-AxisLabelsLayout$Companion$verticalFlexBreaks$32 = false;
                String $i$a$-require-AxisLabelsLayout$Companion$verticalFlexBreaks$32 = orientation.toString();
                throw new IllegalArgumentException($i$a$-require-AxisLabelsLayout$Companion$verticalFlexBreaks$32.toString());
            }
            if (!(!breaksProvider.isFixedBreaks())) {
                boolean bl = false;
                String string = "fixed breaks";
                throw new IllegalArgumentException(string.toString());
            }
            return new VerticalFlexBreaksLabelsLayout(orientation, axisDomain, breaksProvider, theme);
        }

        @NotNull
        public final AxisLabelsLayout verticalFixedBreaks(@NotNull Orientation orientation, @NotNull DoubleSpan axisDomain, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            if (!(!orientation.isHorizontal())) {
                boolean bl = false;
                String string = orientation.toString();
                throw new IllegalArgumentException(string.toString());
            }
            return new VerticalFixedBreaksLabelsLayout(orientation, axisDomain, breaks, theme);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

