/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.scale.mapper;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.colorspace.ConvertersKt;
import org.jetbrains.letsPlot.commons.colorspace.HCL;
import org.jetbrains.letsPlot.commons.colorspace.LAB;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.scale.Mappers;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\rJ\u001c\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u000fJH\u0010\u0015\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\u0018J@\u0010\u0019\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\rH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/mapper/ColorMapper;", "", "()V", "DEF_GRADIENT_HIGH", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getDEF_GRADIENT_HIGH", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "DEF_GRADIENT_LOW", "getDEF_GRADIENT_LOW", "NA_VALUE", "getNA_VALUE", "gradient", "Lkotlin/Function1;", "", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "low", "high", "naColor", "alpha", "gradientDefault", "gradientHCL", "Lorg/jetbrains/letsPlot/commons/colorspace/HCL;", "autoHueDirection", "", "gradientLAB", "Lorg/jetbrains/letsPlot/commons/colorspace/LAB;", "plot-builder"})
public final class ColorMapper {
    @NotNull
    public static final ColorMapper INSTANCE = new ColorMapper();
    @NotNull
    private static final Color NA_VALUE = Color.Companion.getGRAY();
    @NotNull
    private static final Color DEF_GRADIENT_LOW = Color.Companion.parseHex("#132B43");
    @NotNull
    private static final Color DEF_GRADIENT_HIGH = Color.Companion.parseHex("#56B1F7");

    private ColorMapper() {
    }

    @NotNull
    public final Color getNA_VALUE() {
        return NA_VALUE;
    }

    @NotNull
    public final Color getDEF_GRADIENT_LOW() {
        return DEF_GRADIENT_LOW;
    }

    @NotNull
    public final Color getDEF_GRADIENT_HIGH() {
        return DEF_GRADIENT_HIGH;
    }

    @NotNull
    public final Function1<Double, Color> gradientDefault(@NotNull DoubleSpan domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return this.gradient(domain, DEF_GRADIENT_LOW, DEF_GRADIENT_HIGH, NA_VALUE, 1.0);
    }

    @NotNull
    public final Function1<Double, Color> gradient(@NotNull DoubleSpan domain, @NotNull Color low, @NotNull Color high, @NotNull Color naColor, double alpha) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)low, (String)"low");
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        Intrinsics.checkNotNullParameter((Object)naColor, (String)"naColor");
        return this.gradientLAB(domain, ConvertersKt.labFromRgb((Color)low), ConvertersKt.labFromRgb((Color)high), naColor, alpha);
    }

    public static /* synthetic */ Function1 gradient$default(ColorMapper colorMapper, DoubleSpan doubleSpan, Color color, Color color2, Color color3, double d, int n, Object object) {
        if ((n & 0x10) != 0) {
            d = 1.0;
        }
        return colorMapper.gradient(doubleSpan, color, color2, color3, d);
    }

    private final Function1<Double, Color> gradientLAB(DoubleSpan domain, LAB low, LAB high, Color naColor, double alpha) {
        ScaleMapper mapperA = Mappers.INSTANCE.linear(domain, low.getA(), high.getA(), null);
        ScaleMapper mapperB = Mappers.INSTANCE.linear(domain, low.getB(), high.getB(), null);
        ScaleMapper mapperL = Mappers.INSTANCE.linear(domain, low.getL(), high.getL(), null);
        return (Function1)new Function1<Double, Color>(domain, naColor, (ScaleMapper<Double>)mapperA, (ScaleMapper<Double>)mapperB, (ScaleMapper<Double>)mapperL, alpha){
            final /* synthetic */ DoubleSpan $domain;
            final /* synthetic */ Color $naColor;
            final /* synthetic */ ScaleMapper<Double> $mapperA;
            final /* synthetic */ ScaleMapper<Double> $mapperB;
            final /* synthetic */ ScaleMapper<Double> $mapperL;
            final /* synthetic */ double $alpha;
            {
                this.$domain = $domain;
                this.$naColor = $naColor;
                this.$mapperA = $mapperA;
                this.$mapperB = $mapperB;
                this.$mapperL = $mapperL;
                this.$alpha = $alpha;
                super(1);
            }

            @NotNull
            public final Color invoke(@Nullable Double input) {
                Color color;
                if (input == null || !this.$domain.contains(input.doubleValue())) {
                    color = this.$naColor;
                } else {
                    Object object = this.$mapperA.invoke(input);
                    Intrinsics.checkNotNull((Object)object);
                    double a = ((Number)object).doubleValue();
                    Object object2 = this.$mapperB.invoke(input);
                    Intrinsics.checkNotNull((Object)object2);
                    double b = ((Number)object2).doubleValue();
                    Object object3 = this.$mapperL.invoke(input);
                    Intrinsics.checkNotNull((Object)object3);
                    double l = ((Number)object3).doubleValue();
                    color = ConvertersKt.rgbFromLab((LAB)new LAB(l, a, b), (double)this.$alpha);
                }
                return color;
            }
        };
    }

    static /* synthetic */ Function1 gradientLAB$default(ColorMapper colorMapper, DoubleSpan doubleSpan, LAB lAB, LAB lAB2, Color color, double d, int n, Object object) {
        if ((n & 0x10) != 0) {
            d = 1.0;
        }
        return colorMapper.gradientLAB(doubleSpan, lAB, lAB2, color, d);
    }

    @NotNull
    public final Function1<Double, Color> gradientHCL(@NotNull DoubleSpan domain, @NotNull HCL low, @NotNull HCL high, @NotNull Color naColor, double alpha, boolean autoHueDirection) {
        double dH;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)low, (String)"low");
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        Intrinsics.checkNotNullParameter((Object)naColor, (String)"naColor");
        double lowH = low.getH();
        double highH = high.getH();
        double lowC = low.getC();
        double highC = high.getC();
        if (lowC < 1.0E-4) {
            lowH = highH;
        }
        if (highC < 1.0E-4) {
            highH = lowH;
        }
        if (autoHueDirection && (dH = Math.abs(highH - lowH)) > 180.0) {
            if (highH >= lowH) {
                lowH += 360.0;
            } else {
                highH += 360.0;
            }
        }
        ScaleMapper mapperH = Mappers.INSTANCE.linear(domain, lowH, highH, null);
        ScaleMapper mapperC = Mappers.INSTANCE.linear(domain, lowC, highC, null);
        ScaleMapper mapperL = Mappers.INSTANCE.linear(domain, low.getL(), high.getL(), null);
        return (Function1)new Function1<Double, Color>(domain, naColor, (ScaleMapper<Double>)mapperH, (ScaleMapper<Double>)mapperC, (ScaleMapper<Double>)mapperL, alpha){
            final /* synthetic */ DoubleSpan $domain;
            final /* synthetic */ Color $naColor;
            final /* synthetic */ ScaleMapper<Double> $mapperH;
            final /* synthetic */ ScaleMapper<Double> $mapperC;
            final /* synthetic */ ScaleMapper<Double> $mapperL;
            final /* synthetic */ double $alpha;
            {
                this.$domain = $domain;
                this.$naColor = $naColor;
                this.$mapperH = $mapperH;
                this.$mapperC = $mapperC;
                this.$mapperL = $mapperL;
                this.$alpha = $alpha;
                super(1);
            }

            @NotNull
            public final Color invoke(@Nullable Double input) {
                Color color;
                if (input == null || !this.$domain.contains(input.doubleValue())) {
                    color = this.$naColor;
                } else {
                    Object object = this.$mapperH.invoke(input);
                    Intrinsics.checkNotNull((Object)object);
                    double hue = ((Number)object).doubleValue() % (double)360;
                    double h = hue >= 0.0 ? hue : (double)360 + hue;
                    Object object2 = this.$mapperC.invoke(input);
                    Intrinsics.checkNotNull((Object)object2);
                    double c = ((Number)object2).doubleValue();
                    Object object3 = this.$mapperL.invoke(input);
                    Intrinsics.checkNotNull((Object)object3);
                    double l = ((Number)object3).doubleValue();
                    color = ConvertersKt.rgbFromHcl((HCL)new HCL(h, c, l), (double)this.$alpha);
                }
                return color;
            }
        };
    }

    public static /* synthetic */ Function1 gradientHCL$default(ColorMapper colorMapper, DoubleSpan doubleSpan, HCL hCL, HCL hCL2, Color color, double d, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            d = 1.0;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return colorMapper.gradientHCL(doubleSpan, hCL, hCL2, color, d, bl);
    }
}

