/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.Data;
import org.apache.jorphan.gui.GuiUtils;

@TestElementMetadata(labelResource="simple_config_element")
public class SimpleConfigGui
extends AbstractConfigGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private JTable table;
    private PowerTableModel tableModel;
    private JButton delete;
    private static final String ADD = "add";
    private static final String DELETE = "delete";
    private final boolean displayName;
    private static final String COLUMN_NAMES_0 = "name";
    private static final String COLUMN_NAMES_1 = "value";

    public SimpleConfigGui() {
        this(true);
    }

    public SimpleConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    @Override
    public String getLabelResource() {
        return "simple_config_element";
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        this.tableModel.clearData();
        PropertyIterator iter = el.propertyIterator();
        while (iter.hasNext()) {
            JMeterProperty prop = iter.next();
            this.tableModel.addRow(new Object[]{prop.getName(), prop.getStringValue()});
        }
        this.checkDeleteStatus();
    }

    @Override
    public TestElement createTestElement() {
        ConfigTestElement el = new ConfigTestElement();
        this.modifyTestElement(el);
        return el;
    }

    @Override
    public void modifyTestElement(TestElement el) {
        GuiUtils.stopTableEditing((JTable)this.table);
        Data model = this.tableModel.getData();
        model.reset();
        while (model.next()) {
            el.setProperty(new StringProperty((String)model.getColumnValue(COLUMN_NAMES_0), (String)model.getColumnValue(COLUMN_NAMES_1)));
        }
        super.configureTestElement(el);
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 10));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add((Component)this.makeTitlePanel(), "North");
        }
        this.add(this.createTablePanel(), "Center");
        this.add(Box.createVerticalStrut(70), "West");
        this.add((Component)this.createButtonPanel(), "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(DELETE)) {
            this.deleteArgument();
        } else if (action.equals(ADD)) {
            this.addArgument();
        }
    }

    private Component createTablePanel() {
        this.tableModel = new PowerTableModel(new String[]{COLUMN_NAMES_0, COLUMN_NAMES_1}, new Class[]{String.class, String.class});
        this.table = new JTable(this.tableModel);
        JMeterUtils.applyHiDPI(this.table);
        this.table.getTableHeader().setDefaultRenderer(new HeaderAsPropertyRenderer());
        this.table.setSelectionMode(0);
        return this.makeScrollPane(this.table);
    }

    private JPanel createButtonPanel() {
        JButton add = new JButton(JMeterUtils.getResString(ADD));
        add.setActionCommand(ADD);
        add.addActionListener(this);
        add.setEnabled(true);
        this.delete = new JButton(JMeterUtils.getResString(DELETE));
        this.delete.setActionCommand(DELETE);
        this.delete.addActionListener(this);
        this.checkDeleteStatus();
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(add);
        buttonPanel.add(this.delete);
        return buttonPanel;
    }

    protected void checkDeleteStatus() {
        if (this.tableModel.getRowCount() == 0) {
            this.delete.setEnabled(false);
        } else {
            this.delete.setEnabled(true);
        }
    }

    protected void addArgument() {
        GuiUtils.stopTableEditing((JTable)this.table);
        this.tableModel.addNewRow();
        this.tableModel.fireTableDataChanged();
        this.delete.setEnabled(true);
        int rowToSelect = this.tableModel.getRowCount() - 1;
        this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
    }

    protected void stopTableEditing() {
        GuiUtils.stopTableEditing((JTable)this.table);
    }

    protected void deleteArgument() {
        GuiUtils.cancelEditing((JTable)this.table);
        int rowSelected = this.table.getSelectedRow();
        if (rowSelected >= 0) {
            this.tableModel.removeRow(rowSelected);
            this.tableModel.fireTableDataChanged();
            if (this.tableModel.getRowCount() == 0) {
                this.delete.setEnabled(false);
            } else {
                int rowToSelect = rowSelected;
                if (rowSelected >= this.tableModel.getRowCount()) {
                    rowToSelect = rowSelected - 1;
                }
                this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
            }
        }
    }
}

