/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;

public class CollectionProperty
extends MultiProperty {
    private static final long serialVersionUID = 221L;
    private Collection<JMeterProperty> value;
    private transient Collection<JMeterProperty> savedValue;

    public CollectionProperty(String name, Collection<?> value) {
        super(name);
        this.value = this.normalizeList(value);
    }

    public CollectionProperty() {
        this.value = new ArrayList<JMeterProperty>();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CollectionProperty && this.value != null) {
            return this.value.equals(((JMeterProperty)o).getObjectValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public void remove(String prop) {
        PropertyIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getName().equals(prop)) continue;
            iter.remove();
        }
    }

    public void set(int index, String prop) {
        if (this.value instanceof List) {
            ((List)this.value).set(index, new StringProperty(prop, prop));
        }
    }

    public void set(int index, JMeterProperty prop) {
        if (this.value instanceof List) {
            ((List)this.value).set(index, prop);
        }
    }

    public JMeterProperty get(int row) {
        if (this.value instanceof List) {
            return (JMeterProperty)((List)this.value).get(row);
        }
        return null;
    }

    public void remove(int index) {
        if (this.value instanceof List) {
            ((List)this.value).remove(index);
        }
    }

    @Override
    public void setObjectValue(Object v) {
        if (v instanceof Collection) {
            this.setCollection((Collection)v);
        }
    }

    @Override
    public PropertyIterator iterator() {
        return this.getIterator(this.value);
    }

    @Override
    public String getStringValue() {
        return this.value.toString();
    }

    @Override
    public Object getObjectValue() {
        return this.value;
    }

    public int size() {
        return this.value.size();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public CollectionProperty clone() {
        CollectionProperty prop = (CollectionProperty)super.clone();
        prop.value = this.cloneCollection();
        return prop;
    }

    private Collection<JMeterProperty> cloneCollection() {
        try {
            Collection newCol = (Collection)this.value.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (JMeterProperty jMeterProperty : this) {
                newCol.add(jMeterProperty.clone());
            }
            return newCol;
        }
        catch (Exception e) {
            log.error("Couldn't clone collection", (Throwable)e);
            return this.value;
        }
    }

    public void setCollection(Collection<?> coll) {
        this.value = this.normalizeList(coll);
    }

    @Override
    public void clear() {
        this.value.clear();
    }

    @Override
    public void addProperty(JMeterProperty prop) {
        this.value.add(prop);
    }

    public void addItem(Object item) {
        this.addProperty(this.convertObject(item));
    }

    @Override
    protected Class<? extends JMeterProperty> getPropertyType() {
        if (this.value != null && !this.value.isEmpty()) {
            return this.value.iterator().next().getClass();
        }
        return NullProperty.class;
    }

    @Override
    public void recoverRunningVersion(TestElement owner) {
        if (this.savedValue != null) {
            this.value = this.savedValue;
        }
        this.recoverRunningVersionOfSubElements(owner);
    }

    @Override
    public void setRunningVersion(boolean running) {
        super.setRunningVersion(running);
        this.savedValue = running ? this.value : null;
    }
}

