/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.jetty;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.microservice.LogConfig;
import org.apache.juneau.microservice.MicroserviceBuilder;
import org.apache.juneau.microservice.MicroserviceListener;
import org.apache.juneau.microservice.console.ConsoleCommand;
import org.apache.juneau.microservice.jetty.JettyMicroservice;
import org.apache.juneau.microservice.jetty.JettyMicroserviceListener;
import org.apache.juneau.microservice.jetty.JettyServerFactory;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.svl.Var;
import org.apache.juneau.utils.Args;

public class JettyMicroserviceBuilder
extends MicroserviceBuilder {
    String jettyXml;
    int[] ports;
    Boolean jettyXmlResolveVars;
    Map<String, Servlet> servlets = new LinkedHashMap<String, Servlet>();
    Map<String, Object> servletAttributes = new LinkedHashMap<String, Object>();
    JettyMicroserviceListener listener;
    JettyServerFactory factory;

    protected JettyMicroserviceBuilder() {
    }

    protected JettyMicroserviceBuilder(JettyMicroserviceBuilder copyFrom) {
        super((MicroserviceBuilder)copyFrom);
        this.jettyXml = copyFrom.jettyXml;
        this.ports = copyFrom.ports;
        this.jettyXmlResolveVars = copyFrom.jettyXmlResolveVars;
        this.servlets = new LinkedHashMap<String, Servlet>(copyFrom.servlets);
        this.servletAttributes = new LinkedHashMap<String, Object>(copyFrom.servletAttributes);
        this.listener = copyFrom.listener;
    }

    public JettyMicroserviceBuilder copy() {
        return new JettyMicroserviceBuilder(this);
    }

    public JettyMicroserviceBuilder jettyXml(Object jettyXml, boolean resolveVars) throws IOException {
        if (jettyXml instanceof String) {
            this.jettyXml = IOUtils.read((File)this.resolveFile(jettyXml.toString()));
        } else if (jettyXml instanceof File) {
            this.jettyXml = IOUtils.read((File)((File)jettyXml));
        } else if (jettyXml instanceof InputStream) {
            this.jettyXml = IOUtils.read((InputStream)((InputStream)jettyXml));
        } else if (jettyXml instanceof Reader) {
            this.jettyXml = IOUtils.read((Reader)((Reader)jettyXml));
        } else {
            throw new FormattedRuntimeException("Invalid object type passed to jettyXml(Object)", new Object[]{jettyXml == null ? null : jettyXml.getClass().getName()});
        }
        this.jettyXmlResolveVars = resolveVars;
        return this;
    }

    public JettyMicroserviceBuilder ports(int ... ports) {
        this.ports = ports;
        return this;
    }

    public JettyMicroserviceBuilder servlet(Class<? extends RestServlet> c) throws ExecutableException {
        RestServlet rs;
        try {
            rs = c.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ExecutableException((Throwable)e);
        }
        return this.servlet((Servlet)rs, '/' + rs.getPath());
    }

    public JettyMicroserviceBuilder servlet(Class<? extends Servlet> c, String path) throws ExecutableException {
        try {
            return this.servlet(c.newInstance(), path);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ExecutableException((Throwable)e);
        }
    }

    public JettyMicroserviceBuilder servlet(Servlet servlet, String path) {
        this.servlets.put(path, servlet);
        return this;
    }

    public JettyMicroserviceBuilder servlets(Map<String, Servlet> servlets) {
        if (servlets != null) {
            this.servlets.putAll(servlets);
        }
        return this;
    }

    public JettyMicroserviceBuilder servletAttribute(String name, Object value) {
        this.servletAttributes.put(name, value);
        return this;
    }

    public JettyMicroserviceBuilder servletAttribute(Map<String, Object> values) {
        if (values != null) {
            this.servletAttributes.putAll(values);
        }
        return this;
    }

    public JettyMicroserviceBuilder jettyServerFactory(JettyServerFactory value) {
        this.factory = value;
        return this;
    }

    public JettyMicroservice build() throws Exception {
        return new JettyMicroservice(this);
    }

    public JettyMicroserviceBuilder args(Args args) {
        super.args(args);
        return this;
    }

    public JettyMicroserviceBuilder args(String ... args) {
        super.args(args);
        return this;
    }

    public JettyMicroserviceBuilder manifest(Object manifest) throws IOException {
        super.manifest(manifest);
        return this;
    }

    public JettyMicroserviceBuilder logger(Logger logger) {
        super.logger(logger);
        return this;
    }

    public JettyMicroserviceBuilder logConfig(LogConfig logConfig) {
        return this;
    }

    public JettyMicroserviceBuilder config(Config config) {
        super.config(config);
        return this;
    }

    public JettyMicroserviceBuilder configName(String configName) {
        super.configName(configName);
        return this;
    }

    public JettyMicroserviceBuilder configStore(ConfigStore configStore) {
        super.configStore(configStore);
        return this;
    }

    public JettyMicroserviceBuilder consoleEnabled(boolean consoleEnabled) {
        super.consoleEnabled(consoleEnabled);
        return this;
    }

    public JettyMicroserviceBuilder consoleCommands(ConsoleCommand ... consoleCommands) {
        super.consoleCommands(consoleCommands);
        return this;
    }

    public JettyMicroserviceBuilder console(Scanner consoleReader, PrintWriter consoleWriter) {
        super.console(consoleReader, consoleWriter);
        return this;
    }

    public JettyMicroserviceBuilder vars(Class<? extends Var> ... vars) {
        super.vars((Class[])vars);
        return this;
    }

    public JettyMicroserviceBuilder varContext(String name, Object object) {
        super.varContext(name, object);
        return this;
    }

    public JettyMicroserviceBuilder workingDir(File path) {
        super.workingDir(path);
        return this;
    }

    public JettyMicroserviceBuilder workingDir(String path) {
        super.workingDir(path);
        return this;
    }

    public JettyMicroserviceBuilder listener(JettyMicroserviceListener listener) {
        super.listener((MicroserviceListener)listener);
        this.listener = listener;
        return this;
    }
}

