/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.collections.OList;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.http.exception.BadRequest;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.http.header.Accept;
import org.apache.juneau.http.header.AcceptCharset;
import org.apache.juneau.http.header.AcceptEncoding;
import org.apache.juneau.http.header.AcceptLanguage;
import org.apache.juneau.http.header.Authorization;
import org.apache.juneau.http.header.CacheControl;
import org.apache.juneau.http.header.Connection;
import org.apache.juneau.http.header.ContentLength;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.Date;
import org.apache.juneau.http.header.Expect;
import org.apache.juneau.http.header.From;
import org.apache.juneau.http.header.Host;
import org.apache.juneau.http.header.IfMatch;
import org.apache.juneau.http.header.IfModifiedSince;
import org.apache.juneau.http.header.IfNoneMatch;
import org.apache.juneau.http.header.IfRange;
import org.apache.juneau.http.header.IfUnmodifiedSince;
import org.apache.juneau.http.header.MaxForwards;
import org.apache.juneau.http.header.Pragma;
import org.apache.juneau.http.header.ProxyAuthorization;
import org.apache.juneau.http.header.Range;
import org.apache.juneau.http.header.Referer;
import org.apache.juneau.http.header.TE;
import org.apache.juneau.http.header.Upgrade;
import org.apache.juneau.http.header.UserAgent;
import org.apache.juneau.http.header.Via;
import org.apache.juneau.http.header.Warning;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.RequestQuery;
import org.apache.juneau.rest.RestRequest;

public class RequestHeaders
extends TreeMap<String, String[]> {
    private static final long serialVersionUID = 1L;
    private final RestRequest req;
    private HttpPartParserSession parser;
    private RequestQuery queryParams;
    private Set<String> allowedQueryParams;

    RequestHeaders(RestRequest req) {
        super(String.CASE_INSENSITIVE_ORDER);
        this.req = req;
    }

    RequestHeaders parser(HttpPartParserSession parser) {
        this.parser = parser;
        return this;
    }

    RequestHeaders queryParams(RequestQuery queryParams, Set<String> allowedQueryParams) {
        this.queryParams = queryParams;
        this.allowedQueryParams = allowedQueryParams;
        return this;
    }

    public RequestHeaders addDefault(Map<String, Object> defaultEntries) {
        if (defaultEntries != null) {
            for (Map.Entry<String, Object> e : defaultEntries.entrySet()) {
                String key = e.getKey();
                Object value = e.getValue();
                String[] v = (String[])this.get(key);
                if (v != null && v.length != 0 && !StringUtils.isEmpty(v[0])) continue;
                this.put(key, StringUtils.stringifyAll(value));
            }
        }
        return this;
    }

    public RequestHeaders addDefault(String name, Object value) {
        return this.addDefault(Collections.singletonMap(name, value));
    }

    @Override
    public RequestHeaders put(String name, Enumeration<String> values) {
        if (values.hasMoreElements()) {
            String v = values.nextElement();
            String[] s = new String[]{v};
            while (values.hasMoreElements()) {
                s = ArrayUtils.append(s, values.nextElement());
            }
            this.put(name, s);
        }
        return this;
    }

    public String getString(String name) {
        String[] v = null;
        if (this.queryParams != null && (this.allowedQueryParams.contains("*") || this.allowedQueryParams.contains(name))) {
            v = this.queryParams.get(name, true);
        }
        if (v == null || v.length == 0) {
            v = (String[])this.get(name);
        }
        if (v == null || v.length == 0) {
            return null;
        }
        return v[v.length - 1];
    }

    public String getString(String name, String def) {
        String s = this.getString(name);
        return StringUtils.isEmpty(s) ? def : s;
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int def) {
        String s = this.getString(name);
        return StringUtils.isEmpty(s) ? def : Integer.parseInt(s);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean def) {
        String s = this.getString(name);
        return StringUtils.isEmpty(s) ? def : Boolean.parseBoolean(s);
    }

    @Override
    public void put(String name, Object value) {
        super.put(name, StringUtils.stringifyAll(value));
    }

    public <T> T get(String name, Class<T> type) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, null, this.getClassMeta(type));
    }

    public <T> T getAll(String name, Class<T> type) throws BadRequest, InternalServerError {
        return this.getAllInner(null, null, name, this.getClassMeta(type));
    }

    public <T> T get(HttpPartParserSession parser, HttpPartSchema schema, String name, Class<T> type) throws BadRequest, InternalServerError {
        return this.getInner(parser, schema, name, null, this.getClassMeta(type));
    }

    public <T> T get(String name, T def, Class<T> type) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, def, this.getClassMeta(type));
    }

    public <T> T get(HttpPartParserSession parser, HttpPartSchema schema, String name, T def, Class<T> type) throws BadRequest, InternalServerError {
        return this.getInner(parser, schema, name, def, this.getClassMeta(type));
    }

    public <T> T get(String name, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, null, this.getClassMeta(type, args));
    }

    public <T> T get(HttpPartParserSession parser, HttpPartSchema schema, String name, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getInner(parser, schema, name, null, this.getClassMeta(type, args));
    }

    public <T> T getAll(HttpPartParserSession parser, HttpPartSchema schema, String name, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getAllInner(parser, schema, name, this.getClassMeta(type, args));
    }

    private <T> T getInner(HttpPartParserSession parser, HttpPartSchema schema, String name, T def, ClassMeta<T> cm) throws BadRequest, InternalServerError {
        if (parser == null) {
            parser = this.req.getPartParser();
        }
        try {
            if (cm.isMapOrBean() && StringUtils.isOneOf(name, "*", "")) {
                OMap m = new OMap();
                for (Map.Entry e : this.entrySet()) {
                    String k = (String)e.getKey();
                    HttpPartSchema pschema = schema == null ? null : schema.getProperty(k);
                    ClassMeta<?> cm2 = cm.getValueType();
                    m.put(k, this.getInner(parser, pschema, k, null, cm2));
                }
                return this.req.getBeanSession().convertToType((Object)m, cm);
            }
            T t = this.parse(parser, schema, this.getString(name), cm);
            return t == null ? def : t;
        }
        catch (SchemaValidationException e) {
            throw new BadRequest((Throwable)e, "Validation failed on header ''{0}''. ", name);
        }
        catch (ParseException e) {
            throw new BadRequest((Throwable)e, "Could not parse header ''{0}''.", name);
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e, "Could not parse header ''{0}''.", name);
        }
    }

    <T> T getAllInner(HttpPartParserSession parser, HttpPartSchema schema, String name, ClassMeta<T> cm) throws BadRequest, InternalServerError {
        String[] p = (String[])this.get(name);
        if (p == null) {
            p = new String[]{};
        }
        if (schema == null) {
            schema = HttpPartSchema.DEFAULT;
        }
        try {
            if (cm.isArray()) {
                ArrayList c = new ArrayList();
                for (int i = 0; i < p.length; ++i) {
                    c.add(this.parse(parser, schema.getItems(), p[i], cm.getElementType()));
                }
                return (T)ArrayUtils.toArray(c, cm.getElementType().getInnerClass());
            }
            if (cm.isCollection()) {
                Collection c = (Collection)(cm.canCreateNewInstance() ? cm.newInstance() : new OList());
                for (int i = 0; i < p.length; ++i) {
                    c.add(this.parse(parser, schema.getItems(), p[i], cm.getElementType()));
                }
                return (T)c;
            }
        }
        catch (SchemaValidationException e) {
            throw new BadRequest((Throwable)e, "Validation failed on header ''{0}''. ", name);
        }
        catch (ParseException e) {
            throw new BadRequest((Throwable)e, "Could not parse header ''{0}''.", name);
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e, "Could not parse header ''{0}''.", name);
        }
        throw new InternalServerError("Invalid call to getAll(String, ClassMeta).  Class type must be a Collection or array.");
    }

    private <T> T parse(HttpPartParserSession parser, HttpPartSchema schema, String val, ClassMeta<T> cm) throws SchemaValidationException, ParseException {
        if (parser == null) {
            parser = this.parser;
        }
        return parser.parse(HttpPartType.HEADER, schema, val, cm);
    }

    public RequestHeaders subset(String ... headers) {
        RequestHeaders rh2 = new RequestHeaders(this.req).parser(this.parser).queryParams(this.queryParams, this.allowedQueryParams);
        for (String h : headers) {
            if (!this.containsKey(h)) continue;
            rh2.put(h, this.get(h));
        }
        return rh2;
    }

    public RequestHeaders subset(String headers) {
        return this.subset(StringUtils.split(headers));
    }

    public Accept getAccept() {
        return Accept.of(this.getString("Accept"));
    }

    public AcceptCharset getAcceptCharset() {
        return AcceptCharset.of(this.getString("Accept-Charset"));
    }

    public AcceptEncoding getAcceptEncoding() {
        return AcceptEncoding.of(this.getString("Accept-Encoding"));
    }

    public AcceptLanguage getAcceptLanguage() {
        return AcceptLanguage.of(this.getString("Accept-Language"));
    }

    public Authorization getAuthorization() {
        return Authorization.of(this.getString("Authorization"));
    }

    public CacheControl getCacheControl() {
        return CacheControl.of(this.getString("Cache-Control"));
    }

    public Connection getConnection() {
        return Connection.of(this.getString("Connection"));
    }

    public ContentLength getContentLength() {
        return ContentLength.of(this.getString("Content-Length"));
    }

    public ContentType getContentType() {
        return ContentType.of(this.getString("Content-Type"));
    }

    public Date getDate() {
        return Date.of(this.getString("Date"));
    }

    public Expect getExpect() {
        return Expect.of(this.getString("Expect"));
    }

    public From getFrom() {
        return From.of(this.getString("From"));
    }

    public Host getHost() {
        return Host.of(this.getString("Host"));
    }

    public IfMatch getIfMatch() {
        return IfMatch.of(this.getString("If-Match"));
    }

    public IfModifiedSince getIfModifiedSince() {
        return IfModifiedSince.of(this.getString("If-Modified-Since"));
    }

    public IfNoneMatch getIfNoneMatch() {
        return IfNoneMatch.of(this.getString("If-None-Match"));
    }

    public IfRange getIfRange() {
        return IfRange.of(this.getString("If-Range"));
    }

    public IfUnmodifiedSince getIfUnmodifiedSince() {
        return IfUnmodifiedSince.of(this.getString("If-Unmodified-Since"));
    }

    public MaxForwards getMaxForwards() {
        return MaxForwards.of(this.getString("Max-Forwards"));
    }

    public Pragma getPragma() {
        return Pragma.of(this.getString("Pragma"));
    }

    public ProxyAuthorization getProxyAuthorization() {
        return ProxyAuthorization.of(this.getString("Proxy-Authorization"));
    }

    public Range getRange() {
        return Range.of(this.getString("Range"));
    }

    public Referer getReferer() {
        return Referer.of(this.getString("Referer"));
    }

    public TE getTE() {
        return TE.of(this.getString("TE"));
    }

    public TimeZone getTimeZone() {
        String tz = this.getString("Time-Zone");
        if (tz != null) {
            return TimeZone.getTimeZone(tz);
        }
        return null;
    }

    public UserAgent getUserAgent() {
        return UserAgent.of(this.getString("User-Agent"));
    }

    public Upgrade getUpgrade() {
        return Upgrade.of(this.getString("Upgrade"));
    }

    public Via getVia() {
        return Via.of(this.getString("Via"));
    }

    public Warning getWarning() {
        return Warning.of(this.getString("Warning"));
    }

    public String toString(boolean sorted) {
        AbstractMap m = null;
        m = sorted ? new TreeMap() : new LinkedHashMap();
        for (Map.Entry e : this.entrySet()) {
            String[] v = (String[])e.getValue();
            m.put(e.getKey(), v.length == 1 ? v[0] : v);
        }
        return SimpleJsonSerializer.DEFAULT.toString(m);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    private <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        return this.req.getBeanSession().getClassMeta(type, args);
    }

    private <T> ClassMeta<T> getClassMeta(Class<T> type) {
        return this.req.getBeanSession().getClassMeta(type);
    }
}

