/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.juneau.ConfigException;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.config.event.ConfigEvent;
import org.apache.juneau.config.event.ConfigEventListener;
import org.apache.juneau.config.event.ConfigEventType;
import org.apache.juneau.config.event.ConfigEvents;
import org.apache.juneau.config.internal.ConfigEntry;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.config.store.ConfigStoreListener;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;

public class ConfigMap
implements ConfigStoreListener {
    private final ConfigStore store;
    private volatile String contents;
    final String name;
    private static final AsciiSet MOD_CHARS = AsciiSet.create((String)"#$%&*+^@~");
    private final List<ConfigEvent> changes = Collections.synchronizedList(new ConfigEvents());
    private final Set<ConfigEventListener> listeners = Collections.synchronizedSet(new HashSet());
    final Map<String, ConfigSection> entries = Collections.synchronizedMap(new LinkedHashMap());
    final Map<String, ConfigSection> oentries = Collections.synchronizedMap(new LinkedHashMap());
    final List<Import> imports = new CopyOnWriteArrayList<Import>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ConfigMap(ConfigStore store, String name) throws IOException {
        this.store = store;
        this.name = name;
        this.load(store.read(name));
    }

    ConfigMap(ConfigStore store, String name, String contents) throws IOException {
        this.store = store;
        this.name = name;
        this.load(contents);
    }

    private ConfigMap load(String contents) throws IOException {
        int i;
        if (contents == null) {
            contents = "";
        }
        this.contents = contents;
        this.entries.clear();
        this.oentries.clear();
        for (Import ir : this.imports) {
            ir.unregisterAll();
        }
        this.imports.clear();
        LinkedHashMap<String, ConfigMap> imports = new LinkedHashMap<String, ConfigMap>();
        AbstractList lines = new LinkedList<String>();
        Scanner scanner = new Scanner(contents);
        Object object = null;
        try {
            while (scanner.hasNextLine()) {
                int i2;
                String l;
                String line = scanner.nextLine();
                char c = StringUtils.firstChar((String)line);
                char c2 = StringUtils.lastNonWhitespaceChar((String)line);
                if (c == '[') {
                    l = line.trim();
                    if (c2 != ']' || !this.isValidNewSectionName(l.substring(1, l.length() - 1))) {
                        throw new ConfigException("Invalid section name found in configuration:  {0}", new Object[]{line});
                    }
                } else if (c == '<' && (i2 = (l = line.trim()).indexOf(62)) != -1) {
                    String l2 = l.substring(1, i2);
                    if (!this.isValidConfigName(l2)) {
                        throw new ConfigException("Invalid import config name found in configuration:  {0}", new Object[]{line});
                    }
                    String l3 = l.substring(i2 + 1);
                    if (!StringUtils.isEmpty((String)l3) && StringUtils.firstChar((String)l3) != '#') {
                        throw new ConfigException("Invalid import config name found in configuration:  {0}", new Object[]{line});
                    }
                    String importName = l2.trim();
                    try {
                        if (!imports.containsKey(importName)) {
                            imports.put(importName, this.store.getMap(importName));
                        }
                    }
                    catch (StackOverflowError e) {
                        throw new IOException("Import loop detected in configuration '" + this.name + "'->'" + importName + "'");
                    }
                }
                lines.add(line);
            }
        }
        catch (Throwable line) {
            object = line;
            throw line;
        }
        finally {
            if (scanner != null) {
                if (object != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable line) {
                        ((Throwable)object).addSuppressed(line);
                    }
                } else {
                    scanner.close();
                }
            }
        }
        ArrayList<Import> irl = new ArrayList<Import>(imports.size());
        for (ConfigMap ic : AList.of(imports.values()).riterable()) {
            irl.add(new Import(ic).register(this.listeners));
        }
        this.imports.addAll(irl);
        boolean inserted = false;
        boolean foundComment = false;
        ListIterator<String> li = lines.listIterator();
        while (li.hasNext()) {
            String l = (String)li.next();
            char c = StringUtils.firstNonWhitespaceChar((String)l);
            if (c != '#') {
                if (c != '\u0000' || !foundComment) break;
                li.set("[]");
                inserted = true;
                break;
            }
            foundComment = true;
        }
        if (!inserted) {
            lines.add(0, "[]");
        }
        li = lines.listIterator(lines.size());
        String accumulator = null;
        while (li.hasPrevious()) {
            String l = (String)li.previous();
            char c = StringUtils.firstChar((String)l);
            if (c == '\t') {
                c = StringUtils.firstNonWhitespaceChar((String)l);
                if (c == '#') continue;
                accumulator = accumulator == null ? l.substring(1) : l.substring(1) + "\n" + accumulator;
                li.remove();
                continue;
            }
            if (accumulator == null) continue;
            li.set(l + "\n" + accumulator);
            accumulator = null;
        }
        lines = new ArrayList(lines);
        int last = lines.size() - 1;
        int S1 = 1;
        int S2 = 2;
        int state = S1;
        ArrayList<ConfigSection> sections = new ArrayList<ConfigSection>();
        for (i = last; i >= 0; --i) {
            String l = (String)lines.get(i);
            char c = StringUtils.firstChar((String)l);
            if (state == S1) {
                if (c != '[') continue;
                state = S2;
                continue;
            }
            if (c == '#' || c != '[' && l.indexOf(61) == -1) continue;
            sections.add(new ConfigSection(lines.subList(i + 1, last + 1)));
            last = i + 1;
            state = c == '[' ? S2 : S1;
        }
        sections.add(new ConfigSection(lines.subList(0, last + 1)));
        for (i = sections.size() - 1; i >= 0; --i) {
            ConfigSection cs = (ConfigSection)sections.get(i);
            if (this.entries.containsKey(cs.name)) {
                throw new ConfigException("Duplicate section found in configuration:  [{0}]", new Object[]{cs.name});
            }
            this.entries.put(cs.name, cs);
        }
        this.oentries.putAll(this.entries);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigEntry getEntry(String section, String key) {
        this.checkSectionName(section);
        this.checkKeyName(key);
        this.readLock();
        try {
            Object object;
            ConfigEntry ce;
            ConfigSection cs = this.entries.get(section);
            ConfigEntry configEntry = ce = cs == null ? null : cs.entries.get(key);
            if (ce == null) {
                Import i;
                object = this.imports.iterator();
                while (object.hasNext() && (ce = (i = (Import)object.next()).getConfigMap().getEntry(section, key)) == null) {
                }
            }
            object = ce;
            return object;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPreLines(String section) {
        this.checkSectionName(section);
        this.readLock();
        try {
            ConfigSection cs = this.entries.get(section);
            List<String> list = cs == null ? null : cs.preLines;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public Set<String> getSections() {
        Set<String> s = null;
        if (this.imports.isEmpty()) {
            s = this.entries.keySet();
        } else {
            s = new LinkedHashSet<String>();
            for (Import ir : this.imports) {
                s.addAll(ir.getConfigMap().getSections());
            }
            s.addAll(this.entries.keySet());
        }
        return Collections.unmodifiableSet(s);
    }

    public Set<String> getKeys(String section) {
        this.checkSectionName(section);
        Set<Object> s = null;
        ConfigSection cs = this.entries.get(section);
        if (this.imports.isEmpty()) {
            s = cs == null ? Collections.emptySet() : cs.entries.keySet();
        } else {
            s = new LinkedHashSet();
            for (Import i : this.imports) {
                s.addAll(i.getConfigMap().getKeys(section));
            }
            if (cs != null) {
                s.addAll(cs.entries.keySet());
            }
        }
        return Collections.unmodifiableSet(s);
    }

    public boolean hasSection(String section) {
        this.checkSectionName(section);
        for (Import i : this.imports) {
            if (!i.getConfigMap().hasSection(section)) continue;
            return true;
        }
        return this.entries.get(section) != null;
    }

    public ConfigMap setSection(String section, List<String> preLines) {
        this.checkSectionName(section);
        return this.applyChange(true, ConfigEvent.setSection(this.name, section, preLines));
    }

    public ConfigMap setEntry(String section, String key, String value, String modifiers, String comment, List<String> preLines) {
        this.checkSectionName(section);
        this.checkKeyName(key);
        if (modifiers != null && !MOD_CHARS.containsOnly(modifiers)) {
            throw new ConfigException("Invalid modifiers: {0}", new Object[]{modifiers});
        }
        return this.applyChange(true, ConfigEvent.setEntry(this.name, section, key, value, modifiers, comment, preLines));
    }

    public ConfigMap setImport(String section, String importName, List<String> preLines) {
        throw new UnsupportedOperationException();
    }

    public ConfigMap removeSection(String section) {
        this.checkSectionName(section);
        return this.applyChange(true, ConfigEvent.removeSection(this.name, section));
    }

    public ConfigMap removeEntry(String section, String key) {
        this.checkSectionName(section);
        this.checkKeyName(key);
        return this.applyChange(true, ConfigEvent.removeEntry(this.name, section, key));
    }

    public ConfigMap removeImport(String section, String importName) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigMap applyChange(boolean addToChangeList, ConfigEvent ce) {
        if (ce == null) {
            return this;
        }
        this.writeLock();
        try {
            String section = ce.getSection();
            ConfigSection cs = this.entries.get(section);
            if (ce.getType() == ConfigEventType.SET_ENTRY) {
                ConfigEntry oe;
                if (cs == null) {
                    cs = new ConfigSection(section);
                    this.entries.put(section, cs);
                }
                if ((oe = cs.entries.get(ce.getKey())) == null) {
                    oe = ConfigEntry.NULL;
                }
                cs.addEntry(ce.getKey(), ce.getValue() == null ? oe.value : ce.getValue(), ce.getModifiers() == null ? oe.modifiers : ce.getModifiers(), ce.getComment() == null ? oe.comment : ce.getComment(), ce.getPreLines() == null ? oe.preLines : ce.getPreLines());
            } else if (ce.getType() == ConfigEventType.SET_SECTION) {
                if (cs == null) {
                    cs = new ConfigSection(section);
                    this.entries.put(section, cs);
                }
                if (ce.getPreLines() != null) {
                    cs.setPreLines(ce.getPreLines());
                }
            } else if (ce.getType() == ConfigEventType.REMOVE_ENTRY) {
                if (cs != null) {
                    cs.entries.remove(ce.getKey());
                }
            } else if (ce.getType() == ConfigEventType.REMOVE_SECTION && cs != null) {
                this.entries.remove(section);
            }
            if (addToChangeList) {
                this.changes.add(ce);
            }
        }
        finally {
            this.writeUnlock();
        }
        return this;
    }

    public ConfigMap load(String contents, boolean synchronous) throws IOException, InterruptedException {
        if (synchronous) {
            final CountDownLatch latch = new CountDownLatch(1);
            ConfigStoreListener l = new ConfigStoreListener(){

                @Override
                public void onChange(String contents) {
                    latch.countDown();
                }
            };
            this.store.register(this.name, l);
            this.store.write(this.name, null, contents);
            latch.await(30L, TimeUnit.SECONDS);
            this.store.unregister(this.name, l);
        } else {
            this.store.write(this.name, null, contents);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigMap commit() throws IOException {
        this.writeLock();
        try {
            String newContents = this.asString();
            for (int i = 0; i <= 10; ++i) {
                if (i == 10) {
                    throw new ConfigException("Unable to store contents of config to store.", new Object[0]);
                }
                String currentContents = this.store.write(this.name, this.contents, newContents);
                if (currentContents == null) break;
                this.onChange(currentContents);
            }
            this.changes.clear();
        }
        finally {
            this.writeUnlock();
        }
        return this;
    }

    public ConfigMap register(ConfigEventListener listener) {
        this.listeners.add(listener);
        for (Import ir : this.imports) {
            ir.register(listener);
        }
        return this;
    }

    boolean hasEntry(String section, String key) {
        ConfigSection cs = this.entries.get(section);
        ConfigEntry ce = cs == null ? null : cs.entries.get(key);
        return ce != null;
    }

    public ConfigMap unregister(ConfigEventListener listener) {
        this.listeners.remove(listener);
        for (Import ir : this.imports) {
            ir.register(listener);
        }
        return this;
    }

    public Set<ConfigEventListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    @Override
    public void onChange(String newContents) {
        ConfigEvents changes = null;
        this.writeLock();
        try {
            if (!StringUtils.isEquals((String)this.contents, (String)newContents)) {
                changes = this.findDiffs(newContents);
                this.load(newContents);
                for (ConfigEvent ce : this.changes) {
                    this.applyChange(false, ce);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writeUnlock();
        }
        if (changes != null && !changes.isEmpty()) {
            this.signal(changes);
        }
    }

    public String toString() {
        this.readLock();
        try {
            String string = this.asString();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMap asMap() {
        OMap m = new OMap();
        this.readLock();
        try {
            for (Import i : this.imports) {
                m.putAll((Map)i.getConfigMap().asMap());
            }
            for (ConfigSection cs : this.entries.values()) {
                LinkedHashMap<String, String> m2 = new LinkedHashMap<String, String>();
                for (ConfigEntry ce : cs.entries.values()) {
                    m2.put(ce.key, ce.value);
                }
                m.put((Object)cs.name, m2);
            }
        }
        finally {
            this.readUnlock();
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer writeTo(Writer w) throws IOException {
        this.readLock();
        try {
            for (ConfigSection cs : this.entries.values()) {
                cs.writeTo(w);
            }
        }
        finally {
            this.readUnlock();
        }
        return w;
    }

    public ConfigMap rollback() {
        if (this.changes.size() > 0) {
            this.writeLock();
            try {
                this.changes.clear();
                this.load(this.contents);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.writeUnlock();
            }
        }
        return this;
    }

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    private void checkSectionName(String s) {
        if (!"".equals(s) && !this.isValidNewSectionName(s)) {
            throw new IllegalArgumentException("Invalid section name: '" + s + "'");
        }
    }

    private void checkKeyName(String s) {
        if (!this.isValidKeyName(s)) {
            throw new IllegalArgumentException("Invalid key name: '" + s + "'");
        }
    }

    private boolean isValidKeyName(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '/' && c != '\\' && c != '[' && c != ']' && c != '=' && c != '#') continue;
            return false;
        }
        return true;
    }

    private boolean isValidNewSectionName(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '/' && c != '\\' && c != '[' && c != ']') continue;
            return false;
        }
        return true;
    }

    private boolean isValidConfigName(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c))) continue;
            return false;
        }
        return true;
    }

    private void signal(ConfigEvents changes) {
        if (changes.size() > 0) {
            for (ConfigEventListener l : this.listeners) {
                l.onConfigChange(changes);
            }
        }
    }

    private ConfigEvents findDiffs(String updatedContents) throws IOException {
        ConfigEvents changes = new ConfigEvents();
        ConfigMap newMap = new ConfigMap(this.store, this.name, updatedContents);
        for (Import i : newMap.imports) {
            if (this.imports.contains(i)) continue;
            for (ConfigSection s : i.getConfigMap().entries.values()) {
                for (ConfigEntry e : s.oentries.values()) {
                    if (newMap.hasEntry(s.name, e.key)) continue;
                    changes.add(ConfigEvent.setEntry(this.name, s.name, e.key, e.value, e.modifiers, e.comment, e.preLines));
                }
            }
        }
        for (Import i : this.imports) {
            if (newMap.imports.contains(i)) continue;
            for (ConfigSection s : i.getConfigMap().entries.values()) {
                for (ConfigEntry e : s.oentries.values()) {
                    if (newMap.hasEntry(s.name, e.key)) continue;
                    changes.add(ConfigEvent.removeEntry(this.name, s.name, e.key));
                }
            }
        }
        for (ConfigSection ns : newMap.oentries.values()) {
            ConfigSection s = this.oentries.get(ns.name);
            if (s == null) {
                for (ConfigEntry ne : ns.entries.values()) {
                    changes.add(ConfigEvent.setEntry(this.name, ns.name, ne.key, ne.value, ne.modifiers, ne.comment, ne.preLines));
                }
                continue;
            }
            for (ConfigEntry ne : ns.oentries.values()) {
                ConfigEntry e;
                e = s.oentries.get(ne.key);
                if (e != null && StringUtils.isEquals((String)e.value, (String)ne.value)) continue;
                changes.add(ConfigEvent.setEntry(this.name, s.name, ne.key, ne.value, ne.modifiers, ne.comment, ne.preLines));
            }
            for (ConfigEntry e : s.oentries.values()) {
                ConfigEntry ne = ns.oentries.get(e.key);
                if (ne != null) continue;
                changes.add(ConfigEvent.removeEntry(this.name, s.name, e.key));
            }
        }
        for (ConfigSection s : this.oentries.values()) {
            ConfigSection ns = newMap.oentries.get(s.name);
            if (ns != null) continue;
            for (ConfigEntry e : s.oentries.values()) {
                changes.add(ConfigEvent.removeEntry(this.name, s.name, e.key));
            }
        }
        return changes;
    }

    private String asString() {
        try {
            StringWriter sw = new StringWriter();
            for (ConfigSection cs : this.entries.values()) {
                cs.writeTo(sw);
            }
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    class Import {
        private final ConfigMap configMap;
        private final Map<ConfigEventListener, ConfigEventListener> listenerMap = Collections.synchronizedMap(new LinkedHashMap());

        Import(ConfigMap configMap) {
            this.configMap = configMap;
        }

        synchronized Import register(Collection<ConfigEventListener> listeners) {
            for (ConfigEventListener l : listeners) {
                this.register(l);
            }
            return this;
        }

        synchronized Import register(final ConfigEventListener listener) {
            ConfigEventListener l2 = new ConfigEventListener(){

                @Override
                public void onConfigChange(ConfigEvents events) {
                    ConfigEvents events2 = new ConfigEvents();
                    for (ConfigEvent cev : events) {
                        if (ConfigMap.this.hasEntry(cev.getSection(), cev.getKey())) continue;
                        events2.add(cev);
                    }
                    if (events2.size() > 0) {
                        listener.onConfigChange(events2);
                    }
                }
            };
            this.listenerMap.put(listener, l2);
            this.configMap.register(l2);
            return this;
        }

        synchronized Import unregister(ConfigEventListener listener) {
            this.configMap.unregister(this.listenerMap.remove(listener));
            return this;
        }

        synchronized Import unregisterAll() {
            for (ConfigEventListener l : this.listenerMap.values()) {
                this.configMap.unregister(l);
            }
            this.listenerMap.clear();
            return this;
        }

        String getConfigName() {
            return this.configMap.name;
        }

        ConfigMap getConfigMap() {
            return this.configMap;
        }

        public boolean equals(Object o) {
            Import ir;
            return o instanceof Import && (ir = (Import)o).getConfigName().equals(this.getConfigName());
        }

        public int hashCode() {
            return this.getConfigName().hashCode();
        }
    }

    class ConfigSection {
        final String name;
        final List<String> preLines = Collections.synchronizedList(new ArrayList());
        private final String rawLine;
        final Map<String, ConfigEntry> oentries = Collections.synchronizedMap(new LinkedHashMap());
        final Map<String, ConfigEntry> entries = Collections.synchronizedMap(new LinkedHashMap());

        ConfigSection(String name) {
            this.name = name;
            this.rawLine = "[" + name + "]";
        }

        ConfigSection(List<String> lines) {
            String name = null;
            String rawLine = null;
            int S1 = 1;
            int S2 = 2;
            int state = S1;
            int start = 0;
            for (int i = 0; i < lines.size(); ++i) {
                String l = lines.get(i);
                char c = StringUtils.firstNonWhitespaceChar((String)l);
                if (state == S1) {
                    if (c == '[') {
                        int i1 = l.indexOf(91);
                        int i2 = l.indexOf(93);
                        name = l.substring(i1 + 1, i2).trim();
                        rawLine = l;
                        state = S2;
                        start = i + 1;
                        continue;
                    }
                    this.preLines.add(l);
                    continue;
                }
                if (c == '#' || l.indexOf(61) == -1) continue;
                ConfigEntry e = new ConfigEntry(l, lines.subList(start, i));
                if (this.entries.containsKey(e.key)) {
                    throw new ConfigException("Duplicate entry found in section [{0}] of configuration:  {1}", new Object[]{name, e.key});
                }
                this.entries.put(e.key, e);
                start = i + 1;
            }
            this.name = name;
            this.rawLine = rawLine;
            this.oentries.putAll(this.entries);
        }

        ConfigSection addEntry(String key, String value, String modifiers, String comment, List<String> preLines) {
            ConfigEntry e = new ConfigEntry(key, value, modifiers, comment, preLines);
            this.entries.put(e.key, e);
            return this;
        }

        ConfigSection setPreLines(List<String> preLines) {
            this.preLines.clear();
            this.preLines.addAll(preLines);
            return this;
        }

        Writer writeTo(Writer w) throws IOException {
            for (String s : this.preLines) {
                w.append(s).append('\n');
            }
            if (!this.name.equals("")) {
                w.append(this.rawLine).append('\n');
            } else if (!this.preLines.isEmpty()) {
                w.append('\n');
            }
            for (ConfigEntry e : this.entries.values()) {
                e.writeTo(w);
            }
            return w;
        }
    }
}

