/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.EntityTag;
import org.apache.juneau.internal.StringUtils;

public class BasicEntityTagArrayHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private List<EntityTag> parsed;

    public static BasicEntityTagArrayHeader of(String name, Object value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicEntityTagArrayHeader(name, value);
    }

    public static BasicEntityTagArrayHeader of(String name, Supplier<?> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicEntityTagArrayHeader(name, value);
    }

    public BasicEntityTagArrayHeader(String name, Object value) {
        super(name, value);
        if (!this.isSupplier(value)) {
            this.parsed = this.getParsedValue();
        }
    }

    @Override
    public String getValue() {
        Object o = this.getRawValue();
        if (o instanceof String) {
            return (String)o;
        }
        return StringUtils.join(this.asEntityTags(), ',');
    }

    public List<EntityTag> asEntityTags() {
        return this.getParsedValue();
    }

    private List<EntityTag> getParsedValue() {
        if (this.parsed != null) {
            return this.parsed;
        }
        Object o = this.getRawValue();
        if (o == null) {
            return null;
        }
        if (o instanceof EntityTag[]) {
            return AList.of((EntityTag[])o).unmodifiable();
        }
        AList l = AList.of();
        if (o instanceof Collection) {
            for (Object o2 : (Collection)o) {
                l.add(EntityTag.of(o2));
            }
        } else if (o.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(o); ++i) {
                l.add(EntityTag.of(Array.get(o, i)));
            }
        } else {
            for (String s : StringUtils.split(o.toString())) {
                l.add(EntityTag.of(s));
            }
        }
        return l.unmodifiable();
    }
}

