/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicDateHeader;
import org.apache.juneau.internal.StringUtils;

@Header(value="Retry-After")
public class RetryAfter
extends BasicDateHeader {
    private static final long serialVersionUID = 1L;
    private final Object value;

    public static RetryAfter of(Object value) {
        if (value == null) {
            return null;
        }
        return new RetryAfter(value);
    }

    public static RetryAfter of(Supplier<?> value) {
        if (value == null) {
            return null;
        }
        return new RetryAfter(value);
    }

    public RetryAfter(Object value) {
        super("Retry-After", RetryAfter.dateValue(value));
        this.value = RetryAfter.intValue(value);
    }

    public RetryAfter(String value) {
        this((Object)value);
    }

    private static Object dateValue(Object o) {
        Object o2 = RetryAfter.unwrap(o);
        if (o2 == null || RetryAfter.isInt(o2)) {
            return null;
        }
        return o;
    }

    private static Object intValue(Object o) {
        Object o2 = RetryAfter.unwrap(o);
        if (o2 == null || RetryAfter.isInt(o2)) {
            return o;
        }
        return null;
    }

    private static boolean isInt(Object o) {
        if (o instanceof Number) {
            return true;
        }
        String s = o.toString();
        char c0 = StringUtils.charAt(s, 0);
        return Character.isDigit(c0);
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return super.getValue();
        }
        Object o = RetryAfter.unwrap(this.value);
        return o == null ? null : o.toString();
    }

    public int asInt() {
        if (this.value != null) {
            Object o = RetryAfter.unwrap(this.value);
            return o == null ? -1 : Integer.parseInt(o.toString());
        }
        return -1;
    }
}

