/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.oapi;

import java.io.IOException;
import java.lang.reflect.Array;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.collections.OList;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartDataType;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.transforms.TemporalCalendarSwap;
import org.apache.juneau.transforms.TemporalDateSwap;
import org.apache.juneau.transforms.TemporalSwap;
import org.apache.juneau.uon.UonSerializerSession;

public class OpenApiSerializerSession
extends UonSerializerSession {
    private static final BeanContext BC = BeanContext.DEFAULT;
    private static final ClassMeta<byte[]> CM_ByteArray = BC.getClassMeta(byte[].class);
    private static final ClassMeta<String[]> CM_StringArray = BC.getClassMeta(String[].class);
    private static final ClassMeta<Calendar> CM_Calendar = BC.getClassMeta(Calendar.class);
    private static final ClassMeta<Long> CM_Long = BC.getClassMeta(Long.class);
    private static final ClassMeta<Integer> CM_Integer = BC.getClassMeta(Integer.class);
    private static final ClassMeta<Double> CM_Double = BC.getClassMeta(Double.class);
    private static final ClassMeta<Float> CM_Float = BC.getClassMeta(Float.class);
    private static final ClassMeta<Boolean> CM_Boolean = BC.getClassMeta(Boolean.class);
    private static final HttpPartSchema DEFAULT_SCHEMA = HttpPartSchema.DEFAULT;
    private final OpenApiSerializer ctx;

    protected OpenApiSerializerSession(OpenApiSerializer ctx, SerializerSessionArgs args) {
        super(ctx, false, args);
        this.ctx = ctx;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        try {
            out.getWriter().write(this.serialize(HttpPartType.BODY, this.getSchema(), o));
        }
        catch (SchemaValidationException e) {
            throw new SerializeException(e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String serialize(HttpPartType partType, HttpPartSchema schema, Object value) throws SerializeException, SchemaValidationException {
        void var4_11;
        HttpPartCollectionFormat cf;
        void var4_9;
        void var4_6;
        PojoSwap swap;
        ClassMeta<Map<String, Object>> classMeta = this.getClassMetaForObject(value);
        if (classMeta == null) {
            ClassMeta<Object> classMeta2 = this.object();
        }
        if ((swap = var4_6.getSwap(this)) != null && !var4_6.isDateOrCalendarOrTemporal()) {
            value = this.swap(swap, value);
            ClassMeta<?> classMeta3 = swap.getSwapClassMeta(this);
            if (classMeta3.isObject()) {
                ClassMeta<Object> classMeta4 = this.getClassMetaForObject(value);
            }
        }
        schema = ObjectUtils.firstNonNull(schema, DEFAULT_SCHEMA);
        HttpPartDataType t = schema.getType((ClassMeta<?>)var4_9);
        HttpPartFormat f = schema.getFormat((ClassMeta<?>)var4_9);
        if (f == HttpPartFormat.NO_FORMAT) {
            f = this.ctx.getFormat();
        }
        if ((cf = schema.getCollectionFormat()) == HttpPartCollectionFormat.NO_COLLECTION_FORMAT) {
            cf = this.ctx.getCollectionFormat();
        }
        String out = null;
        schema.validateOutput(value, this.ctx);
        if (var4_9.hasMutaterTo(schema.getParsedType()) || schema.getParsedType().hasMutaterFrom((ClassMeta<?>)var4_9)) {
            value = this.toType(value, schema.getParsedType());
            ClassMeta<?> classMeta5 = schema.getParsedType();
        }
        if (var4_11.isUri()) {
            value = this.getUriResolver().resolve(value);
            ClassMeta<String> classMeta6 = this.string();
        }
        if (value != null) {
            void var4_13;
            if (t == HttpPartDataType.STRING) {
                if (f == HttpPartFormat.BYTE) {
                    out = StringUtils.base64Encode(this.toType(value, CM_ByteArray));
                } else if (f == HttpPartFormat.BINARY) {
                    out = StringUtils.toHex(this.toType(value, CM_ByteArray));
                } else if (f == HttpPartFormat.BINARY_SPACED) {
                    out = StringUtils.toSpacedHex(this.toType(value, CM_ByteArray));
                } else if (f == HttpPartFormat.DATE) {
                    try {
                        if (value instanceof Calendar) {
                            out = TemporalCalendarSwap.IsoDate.DEFAULT.swap((BeanSession)this, (Calendar)((Object)value));
                        }
                        if (value instanceof Date) {
                            out = TemporalDateSwap.IsoDate.DEFAULT.swap((BeanSession)this, (Date)((Object)value));
                        }
                        if (value instanceof Temporal) {
                            out = TemporalSwap.IsoDate.DEFAULT.swap((BeanSession)this, (Temporal)((Object)value));
                        }
                        out = value.toString();
                    }
                    catch (Exception e) {
                        throw new SerializeException(e);
                    }
                } else if (f == HttpPartFormat.DATE_TIME) {
                    try {
                        if (value instanceof Calendar) {
                            out = TemporalCalendarSwap.IsoInstant.DEFAULT.swap((BeanSession)this, (Calendar)((Object)value));
                        }
                        if (value instanceof Date) {
                            out = TemporalDateSwap.IsoInstant.DEFAULT.swap((BeanSession)this, (Date)((Object)value));
                        }
                        if (value instanceof Temporal) {
                            out = TemporalSwap.IsoInstant.DEFAULT.swap((BeanSession)this, (Temporal)((Object)value));
                        }
                        out = value.toString();
                    }
                    catch (Exception e) {
                        throw new SerializeException(e);
                    }
                } else {
                    out = f == HttpPartFormat.UON ? super.serialize(partType, schema, value) : this.toType(value, this.string());
                }
            } else if (t == HttpPartDataType.BOOLEAN) {
                out = StringUtils.stringify(this.toType(value, CM_Boolean));
            } else if (t == HttpPartDataType.INTEGER) {
                out = f == HttpPartFormat.INT64 ? StringUtils.stringify(this.toType(value, CM_Long)) : StringUtils.stringify(this.toType(value, CM_Integer));
            } else if (t == HttpPartDataType.NUMBER) {
                out = f == HttpPartFormat.DOUBLE ? StringUtils.stringify(this.toType(value, CM_Double)) : StringUtils.stringify(this.toType(value, CM_Float));
            } else if (t == HttpPartDataType.ARRAY) {
                if (cf == HttpPartCollectionFormat.UONC) {
                    out = super.serialize(partType, null, this.toList(partType, (ClassMeta<?>)var4_13, value, schema));
                } else {
                    HttpPartSchema items = schema.getItems();
                    ClassMeta<Object> vt = this.getClassMetaForObject(value);
                    OapiStringBuilder sb = new OapiStringBuilder(cf);
                    if (var4_13.isArray()) {
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            sb.append(this.serialize(partType, items, Array.get(value, i)));
                        }
                    } else if (var4_13.isCollection()) {
                        for (Object o : (Collection)((Object)value)) {
                            sb.append(this.serialize(partType, items, o));
                        }
                    } else {
                        if (!vt.hasMutaterTo(String[].class)) throw new SerializeException("Input is not a valid array type: " + var4_13, new Object[0]);
                        String[] ss = this.toType(value, CM_StringArray);
                        for (int i = 0; i < ss.length; ++i) {
                            sb.append(this.serialize(partType, items, ss[i]));
                        }
                    }
                    out = sb.toString();
                }
            } else if (t == HttpPartDataType.OBJECT) {
                if (cf == HttpPartCollectionFormat.UONC) {
                    if (schema.hasProperties() && var4_13.isMapOrBean()) {
                        value = this.toMap(partType, (ClassMeta<?>)var4_13, value, schema);
                    }
                    out = super.serialize(partType, null, value);
                } else if (var4_13.isBean()) {
                    OapiStringBuilder sb = new OapiStringBuilder(cf);
                    for (BeanPropertyValue p : this.toBeanMap(value).getValues(this.isKeepNullProperties(), new BeanPropertyValue[0])) {
                        Throwable x;
                        if (!p.getMeta().canRead() || (x = p.getThrown()) != null) continue;
                        sb.append(p.getName(), this.serialize(partType, schema.getProperty(p.getName()), p.getValue()));
                    }
                    out = sb.toString();
                } else {
                    if (!var4_13.isMap()) throw new SerializeException("Input is not a valid object type: " + var4_13, new Object[0]);
                    OapiStringBuilder sb = new OapiStringBuilder(cf);
                    for (Map.Entry<String, Object> e : value.entrySet()) {
                        sb.append(e.getKey(), this.serialize(partType, schema.getProperty(StringUtils.stringify(e.getKey())), e.getValue()));
                    }
                    out = sb.toString();
                }
            } else {
                if (t == HttpPartDataType.FILE) {
                    throw new SerializeException("File part not supported.", new Object[0]);
                }
                if (t == HttpPartDataType.NO_TYPE) {
                    throw new SerializeException("Invalid type.", new Object[0]);
                }
            }
        }
        schema.validateInput(out);
        if (out == null) {
            out = schema.getDefault();
        }
        if (out != null) return out;
        return "null";
    }

    private Map<String, Object> toMap(HttpPartType partType, ClassMeta<?> type, Object o, HttpPartSchema s) throws SerializeException, SchemaValidationException {
        if (s == null) {
            s = DEFAULT_SCHEMA;
        }
        OMap m = new OMap();
        if (type.isBean()) {
            for (BeanPropertyValue p : this.toBeanMap(o).getValues(this.isKeepNullProperties(), new BeanPropertyValue[0])) {
                Throwable t;
                if (!p.getMeta().canRead() || (t = p.getThrown()) != null) continue;
                m.put(p.getName(), this.toObject(partType, p.getValue(), s.getProperty(p.getName())));
            }
        } else {
            for (Map.Entry e : ((Map)o).entrySet()) {
                m.put(StringUtils.stringify(e.getKey()), this.toObject(partType, e.getValue(), s.getProperty(StringUtils.stringify(e.getKey()))));
            }
        }
        if (this.isSortMaps()) {
            return this.sort(m);
        }
        return m;
    }

    private Collection toList(HttpPartType partType, ClassMeta<?> type, Object o, HttpPartSchema s) throws SerializeException, SchemaValidationException {
        if (s == null) {
            s = DEFAULT_SCHEMA;
        }
        OList l = new OList();
        HttpPartSchema items = s.getItems();
        if (type.isArray()) {
            for (int i = 0; i < Array.getLength(o); ++i) {
                l.add(this.toObject(partType, Array.get(o, i), items));
            }
        } else if (type.isCollection()) {
            for (Object o2 : (Collection)o) {
                l.add(this.toObject(partType, o2, items));
            }
        } else {
            l.add(this.toObject(partType, o, items));
        }
        if (this.isSortCollections()) {
            return this.sort(l);
        }
        return l;
    }

    private Object toObject(HttpPartType partType, Object o, HttpPartSchema s) throws SerializeException, SchemaValidationException {
        if (o == null) {
            return null;
        }
        if (s == null) {
            s = DEFAULT_SCHEMA;
        }
        ClassMeta<Object> cm = this.getClassMetaForObject(o);
        HttpPartDataType t = s.getType(cm);
        HttpPartFormat f = s.getFormat(cm);
        HttpPartCollectionFormat cf = s.getCollectionFormat();
        if (t == HttpPartDataType.STRING) {
            if (f == HttpPartFormat.BYTE) {
                return StringUtils.base64Encode(this.toType(o, CM_ByteArray));
            }
            if (f == HttpPartFormat.BINARY) {
                return StringUtils.toHex(this.toType(o, CM_ByteArray));
            }
            if (f == HttpPartFormat.BINARY_SPACED) {
                return StringUtils.toSpacedHex(this.toType(o, CM_ByteArray));
            }
            if (f == HttpPartFormat.DATE) {
                return StringUtils.toIsoDate(this.toType(o, CM_Calendar));
            }
            if (f == HttpPartFormat.DATE_TIME) {
                return StringUtils.toIsoDateTime(this.toType(o, CM_Calendar));
            }
            return o;
        }
        if (t == HttpPartDataType.ARRAY) {
            Collection l = this.toList(partType, this.getClassMetaForObject(o), o, s);
            if (cf == HttpPartCollectionFormat.CSV) {
                return StringUtils.joine(l, ',');
            }
            if (cf == HttpPartCollectionFormat.PIPES) {
                return StringUtils.joine(l, '|');
            }
            if (cf == HttpPartCollectionFormat.SSV) {
                return StringUtils.join(l, ' ');
            }
            if (cf == HttpPartCollectionFormat.TSV) {
                return StringUtils.join(l, '\t');
            }
            return l;
        }
        if (t == HttpPartDataType.OBJECT) {
            return this.toMap(partType, this.getClassMetaForObject(o), o, s);
        }
        return o;
    }

    private <T> T toType(Object in, ClassMeta<T> type) throws SerializeException {
        try {
            return this.convertToType(in, type);
        }
        catch (InvalidDataConversionException e) {
            throw new SerializeException(e);
        }
    }

    @Override
    public OMap toMap() {
        return super.toMap().a("OpenApiSerializerSession", new DefaultFilteringOMap());
    }

    private static class OapiStringBuilder {
        static final AsciiSet EQ = AsciiSet.create("=\\");
        static final AsciiSet PIPE = AsciiSet.create("|\\");
        static final AsciiSet PIPE_OR_EQ = AsciiSet.create("|=\\");
        static final AsciiSet COMMA = AsciiSet.create(",\\");
        static final AsciiSet COMMA_OR_EQ = AsciiSet.create(",=\\");
        private final StringBuilder sb = new StringBuilder();
        private final HttpPartCollectionFormat cf;
        private boolean first = true;

        OapiStringBuilder(HttpPartCollectionFormat cf) {
            this.cf = cf;
        }

        private void delim(HttpPartCollectionFormat cf) {
            if (cf == HttpPartCollectionFormat.PIPES) {
                this.sb.append('|');
            } else if (cf == HttpPartCollectionFormat.SSV) {
                this.sb.append(' ');
            } else if (cf == HttpPartCollectionFormat.TSV) {
                this.sb.append('\t');
            } else {
                this.sb.append(',');
            }
        }

        OapiStringBuilder append(Object o) {
            if (!this.first) {
                this.delim(this.cf);
            }
            this.first = false;
            if (this.cf == HttpPartCollectionFormat.PIPES) {
                this.sb.append(StringUtils.escapeChars(StringUtils.stringify(o), PIPE));
            } else if (this.cf == HttpPartCollectionFormat.SSV || this.cf == HttpPartCollectionFormat.TSV) {
                this.sb.append(StringUtils.stringify(o));
            } else {
                this.sb.append(StringUtils.escapeChars(StringUtils.stringify(o), COMMA));
            }
            return this;
        }

        OapiStringBuilder append(Object key, Object val) {
            if (!this.first) {
                this.delim(this.cf);
            }
            this.first = false;
            if (this.cf == HttpPartCollectionFormat.PIPES) {
                this.sb.append(StringUtils.escapeChars(StringUtils.stringify(key), PIPE_OR_EQ)).append('=').append(StringUtils.escapeChars(StringUtils.stringify(val), PIPE_OR_EQ));
            } else if (this.cf == HttpPartCollectionFormat.SSV || this.cf == HttpPartCollectionFormat.TSV) {
                this.sb.append(StringUtils.escapeChars(StringUtils.stringify(key), EQ)).append('=').append(StringUtils.escapeChars(StringUtils.stringify(val), EQ));
            } else {
                this.sb.append(StringUtils.escapeChars(StringUtils.stringify(key), COMMA_OR_EQ)).append('=').append(StringUtils.escapeChars(StringUtils.stringify(val), COMMA_OR_EQ));
            }
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

