/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRecursionException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.json.JsonSchemaSerializer;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.jsonschema.JsonSchemaBeanPropertyMeta;
import org.apache.juneau.jsonschema.JsonSchemaClassMeta;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.svl.VarResolverSession;

public class JsonSchemaSerializerSession
extends JsonSerializerSession {
    private final JsonSchemaGeneratorSession genSession;
    private final JsonSchemaSerializer ctx;

    public static Builder create(JsonSchemaSerializer ctx) {
        return new Builder(ctx);
    }

    protected JsonSchemaSerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.genSession = this.ctx.getGenerator().getSession();
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        try {
            super.doSerialize(out, this.genSession.getSchema(o));
        }
        catch (BeanRecursionException e) {
            throw new SerializeException(e);
        }
    }

    protected JsonSchemaClassMeta getJsonSchemaClassMeta(ClassMeta<?> cm) {
        return this.ctx.getJsonSchemaClassMeta(cm);
    }

    protected JsonSchemaBeanPropertyMeta getJsonSchemaBeanPropertyMeta(BeanPropertyMeta bpm) {
        return this.ctx.getJsonSchemaBeanPropertyMeta(bpm);
    }

    @FluentSetters
    public static class Builder
    extends JsonSerializerSession.Builder {
        JsonSchemaSerializer ctx;

        protected Builder(JsonSchemaSerializer ctx) {
            super(ctx);
            this.ctx = ctx;
        }

        @Override
        public JsonSchemaSerializerSession build() {
            return new JsonSchemaSerializerSession(this);
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder localeDefault(Locale value) {
            super.localeDefault(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder useWhitespace(Boolean value) {
            super.useWhitespace(value);
            return this;
        }
    }
}

