/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.apache.juneau.internal.CollectionUtils;

public class MockHttpSession
implements HttpSession {
    private Map<String, Object> attributes = CollectionUtils.map();
    private long creationTime;
    private long lastAccessedTime;
    private int maxInactiveInterval;
    private String id;
    private ServletContext servletContext;
    private boolean isNew = false;

    public static MockHttpSession create() {
        return new MockHttpSession();
    }

    public MockHttpSession creationTime(long value) {
        this.creationTime = value;
        return this;
    }

    public MockHttpSession lastAccessedTime(long value) {
        this.lastAccessedTime = value;
        return this;
    }

    public MockHttpSession maxInactiveInterval(int value) {
        this.maxInactiveInterval = value;
        return this;
    }

    public MockHttpSession id(String value) {
        this.id = value;
        return this;
    }

    public MockHttpSession servletContext(ServletContext value) {
        this.servletContext = value;
        return this;
    }

    public MockHttpSession isNew(boolean value) {
        this.isNew = value;
        return this;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int value) {
        this.maxInactiveInterval = value;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void invalidate() {
    }

    public boolean isNew() {
        return this.isNew;
    }
}

