/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.connect.mirror.MirrorUtils;
import org.apache.kafka.connect.mirror.TopicFilter;

public class DefaultTopicFilter
implements TopicFilter {
    public static final String TOPICS_INCLUDE_CONFIG = "topics";
    private static final String TOPICS_INCLUDE_DOC = "List of topics and/or regexes to replicate.";
    public static final String TOPICS_INCLUDE_DEFAULT = ".*";
    public static final String TOPICS_EXCLUDE_CONFIG = "topics.exclude";
    public static final String TOPICS_EXCLUDE_CONFIG_ALIAS = "topics.blacklist";
    private static final String TOPICS_EXCLUDE_DOC = "List of topics and/or regexes that should not be replicated.";
    public static final String TOPICS_EXCLUDE_DEFAULT = ".*[\\-\\.]internal, .*\\.replica, __.*";
    private Pattern includePattern;
    private Pattern excludePattern;

    @Override
    public void configure(Map<String, ?> props) {
        TopicFilterConfig config = new TopicFilterConfig(props);
        this.includePattern = config.includePattern();
        this.excludePattern = config.excludePattern();
    }

    private boolean included(String topic) {
        return this.includePattern != null && this.includePattern.matcher(topic).matches();
    }

    private boolean excluded(String topic) {
        return this.excludePattern != null && this.excludePattern.matcher(topic).matches();
    }

    @Override
    public boolean shouldReplicateTopic(String topic) {
        return this.included(topic) && !this.excluded(topic);
    }

    static class TopicFilterConfig
    extends AbstractConfig {
        static final ConfigDef DEF = new ConfigDef().define("topics", ConfigDef.Type.LIST, (Object)".*", ConfigDef.Importance.HIGH, "List of topics and/or regexes to replicate.").define("topics.exclude", ConfigDef.Type.LIST, (Object)".*[\\-\\.]internal, .*\\.replica, __.*", ConfigDef.Importance.HIGH, "List of topics and/or regexes that should not be replicated.").define("topics.blacklist", ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, "Deprecated. Use topics.exclude instead.");

        TopicFilterConfig(Map<String, ?> props) {
            super(DEF, ConfigUtils.translateDeprecatedConfigs(props, (String[][])new String[][]{{DefaultTopicFilter.TOPICS_EXCLUDE_CONFIG, DefaultTopicFilter.TOPICS_EXCLUDE_CONFIG_ALIAS}}), false);
        }

        Pattern includePattern() {
            return MirrorUtils.compilePatternList(this.getList(DefaultTopicFilter.TOPICS_INCLUDE_CONFIG));
        }

        Pattern excludePattern() {
            return MirrorUtils.compilePatternList(this.getList(DefaultTopicFilter.TOPICS_EXCLUDE_CONFIG));
        }
    }
}

