/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotRequestData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.VoteRequestData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.UnalignedMemoryRecords;
import org.apache.kafka.common.record.UnalignedRecords;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotRequest;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.CandidateState;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FollowerState;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.LeaderState;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.raft.QuorumState;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftMessage;
import org.apache.kafka.raft.RaftMessageQueue;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.RaftResponse;
import org.apache.kafka.raft.RaftUtil;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.RequestManager;
import org.apache.kafka.raft.ResignedState;
import org.apache.kafka.raft.UnattachedState;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.raft.VotedState;
import org.apache.kafka.raft.errors.NotLeaderException;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.kafka.raft.internals.BatchMemoryPool;
import org.apache.kafka.raft.internals.BlockingMessageQueue;
import org.apache.kafka.raft.internals.CloseListener;
import org.apache.kafka.raft.internals.FuturePurgatory;
import org.apache.kafka.raft.internals.KRaftControlRecordStateMachine;
import org.apache.kafka.raft.internals.KafkaRaftMetrics;
import org.apache.kafka.raft.internals.MemoryBatchReader;
import org.apache.kafka.raft.internals.RecordsBatchReader;
import org.apache.kafka.raft.internals.ReplicaKey;
import org.apache.kafka.raft.internals.ThresholdPurgatory;
import org.apache.kafka.raft.internals.VoterSet;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.NotifyingRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotReader;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.slf4j.Logger;

public final class KafkaRaftClient<T>
implements RaftClient<T> {
    private static final int RETRY_BACKOFF_BASE_MS = 100;
    public static final int MAX_FETCH_WAIT_MS = 500;
    public static final int MAX_BATCH_SIZE_BYTES = 0x800000;
    public static final int MAX_FETCH_SIZE_BYTES = 0x800000;
    private final OptionalInt nodeId;
    private final Uuid nodeDirectoryId;
    private final AtomicReference<GracefulShutdown> shutdown = new AtomicReference();
    private final LogContext logContext;
    private final Logger logger;
    private final Time time;
    private final int fetchMaxWaitMs;
    private final String clusterId;
    private final NetworkChannel channel;
    private final ReplicatedLog log;
    private final Random random;
    private final FuturePurgatory<Long> appendPurgatory;
    private final FuturePurgatory<Long> fetchPurgatory;
    private final RecordSerde<T> serde;
    private final MemoryPool memoryPool;
    private final RaftMessageQueue messageQueue;
    private final QuorumConfig quorumConfig;
    private final RaftMetadataLogCleanerManager snapshotCleaner;
    private final Map<RaftClient.Listener<T>, ListenerContext> listenerContexts = new IdentityHashMap<RaftClient.Listener<T>, ListenerContext>();
    private final ConcurrentLinkedQueue<Registration<T>> pendingRegistrations = new ConcurrentLinkedQueue();
    private volatile KRaftControlRecordStateMachine partitionState;
    private volatile KafkaRaftMetrics kafkaRaftMetrics;
    private volatile QuorumState quorum;
    private volatile RequestManager requestManager;

    public KafkaRaftClient(OptionalInt nodeId, Uuid nodeDirectoryId, RecordSerde<T> serde, NetworkChannel channel, ReplicatedLog log, Time time, ExpirationService expirationService, LogContext logContext, String clusterId, Collection<InetSocketAddress> bootstrapServers, QuorumConfig quorumConfig) {
        this(nodeId, nodeDirectoryId, serde, channel, new BlockingMessageQueue(), log, new BatchMemoryPool(5, 0x800000), time, expirationService, 500, clusterId, bootstrapServers, logContext, new Random(), quorumConfig);
    }

    KafkaRaftClient(OptionalInt nodeId, Uuid nodeDirectoryId, RecordSerde<T> serde, NetworkChannel channel, RaftMessageQueue messageQueue, ReplicatedLog log, MemoryPool memoryPool, Time time, ExpirationService expirationService, int fetchMaxWaitMs, String clusterId, Collection<InetSocketAddress> bootstrapServers, LogContext logContext, Random random, QuorumConfig quorumConfig) {
        this.nodeId = nodeId;
        this.nodeDirectoryId = nodeDirectoryId;
        this.logContext = logContext;
        this.serde = serde;
        this.channel = channel;
        this.messageQueue = messageQueue;
        this.log = log;
        this.memoryPool = memoryPool;
        this.fetchPurgatory = new ThresholdPurgatory<Long>(expirationService);
        this.appendPurgatory = new ThresholdPurgatory<Long>(expirationService);
        this.time = time;
        this.clusterId = clusterId;
        this.fetchMaxWaitMs = fetchMaxWaitMs;
        this.logger = logContext.logger(KafkaRaftClient.class);
        this.random = random;
        this.quorumConfig = quorumConfig;
        this.snapshotCleaner = new RaftMetadataLogCleanerManager(this.logger, time, 60000L, log::maybeClean);
        if (!bootstrapServers.isEmpty()) {
            AtomicInteger id = new AtomicInteger(-2);
            List<Node> bootstrapNodes = bootstrapServers.stream().map(address -> new Node(id.getAndDecrement(), address.getHostString(), address.getPort())).collect(Collectors.toList());
            this.logger.info("Starting request manager with bootstrap servers: {}", bootstrapNodes);
            this.requestManager = new RequestManager(bootstrapNodes, quorumConfig.retryBackoffMs(), quorumConfig.requestTimeoutMs(), random);
        }
    }

    private void updateFollowerHighWatermark(FollowerState state, OptionalLong highWatermarkOpt) {
        highWatermarkOpt.ifPresent(highWatermark -> {
            long newHighWatermark = Math.min(this.endOffset().offset(), highWatermark);
            if (state.updateHighWatermark(OptionalLong.of(newHighWatermark))) {
                this.logger.debug("Follower high watermark updated to {}", (Object)newHighWatermark);
                this.log.updateHighWatermark(new LogOffsetMetadata(newHighWatermark));
                this.updateListenersProgress(newHighWatermark);
            }
        });
    }

    private void updateLeaderEndOffsetAndTimestamp(LeaderState<T> state, long currentTimeMs) {
        LogOffsetMetadata endOffsetMetadata = this.log.endOffset();
        if (state.updateLocalState(endOffsetMetadata, this.partitionState.lastVoterSet().voterIds())) {
            this.onUpdateLeaderHighWatermark(state, currentTimeMs);
        }
        this.fetchPurgatory.maybeComplete(endOffsetMetadata.offset, currentTimeMs);
    }

    private void onUpdateLeaderHighWatermark(LeaderState<T> state, long currentTimeMs) {
        state.highWatermark().ifPresent(highWatermark -> {
            this.logger.debug("Leader high watermark updated to {}", highWatermark);
            this.log.updateHighWatermark((LogOffsetMetadata)highWatermark);
            this.appendPurgatory.maybeComplete(highWatermark.offset, currentTimeMs);
            this.updateListenersProgress(highWatermark.offset);
        });
    }

    private void updateListenersProgress(long highWatermark) {
        for (ListenerContext listenerContext : this.listenerContexts.values()) {
            listenerContext.nextExpectedOffset().ifPresent(nextExpectedOffset -> {
                if (nextExpectedOffset < highWatermark && (nextExpectedOffset == 0L && this.latestSnapshot().isPresent() || nextExpectedOffset < this.log.startOffset())) {
                    SnapshotReader<T> snapshot = this.latestSnapshot().orElseThrow(() -> new IllegalStateException(String.format("Snapshot expected since next offset of %s is %d, log start offset is %d and high-watermark is %d", listenerContext.listenerName(), nextExpectedOffset, this.log.startOffset(), highWatermark)));
                    listenerContext.fireHandleSnapshot(snapshot);
                }
            });
            listenerContext.nextExpectedOffset().ifPresent(nextExpectedOffset -> {
                if (nextExpectedOffset < highWatermark) {
                    LogFetchInfo readInfo = this.log.read(nextExpectedOffset, Isolation.COMMITTED);
                    listenerContext.fireHandleCommit(nextExpectedOffset, readInfo.records);
                }
            });
        }
    }

    private Optional<SnapshotReader<T>> latestSnapshot() {
        return this.log.latestSnapshot().map(reader -> RecordsSnapshotReader.of(reader, this.serde, BufferSupplier.create(), 0x800000, true));
    }

    private void maybeFireHandleCommit(long baseOffset, int epoch, long appendTimestamp, int sizeInBytes, List<T> records) {
        for (ListenerContext listenerContext : this.listenerContexts.values()) {
            listenerContext.nextExpectedOffset().ifPresent(nextOffset -> {
                if (nextOffset == baseOffset) {
                    listenerContext.fireHandleCommit(baseOffset, epoch, appendTimestamp, sizeInBytes, records);
                }
            });
        }
    }

    private void maybeFireLeaderChange(LeaderState<T> state) {
        for (ListenerContext listenerContext : this.listenerContexts.values()) {
            listenerContext.maybeFireLeaderChange(this.quorum.leaderAndEpoch(), state.epochStartOffset());
        }
    }

    private void maybeFireLeaderChange() {
        for (ListenerContext listenerContext : this.listenerContexts.values()) {
            listenerContext.maybeFireLeaderChange(this.quorum.leaderAndEpoch());
        }
    }

    public void initialize(Map<Integer, InetSocketAddress> voterAddresses, QuorumStateStore quorumStateStore, Metrics metrics) {
        this.partitionState = new KRaftControlRecordStateMachine(Optional.of(VoterSet.fromInetSocketAddresses(this.channel.listenerName(), voterAddresses)), this.log, this.serde, BufferSupplier.create(), 0x800000, this.logContext);
        this.logger.info("Reading KRaft snapshot and log as part of the initialization");
        this.partitionState.updateState();
        if (this.requestManager == null) {
            List<Node> bootstrapNodes = voterAddresses.entrySet().stream().map(entry -> new Node(((Integer)entry.getKey()).intValue(), ((InetSocketAddress)entry.getValue()).getHostString(), ((InetSocketAddress)entry.getValue()).getPort())).collect(Collectors.toList());
            this.logger.info("Starting request manager with static voters: {}", bootstrapNodes);
            this.requestManager = new RequestManager(bootstrapNodes, this.quorumConfig.retryBackoffMs(), this.quorumConfig.requestTimeoutMs(), this.random);
        }
        this.quorum = new QuorumState(this.nodeId, this.nodeDirectoryId, this.channel.listenerName(), this.partitionState::lastVoterSet, this.partitionState::lastKraftVersion, this.quorumConfig.electionTimeoutMs(), this.quorumConfig.fetchTimeoutMs(), quorumStateStore, this.time, this.logContext, this.random);
        this.kafkaRaftMetrics = new KafkaRaftMetrics(metrics, "raft", this.quorum);
        this.kafkaRaftMetrics.updateNumUnknownVoterConnections(0);
        this.quorum.initialize(new OffsetAndEpoch(this.log.endOffset().offset, this.log.lastFetchedEpoch()));
        long currentTimeMs = this.time.milliseconds();
        if (this.quorum.isLeader()) {
            throw new IllegalStateException("Voter cannot initialize as a Leader");
        }
        if (this.quorum.isCandidate()) {
            this.onBecomeCandidate(currentTimeMs);
        } else if (this.quorum.isFollower()) {
            this.onBecomeFollower(currentTimeMs);
        }
        if (this.quorum.isOnlyVoter() && !this.quorum.isCandidate()) {
            this.transitionToCandidate(currentTimeMs);
        }
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.pendingRegistrations.add(Registration.register(listener));
        this.wakeup();
    }

    @Override
    public void unregister(RaftClient.Listener<T> listener) {
        this.pendingRegistrations.add(Registration.unregister(listener));
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        if (this.isInitialized()) {
            return this.quorum.leaderAndEpoch();
        }
        return LeaderAndEpoch.UNKNOWN;
    }

    @Override
    public OptionalInt nodeId() {
        return this.nodeId;
    }

    private OffsetAndEpoch endOffset() {
        return new OffsetAndEpoch(this.log.endOffset().offset, this.log.lastFetchedEpoch());
    }

    private void resetConnections() {
        this.requestManager.resetAll();
    }

    private void onBecomeLeader(long currentTimeMs) {
        long endOffset = this.log.endOffset().offset;
        BatchAccumulator<T> accumulator = new BatchAccumulator<T>(this.quorum.epoch(), endOffset, this.quorumConfig.appendLingerMs(), 0x800000, this.memoryPool, this.time, (Compression)Compression.NONE, this.serde);
        LeaderState<T> state = this.quorum.transitionToLeader(endOffset, accumulator);
        this.log.initializeLeaderEpoch(this.quorum.epoch());
        state.appendLeaderChangeMessage(currentTimeMs);
        this.resetConnections();
        this.kafkaRaftMetrics.maybeUpdateElectionLatency(currentTimeMs);
    }

    private void flushLeaderLog(LeaderState<T> state, long currentTimeMs) {
        this.updateLeaderEndOffsetAndTimestamp(state, currentTimeMs);
        this.log.flush(false);
    }

    private boolean maybeTransitionToLeader(CandidateState state, long currentTimeMs) {
        if (state.isVoteGranted()) {
            this.onBecomeLeader(currentTimeMs);
            return true;
        }
        return false;
    }

    private void onBecomeCandidate(long currentTimeMs) {
        CandidateState state = this.quorum.candidateStateOrThrow();
        if (!this.maybeTransitionToLeader(state, currentTimeMs)) {
            this.resetConnections();
            this.kafkaRaftMetrics.updateElectionStartMs(currentTimeMs);
        }
    }

    private void transitionToCandidate(long currentTimeMs) {
        this.quorum.transitionToCandidate();
        this.maybeFireLeaderChange();
        this.onBecomeCandidate(currentTimeMs);
    }

    private void transitionToUnattached(int epoch) {
        this.quorum.transitionToUnattached(epoch);
        this.maybeFireLeaderChange();
        this.resetConnections();
    }

    private void transitionToResigned(List<Integer> preferredSuccessors) {
        this.fetchPurgatory.completeAllExceptionally((Throwable)Errors.NOT_LEADER_OR_FOLLOWER.exception("Not handling request since this node is resigning"));
        this.quorum.transitionToResigned(preferredSuccessors);
        this.maybeFireLeaderChange();
        this.resetConnections();
    }

    private void transitionToVoted(ReplicaKey candidateKey, int epoch) {
        this.quorum.transitionToVoted(epoch, candidateKey);
        this.maybeFireLeaderChange();
        this.resetConnections();
    }

    private void onBecomeFollower(long currentTimeMs) {
        this.kafkaRaftMetrics.maybeUpdateElectionLatency(currentTimeMs);
        this.resetConnections();
        this.fetchPurgatory.completeAllExceptionally((Throwable)new NotLeaderOrFollowerException("Cannot process the fetch request because the node is no longer the leader."));
        this.appendPurgatory.completeAllExceptionally((Throwable)new NotLeaderOrFollowerException("Failed to receive sufficient acknowledgments for this append before leader change."));
    }

    private void transitionToFollower(int epoch, Node leader, long currentTimeMs) {
        this.quorum.transitionToFollower(epoch, leader);
        this.maybeFireLeaderChange();
        this.onBecomeFollower(currentTimeMs);
    }

    private VoteResponseData buildVoteResponse(Errors partitionLevelError, boolean voteGranted) {
        return VoteResponse.singletonResponse((Errors)Errors.NONE, (TopicPartition)this.log.topicPartition(), (Errors)partitionLevelError, (int)this.quorum.epoch(), (int)this.quorum.leaderIdOrSentinel(), (boolean)voteGranted);
    }

    private VoteResponseData handleVoteRequest(RaftRequest.Inbound requestMetadata) {
        VoteRequestData request = (VoteRequestData)requestMetadata.data();
        if (!this.hasValidClusterId(request.clusterId())) {
            return new VoteResponseData().setErrorCode(Errors.INCONSISTENT_CLUSTER_ID.code());
        }
        if (!RaftUtil.hasValidTopicPartition(request, this.log.topicPartition())) {
            return new VoteResponseData().setErrorCode(Errors.INVALID_REQUEST.code());
        }
        VoteRequestData.PartitionData partitionRequest = (VoteRequestData.PartitionData)((VoteRequestData.TopicData)request.topics().get(0)).partitions().get(0);
        int candidateId = partitionRequest.candidateId();
        int candidateEpoch = partitionRequest.candidateEpoch();
        int lastEpoch = partitionRequest.lastOffsetEpoch();
        long lastEpochEndOffset = partitionRequest.lastOffset();
        if (lastEpochEndOffset < 0L || lastEpoch < 0 || lastEpoch >= candidateEpoch) {
            return this.buildVoteResponse(Errors.INVALID_REQUEST, false);
        }
        Optional<Errors> errorOpt = this.validateVoterOnlyRequest(candidateId, candidateEpoch);
        if (errorOpt.isPresent()) {
            return this.buildVoteResponse(errorOpt.get(), false);
        }
        if (candidateEpoch > this.quorum.epoch()) {
            this.transitionToUnattached(candidateEpoch);
        }
        OffsetAndEpoch lastEpochEndOffsetAndEpoch = new OffsetAndEpoch(lastEpochEndOffset, lastEpoch);
        ReplicaKey candidateKey = ReplicaKey.of(candidateId, Optional.empty());
        boolean voteGranted = this.quorum.canGrantVote(candidateKey, lastEpochEndOffsetAndEpoch.compareTo(this.endOffset()) >= 0);
        if (voteGranted && this.quorum.isUnattached()) {
            this.transitionToVoted(candidateKey, candidateEpoch);
        }
        this.logger.info("Vote request {} with epoch {} is {}", new Object[]{request, candidateEpoch, voteGranted ? "granted" : "rejected"});
        return this.buildVoteResponse(Errors.NONE, voteGranted);
    }

    private boolean handleVoteResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) {
        int responseEpoch;
        OptionalInt responseLeaderId;
        int remoteNodeId = responseMetadata.source().id();
        VoteResponseData response = (VoteResponseData)responseMetadata.data();
        Errors topLevelError = Errors.forCode((short)response.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (!RaftUtil.hasValidTopicPartition(response, this.log.topicPartition())) {
            return false;
        }
        VoteResponseData.PartitionData partitionResponse = (VoteResponseData.PartitionData)((VoteResponseData.TopicData)response.topics().get(0)).partitions().get(0);
        Errors error = Errors.forCode((short)partitionResponse.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(error, responseLeaderId = KafkaRaftClient.optionalLeaderId(partitionResponse.leaderId()), responseEpoch = partitionResponse.leaderEpoch(), currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        if (error == Errors.NONE) {
            if (this.quorum.isLeader()) {
                this.logger.debug("Ignoring vote response {} since we already became leader for epoch {}", (Object)partitionResponse, (Object)this.quorum.epoch());
            } else if (this.quorum.isCandidate()) {
                CandidateState state = this.quorum.candidateStateOrThrow();
                if (partitionResponse.voteGranted()) {
                    state.recordGrantedVote(remoteNodeId);
                    this.maybeTransitionToLeader(state, currentTimeMs);
                } else {
                    state.recordRejectedVote(remoteNodeId);
                    if (state.isVoteRejected() && !state.isBackingOff()) {
                        this.logger.info("Insufficient remaining votes to become leader (rejected by {}). We will backoff before retrying election again", state.rejectingVoters());
                        state.startBackingOff(currentTimeMs, this.binaryExponentialElectionBackoffMs(state.retries()));
                    }
                }
            } else {
                this.logger.debug("Ignoring vote response {} since we are no longer a candidate in epoch {}", (Object)partitionResponse, (Object)this.quorum.epoch());
            }
            return true;
        }
        return this.handleUnexpectedError(error, responseMetadata);
    }

    private int binaryExponentialElectionBackoffMs(int retries) {
        if (retries <= 0) {
            throw new IllegalArgumentException("Retries " + retries + " should be larger than zero");
        }
        return Math.min(100 * this.random.nextInt(2 << Math.min(20, retries - 1)), this.quorumConfig.electionBackoffMaxMs());
    }

    private int strictExponentialElectionBackoffMs(int positionInSuccessors, int totalNumSuccessors) {
        if (positionInSuccessors <= 0 || positionInSuccessors >= totalNumSuccessors) {
            throw new IllegalArgumentException("Position " + positionInSuccessors + " should be larger than zero and smaller than total number of successors " + totalNumSuccessors);
        }
        int retryBackOffBaseMs = this.quorumConfig.electionBackoffMaxMs() >> totalNumSuccessors - 1;
        return Math.min(this.quorumConfig.electionBackoffMaxMs(), retryBackOffBaseMs << positionInSuccessors - 1);
    }

    private BeginQuorumEpochResponseData buildBeginQuorumEpochResponse(Errors partitionLevelError) {
        return BeginQuorumEpochResponse.singletonResponse((Errors)Errors.NONE, (TopicPartition)this.log.topicPartition(), (Errors)partitionLevelError, (int)this.quorum.epoch(), (int)this.quorum.leaderIdOrSentinel());
    }

    private BeginQuorumEpochResponseData handleBeginQuorumEpochRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) {
        int requestEpoch;
        BeginQuorumEpochRequestData request = (BeginQuorumEpochRequestData)requestMetadata.data();
        if (!this.hasValidClusterId(request.clusterId())) {
            return new BeginQuorumEpochResponseData().setErrorCode(Errors.INCONSISTENT_CLUSTER_ID.code());
        }
        if (!RaftUtil.hasValidTopicPartition(request, this.log.topicPartition())) {
            return new BeginQuorumEpochResponseData().setErrorCode(Errors.INVALID_REQUEST.code());
        }
        BeginQuorumEpochRequestData.PartitionData partitionRequest = (BeginQuorumEpochRequestData.PartitionData)((BeginQuorumEpochRequestData.TopicData)request.topics().get(0)).partitions().get(0);
        int requestLeaderId = partitionRequest.leaderId();
        Optional<Errors> errorOpt = this.validateVoterOnlyRequest(requestLeaderId, requestEpoch = partitionRequest.leaderEpoch());
        if (errorOpt.isPresent()) {
            return this.buildBeginQuorumEpochResponse(errorOpt.get());
        }
        this.maybeTransition(this.partitionState.lastVoterSet().voterNode(requestLeaderId, this.channel.listenerName()), requestEpoch, currentTimeMs);
        return this.buildBeginQuorumEpochResponse(Errors.NONE);
    }

    private boolean handleBeginQuorumEpochResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) {
        int responseEpoch;
        OptionalInt responseLeaderId;
        int remoteNodeId = responseMetadata.source().id();
        BeginQuorumEpochResponseData response = (BeginQuorumEpochResponseData)responseMetadata.data();
        Errors topLevelError = Errors.forCode((short)response.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (!RaftUtil.hasValidTopicPartition(response, this.log.topicPartition())) {
            return false;
        }
        BeginQuorumEpochResponseData.PartitionData partitionResponse = (BeginQuorumEpochResponseData.PartitionData)((BeginQuorumEpochResponseData.TopicData)response.topics().get(0)).partitions().get(0);
        Errors partitionError = Errors.forCode((short)partitionResponse.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(partitionError, responseLeaderId = KafkaRaftClient.optionalLeaderId(partitionResponse.leaderId()), responseEpoch = partitionResponse.leaderEpoch(), currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        if (partitionError == Errors.NONE) {
            if (this.quorum.isLeader()) {
                LeaderState state = this.quorum.leaderStateOrThrow();
                state.addAcknowledgementFrom(remoteNodeId);
            } else {
                this.logger.debug("Ignoring BeginQuorumEpoch response {} since this node is not the leader anymore", (Object)response);
            }
            return true;
        }
        return this.handleUnexpectedError(partitionError, responseMetadata);
    }

    private EndQuorumEpochResponseData buildEndQuorumEpochResponse(Errors partitionLevelError) {
        return EndQuorumEpochResponse.singletonResponse((Errors)Errors.NONE, (TopicPartition)this.log.topicPartition(), (Errors)partitionLevelError, (int)this.quorum.epoch(), (int)this.quorum.leaderIdOrSentinel());
    }

    private EndQuorumEpochResponseData handleEndQuorumEpochRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) {
        FollowerState state;
        EndQuorumEpochRequestData request = (EndQuorumEpochRequestData)requestMetadata.data();
        if (!this.hasValidClusterId(request.clusterId())) {
            return new EndQuorumEpochResponseData().setErrorCode(Errors.INCONSISTENT_CLUSTER_ID.code());
        }
        if (!RaftUtil.hasValidTopicPartition(request, this.log.topicPartition())) {
            return new EndQuorumEpochResponseData().setErrorCode(Errors.INVALID_REQUEST.code());
        }
        EndQuorumEpochRequestData.PartitionData partitionRequest = (EndQuorumEpochRequestData.PartitionData)((EndQuorumEpochRequestData.TopicData)request.topics().get(0)).partitions().get(0);
        int requestEpoch = partitionRequest.leaderEpoch();
        int requestLeaderId = partitionRequest.leaderId();
        Optional<Errors> errorOpt = this.validateVoterOnlyRequest(requestLeaderId, requestEpoch);
        if (errorOpt.isPresent()) {
            return this.buildEndQuorumEpochResponse(errorOpt.get());
        }
        this.maybeTransition(this.partitionState.lastVoterSet().voterNode(requestLeaderId, this.channel.listenerName()), requestEpoch, currentTimeMs);
        if (this.quorum.isFollower() && (state = this.quorum.followerStateOrThrow()).leader().id() == requestLeaderId) {
            List preferredSuccessors = partitionRequest.preferredSuccessors();
            long electionBackoffMs = this.endEpochElectionBackoff(preferredSuccessors);
            this.logger.debug("Overriding follower fetch timeout to {} after receiving EndQuorumEpoch request from leader {} in epoch {}", new Object[]{electionBackoffMs, requestLeaderId, requestEpoch});
            state.overrideFetchTimeout(currentTimeMs, electionBackoffMs);
        }
        return this.buildEndQuorumEpochResponse(Errors.NONE);
    }

    private long endEpochElectionBackoff(List<Integer> preferredSuccessors) {
        int position = preferredSuccessors.indexOf(this.quorum.localIdOrThrow());
        if (position <= 0) {
            return 0L;
        }
        return this.strictExponentialElectionBackoffMs(position, preferredSuccessors.size());
    }

    private boolean handleEndQuorumEpochResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) {
        int responseEpoch;
        OptionalInt responseLeaderId;
        EndQuorumEpochResponseData response = (EndQuorumEpochResponseData)responseMetadata.data();
        Errors topLevelError = Errors.forCode((short)response.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (!RaftUtil.hasValidTopicPartition(response, this.log.topicPartition())) {
            return false;
        }
        EndQuorumEpochResponseData.PartitionData partitionResponse = (EndQuorumEpochResponseData.PartitionData)((EndQuorumEpochResponseData.TopicData)response.topics().get(0)).partitions().get(0);
        Errors partitionError = Errors.forCode((short)partitionResponse.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(partitionError, responseLeaderId = KafkaRaftClient.optionalLeaderId(partitionResponse.leaderId()), responseEpoch = partitionResponse.leaderEpoch(), currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        if (partitionError == Errors.NONE) {
            ResignedState resignedState = this.quorum.resignedStateOrThrow();
            resignedState.acknowledgeResignation(responseMetadata.source().id());
            return true;
        }
        return this.handleUnexpectedError(partitionError, responseMetadata);
    }

    private FetchResponseData buildFetchResponse(Errors error, Records records, ValidOffsetAndEpoch validOffsetAndEpoch, Optional<LogOffsetMetadata> highWatermark) {
        return RaftUtil.singletonFetchResponse(this.log.topicPartition(), this.log.topicId(), Errors.NONE, partitionData -> {
            partitionData.setRecords((BaseRecords)records).setErrorCode(error.code()).setLogStartOffset(this.log.startOffset()).setHighWatermark(highWatermark.map(offsetMetadata -> offsetMetadata.offset).orElse(-1L).longValue());
            partitionData.currentLeader().setLeaderEpoch(this.quorum.epoch()).setLeaderId(this.quorum.leaderIdOrSentinel());
            switch (validOffsetAndEpoch.kind()) {
                case DIVERGING: {
                    partitionData.divergingEpoch().setEpoch(validOffsetAndEpoch.offsetAndEpoch().epoch()).setEndOffset(validOffsetAndEpoch.offsetAndEpoch().offset());
                    break;
                }
                case SNAPSHOT: {
                    partitionData.snapshotId().setEpoch(validOffsetAndEpoch.offsetAndEpoch().epoch()).setEndOffset(validOffsetAndEpoch.offsetAndEpoch().offset());
                    break;
                }
            }
        });
    }

    private FetchResponseData buildEmptyFetchResponse(Errors error, Optional<LogOffsetMetadata> highWatermark) {
        return this.buildFetchResponse(error, (Records)MemoryRecords.EMPTY, ValidOffsetAndEpoch.valid(), highWatermark);
    }

    private boolean hasValidClusterId(String requestClusterId) {
        if (requestClusterId == null) {
            return true;
        }
        return this.clusterId.equals(requestClusterId);
    }

    private CompletableFuture<FetchResponseData> handleFetchRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) {
        FetchRequestData request = (FetchRequestData)requestMetadata.data();
        if (!this.hasValidClusterId(request.clusterId())) {
            return CompletableFuture.completedFuture(new FetchResponseData().setErrorCode(Errors.INCONSISTENT_CLUSTER_ID.code()));
        }
        if (!RaftUtil.hasValidTopicPartition(request, this.log.topicPartition(), this.log.topicId())) {
            return CompletableFuture.completedFuture(new FetchResponseData().setErrorCode(Errors.INVALID_REQUEST.code()));
        }
        ((FetchRequestData.FetchTopic)request.topics().get(0)).setTopic(this.log.topicPartition().topic());
        FetchRequestData.FetchPartition fetchPartition = (FetchRequestData.FetchPartition)((FetchRequestData.FetchTopic)request.topics().get(0)).partitions().get(0);
        if (request.maxWaitMs() < 0 || fetchPartition.fetchOffset() < 0L || fetchPartition.lastFetchedEpoch() < 0 || fetchPartition.lastFetchedEpoch() > fetchPartition.currentLeaderEpoch()) {
            return CompletableFuture.completedFuture(this.buildEmptyFetchResponse(Errors.INVALID_REQUEST, Optional.empty()));
        }
        int replicaId = FetchRequest.replicaId((FetchRequestData)request);
        FetchResponseData response = this.tryCompleteFetchRequest(replicaId, fetchPartition, currentTimeMs);
        FetchResponseData.PartitionData partitionResponse = (FetchResponseData.PartitionData)((FetchResponseData.FetchableTopicResponse)response.responses().get(0)).partitions().get(0);
        if (partitionResponse.errorCode() != Errors.NONE.code() || FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionResponse) > 0 || request.maxWaitMs() == 0 || KafkaRaftClient.isPartitionDiverged(partitionResponse) || KafkaRaftClient.isPartitionSnapshotted(partitionResponse)) {
            return CompletableFuture.completedFuture(response);
        }
        CompletableFuture<Long> future = this.fetchPurgatory.await(fetchPartition.fetchOffset(), request.maxWaitMs());
        return future.handle((T completionTimeMs, U exception) -> {
            if (exception != null) {
                Throwable cause = exception instanceof ExecutionException ? exception.getCause() : exception;
                Errors error = Errors.forException((Throwable)cause);
                if (error == Errors.REQUEST_TIMED_OUT) {
                    return response;
                }
                this.logger.info("Failed to handle fetch from {} at {} due to {}", new Object[]{replicaId, fetchPartition.fetchOffset(), error});
                return this.buildEmptyFetchResponse(error, Optional.empty());
            }
            this.logger.trace("Completing delayed fetch from {} starting at offset {} at {}", new Object[]{replicaId, fetchPartition.fetchOffset(), completionTimeMs});
            return this.tryCompleteFetchRequest(replicaId, fetchPartition, this.time.milliseconds());
        });
    }

    private FetchResponseData tryCompleteFetchRequest(int replicaId, FetchRequestData.FetchPartition request, long currentTimeMs) {
        try {
            MemoryRecords records;
            Optional<Errors> errorOpt = this.validateLeaderOnlyRequest(request.currentLeaderEpoch());
            if (errorOpt.isPresent()) {
                return this.buildEmptyFetchResponse(errorOpt.get(), Optional.empty());
            }
            long fetchOffset = request.fetchOffset();
            int lastFetchedEpoch = request.lastFetchedEpoch();
            LeaderState state = this.quorum.leaderStateOrThrow();
            Optional<OffsetAndEpoch> latestSnapshotId = this.log.latestSnapshotId();
            ValidOffsetAndEpoch validOffsetAndEpoch = fetchOffset == 0L && latestSnapshotId.isPresent() ? ValidOffsetAndEpoch.snapshot(latestSnapshotId.get()) : this.log.validateOffsetAndEpoch(fetchOffset, lastFetchedEpoch);
            if (validOffsetAndEpoch.kind() == ValidOffsetAndEpoch.Kind.VALID) {
                LogFetchInfo info = this.log.read(fetchOffset, Isolation.UNCOMMITTED);
                if (state.updateReplicaState(replicaId, currentTimeMs, info.startOffsetMetadata)) {
                    this.onUpdateLeaderHighWatermark(state, currentTimeMs);
                }
                records = info.records;
            } else {
                records = MemoryRecords.EMPTY;
            }
            return this.buildFetchResponse(Errors.NONE, (Records)records, validOffsetAndEpoch, state.highWatermark());
        }
        catch (Exception e) {
            this.logger.error("Caught unexpected error in fetch completion of request {}", (Object)request, (Object)e);
            return this.buildEmptyFetchResponse(Errors.UNKNOWN_SERVER_ERROR, Optional.empty());
        }
    }

    private static boolean isPartitionDiverged(FetchResponseData.PartitionData partitionResponseData) {
        FetchResponseData.EpochEndOffset divergingEpoch = partitionResponseData.divergingEpoch();
        return divergingEpoch.epoch() != -1 || divergingEpoch.endOffset() != -1L;
    }

    private static boolean isPartitionSnapshotted(FetchResponseData.PartitionData partitionResponseData) {
        FetchResponseData.SnapshotId snapshotId = partitionResponseData.snapshotId();
        return snapshotId.epoch() != -1 || snapshotId.endOffset() != -1L;
    }

    private static OptionalInt optionalLeaderId(int leaderIdOrNil) {
        if (leaderIdOrNil < 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(leaderIdOrNil);
    }

    private static String listenerName(RaftClient.Listener<?> listener) {
        return String.format("%s@%d", listener.getClass().getTypeName(), System.identityHashCode(listener));
    }

    private boolean handleFetchResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) {
        FetchResponseData response = (FetchResponseData)responseMetadata.data();
        Errors topLevelError = Errors.forCode((short)response.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (!RaftUtil.hasValidTopicPartition(response, this.log.topicPartition(), this.log.topicId())) {
            return false;
        }
        ((FetchResponseData.FetchableTopicResponse)response.responses().get(0)).setTopic(this.log.topicPartition().topic());
        FetchResponseData.PartitionData partitionResponse = (FetchResponseData.PartitionData)((FetchResponseData.FetchableTopicResponse)response.responses().get(0)).partitions().get(0);
        FetchResponseData.LeaderIdAndEpoch currentLeaderIdAndEpoch = partitionResponse.currentLeader();
        OptionalInt responseLeaderId = KafkaRaftClient.optionalLeaderId(currentLeaderIdAndEpoch.leaderId());
        int responseEpoch = currentLeaderIdAndEpoch.leaderEpoch();
        Errors error = Errors.forCode((short)partitionResponse.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(error, responseLeaderId, responseEpoch, currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        FollowerState state = this.quorum.followerStateOrThrow();
        if (error == Errors.NONE) {
            FetchResponseData.EpochEndOffset divergingEpoch = partitionResponse.divergingEpoch();
            if (divergingEpoch.epoch() >= 0) {
                OffsetAndEpoch divergingOffsetAndEpoch = new OffsetAndEpoch(divergingEpoch.endOffset(), divergingEpoch.epoch());
                state.highWatermark().ifPresent(highWatermark -> {
                    if (divergingOffsetAndEpoch.offset() < highWatermark.offset) {
                        throw new KafkaException("The leader requested truncation to offset " + divergingOffsetAndEpoch.offset() + ", which is below the current high watermark " + highWatermark);
                    }
                });
                long truncationOffset = this.log.truncateToEndOffset(divergingOffsetAndEpoch);
                this.logger.info("Truncated to offset {} from Fetch response from leader {}", (Object)truncationOffset, (Object)this.quorum.leaderIdOrSentinel());
                this.partitionState.truncateNewEntries(truncationOffset);
            } else if (partitionResponse.snapshotId().epoch() >= 0 || partitionResponse.snapshotId().endOffset() >= 0L) {
                if (partitionResponse.snapshotId().epoch() < 0) {
                    this.logger.error("The leader sent a snapshot id with a valid end offset {} but with an invalid epoch {}", (Object)partitionResponse.snapshotId().endOffset(), (Object)partitionResponse.snapshotId().epoch());
                    return false;
                }
                if (partitionResponse.snapshotId().endOffset() < 0L) {
                    this.logger.error("The leader sent a snapshot id with a valid epoch {} but with an invalid end offset {}", (Object)partitionResponse.snapshotId().epoch(), (Object)partitionResponse.snapshotId().endOffset());
                    return false;
                }
                OffsetAndEpoch snapshotId = new OffsetAndEpoch(partitionResponse.snapshotId().endOffset(), partitionResponse.snapshotId().epoch());
                state.setFetchingSnapshot(this.log.createNewSnapshotUnchecked(snapshotId));
                this.logger.info("Fetching snapshot {} from Fetch response from leader {}", (Object)snapshotId, (Object)this.quorum.leaderIdOrSentinel());
            } else {
                Records records = FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionResponse);
                if (records.sizeInBytes() > 0) {
                    this.appendAsFollower(records);
                }
                OptionalLong highWatermark2 = partitionResponse.highWatermark() < 0L ? OptionalLong.empty() : OptionalLong.of(partitionResponse.highWatermark());
                this.updateFollowerHighWatermark(state, highWatermark2);
            }
            state.resetFetchTimeout(currentTimeMs);
            return true;
        }
        return this.handleUnexpectedError(error, responseMetadata);
    }

    private void appendAsFollower(Records records) {
        LogAppendInfo info = this.log.appendAsFollower(records);
        if (this.quorum.isVoter()) {
            this.log.flush(false);
        }
        this.partitionState.updateState();
        OffsetAndEpoch endOffset = this.endOffset();
        this.kafkaRaftMetrics.updateFetchedRecords(info.lastOffset - info.firstOffset + 1L);
        this.kafkaRaftMetrics.updateLogEnd(endOffset);
        this.logger.trace("Follower end offset updated to {} after append", (Object)endOffset);
    }

    private LogAppendInfo appendAsLeader(Records records) {
        LogAppendInfo info = this.log.appendAsLeader(records, this.quorum.epoch());
        this.partitionState.updateState();
        OffsetAndEpoch endOffset = this.endOffset();
        this.kafkaRaftMetrics.updateAppendRecords(info.lastOffset - info.firstOffset + 1L);
        this.kafkaRaftMetrics.updateLogEnd(endOffset);
        this.logger.trace("Leader appended records at base offset {}, new end offset is {}", (Object)info.firstOffset, (Object)endOffset);
        return info;
    }

    private DescribeQuorumResponseData handleDescribeQuorumRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) {
        DescribeQuorumRequestData describeQuorumRequestData = (DescribeQuorumRequestData)requestMetadata.data();
        if (!RaftUtil.hasValidTopicPartition(describeQuorumRequestData, this.log.topicPartition())) {
            return DescribeQuorumRequest.getPartitionLevelErrorResponse((DescribeQuorumRequestData)describeQuorumRequestData, (Errors)Errors.UNKNOWN_TOPIC_OR_PARTITION);
        }
        if (!this.quorum.isLeader()) {
            return DescribeQuorumResponse.singletonErrorResponse((TopicPartition)this.log.topicPartition(), (Errors)Errors.NOT_LEADER_OR_FOLLOWER);
        }
        LeaderState leaderState = this.quorum.leaderStateOrThrow();
        return DescribeQuorumResponse.singletonResponse((TopicPartition)this.log.topicPartition(), (DescribeQuorumResponseData.PartitionData)leaderState.describeQuorum(currentTimeMs));
    }

    private FetchSnapshotResponseData handleFetchSnapshotRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) {
        int maxSnapshotSize;
        FetchSnapshotRequestData data = (FetchSnapshotRequestData)requestMetadata.data();
        if (!this.hasValidClusterId(data.clusterId())) {
            return new FetchSnapshotResponseData().setErrorCode(Errors.INCONSISTENT_CLUSTER_ID.code());
        }
        if (data.topics().size() != 1 && ((FetchSnapshotRequestData.TopicSnapshot)data.topics().get(0)).partitions().size() != 1) {
            return FetchSnapshotResponse.withTopLevelError((Errors)Errors.INVALID_REQUEST);
        }
        Optional partitionSnapshotOpt = FetchSnapshotRequest.forTopicPartition((FetchSnapshotRequestData)data, (TopicPartition)this.log.topicPartition());
        if (!partitionSnapshotOpt.isPresent()) {
            TopicPartition unknownTopicPartition = new TopicPartition(((FetchSnapshotRequestData.TopicSnapshot)data.topics().get(0)).name(), ((FetchSnapshotRequestData.PartitionSnapshot)((FetchSnapshotRequestData.TopicSnapshot)data.topics().get(0)).partitions().get(0)).partition());
            return FetchSnapshotResponse.singleton((TopicPartition)unknownTopicPartition, responsePartitionSnapshot -> responsePartitionSnapshot.setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
        }
        FetchSnapshotRequestData.PartitionSnapshot partitionSnapshot = (FetchSnapshotRequestData.PartitionSnapshot)partitionSnapshotOpt.get();
        Optional<Errors> leaderValidation = this.validateLeaderOnlyRequest(partitionSnapshot.currentLeaderEpoch());
        if (leaderValidation.isPresent()) {
            return FetchSnapshotResponse.singleton((TopicPartition)this.log.topicPartition(), responsePartitionSnapshot -> this.addQuorumLeader((FetchSnapshotResponseData.PartitionSnapshot)responsePartitionSnapshot).setErrorCode(((Errors)leaderValidation.get()).code()));
        }
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(partitionSnapshot.snapshotId().endOffset(), partitionSnapshot.snapshotId().epoch());
        Optional<RawSnapshotReader> snapshotOpt = this.log.readSnapshot(snapshotId);
        if (!snapshotOpt.isPresent()) {
            return FetchSnapshotResponse.singleton((TopicPartition)this.log.topicPartition(), responsePartitionSnapshot -> this.addQuorumLeader((FetchSnapshotResponseData.PartitionSnapshot)responsePartitionSnapshot).setErrorCode(Errors.SNAPSHOT_NOT_FOUND.code()));
        }
        RawSnapshotReader snapshot = snapshotOpt.get();
        long snapshotSize = snapshot.sizeInBytes();
        if (partitionSnapshot.position() < 0L || partitionSnapshot.position() >= snapshotSize) {
            return FetchSnapshotResponse.singleton((TopicPartition)this.log.topicPartition(), responsePartitionSnapshot -> this.addQuorumLeader((FetchSnapshotResponseData.PartitionSnapshot)responsePartitionSnapshot).setErrorCode(Errors.POSITION_OUT_OF_RANGE.code()));
        }
        if (partitionSnapshot.position() > Integer.MAX_VALUE) {
            throw new IllegalStateException(String.format("Trying to fetch a snapshot with size (%d) and a position (%d) larger than %d", snapshotSize, partitionSnapshot.position(), Integer.MAX_VALUE));
        }
        try {
            maxSnapshotSize = Math.toIntExact(snapshotSize);
        }
        catch (ArithmeticException e) {
            maxSnapshotSize = Integer.MAX_VALUE;
        }
        UnalignedRecords records = snapshot.slice(partitionSnapshot.position(), Math.min(data.maxBytes(), maxSnapshotSize));
        LeaderState state = this.quorum.leaderStateOrThrow();
        state.updateCheckQuorumForFollowingVoter(data.replicaId(), currentTimeMs);
        return FetchSnapshotResponse.singleton((TopicPartition)this.log.topicPartition(), responsePartitionSnapshot -> {
            this.addQuorumLeader((FetchSnapshotResponseData.PartitionSnapshot)responsePartitionSnapshot).snapshotId().setEndOffset(snapshotId.offset()).setEpoch(snapshotId.epoch());
            return responsePartitionSnapshot.setSize(snapshotSize).setPosition(partitionSnapshot.position()).setUnalignedRecords((BaseRecords)records);
        });
    }

    private boolean handleFetchSnapshotResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) {
        UnalignedMemoryRecords records;
        FetchSnapshotResponseData data = (FetchSnapshotResponseData)responseMetadata.data();
        Errors topLevelError = Errors.forCode((short)data.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (data.topics().size() != 1 && ((FetchSnapshotResponseData.TopicSnapshot)data.topics().get(0)).partitions().size() != 1) {
            return false;
        }
        Optional partitionSnapshotOpt = FetchSnapshotResponse.forTopicPartition((FetchSnapshotResponseData)data, (TopicPartition)this.log.topicPartition());
        if (!partitionSnapshotOpt.isPresent()) {
            return false;
        }
        FetchSnapshotResponseData.PartitionSnapshot partitionSnapshot = (FetchSnapshotResponseData.PartitionSnapshot)partitionSnapshotOpt.get();
        FetchSnapshotResponseData.LeaderIdAndEpoch currentLeaderIdAndEpoch = partitionSnapshot.currentLeader();
        OptionalInt responseLeaderId = KafkaRaftClient.optionalLeaderId(currentLeaderIdAndEpoch.leaderId());
        int responseEpoch = currentLeaderIdAndEpoch.leaderEpoch();
        Errors error = Errors.forCode((short)partitionSnapshot.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(error, responseLeaderId, responseEpoch, currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        FollowerState state = this.quorum.followerStateOrThrow();
        if (Errors.forCode((short)partitionSnapshot.errorCode()) == Errors.SNAPSHOT_NOT_FOUND || partitionSnapshot.snapshotId().endOffset() < 0L || partitionSnapshot.snapshotId().epoch() < 0) {
            this.logger.info("Leader doesn't know about snapshot id {}, returned error {} and snapshot id {}", new Object[]{state.fetchingSnapshot(), partitionSnapshot.errorCode(), partitionSnapshot.snapshotId()});
            state.setFetchingSnapshot(Optional.empty());
            state.resetFetchTimeout(currentTimeMs);
            return true;
        }
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(partitionSnapshot.snapshotId().endOffset(), partitionSnapshot.snapshotId().epoch());
        if (!state.fetchingSnapshot().isPresent()) {
            throw new IllegalStateException(String.format("Received unexpected fetch snapshot response: %s", partitionSnapshot));
        }
        RawSnapshotWriter snapshot = state.fetchingSnapshot().get();
        if (!snapshot.snapshotId().equals(snapshotId)) {
            throw new IllegalStateException(String.format("Received fetch snapshot response with an invalid id. Expected %s; Received %s", snapshot.snapshotId(), snapshotId));
        }
        if (snapshot.sizeInBytes() != partitionSnapshot.position()) {
            throw new IllegalStateException(String.format("Received fetch snapshot response with an invalid position. Expected %d; Received %d", snapshot.sizeInBytes(), partitionSnapshot.position()));
        }
        if (partitionSnapshot.unalignedRecords() instanceof MemoryRecords) {
            records = new UnalignedMemoryRecords(((MemoryRecords)partitionSnapshot.unalignedRecords()).buffer());
        } else if (partitionSnapshot.unalignedRecords() instanceof UnalignedMemoryRecords) {
            records = (UnalignedMemoryRecords)partitionSnapshot.unalignedRecords();
        } else {
            throw new IllegalStateException(String.format("Received unexpected fetch snapshot response: %s", partitionSnapshot));
        }
        snapshot.append(records);
        if (snapshot.sizeInBytes() == partitionSnapshot.size()) {
            snapshot.freeze();
            state.setFetchingSnapshot(Optional.empty());
            if (this.log.truncateToLatestSnapshot()) {
                this.logger.info("Fully truncated the log at ({}, {}) after downloading snapshot {} from leader {}", new Object[]{this.log.endOffset(), this.log.lastFetchedEpoch(), snapshot.snapshotId(), this.quorum.leaderIdOrSentinel()});
                this.partitionState.updateState();
                this.updateFollowerHighWatermark(state, OptionalLong.of(this.log.highWatermark().offset));
            } else {
                throw new IllegalStateException(String.format("Full log truncation expected but didn't happen. Snapshot of %s, log end offset %s, last fetched %d", snapshot.snapshotId(), this.log.endOffset(), this.log.lastFetchedEpoch()));
            }
        }
        state.resetFetchTimeout(currentTimeMs);
        return true;
    }

    private boolean hasConsistentLeader(int epoch, OptionalInt leaderId) {
        if (leaderId.isPresent() && leaderId.getAsInt() == this.quorum.localIdOrSentinel()) {
            return this.quorum.isLeader();
        }
        return epoch != this.quorum.epoch() || !leaderId.isPresent() || !this.quorum.leaderId().isPresent() || leaderId.equals(this.quorum.leaderId());
    }

    private Optional<Boolean> maybeHandleCommonResponse(Errors error, OptionalInt leaderId, int epoch, long currentTimeMs) {
        Optional<Node> leader;
        Optional<Node> optional = leader = leaderId.isPresent() ? this.partitionState.lastVoterSet().voterNode(leaderId.getAsInt(), this.channel.listenerName()) : Optional.empty();
        if (epoch < this.quorum.epoch() || error == Errors.UNKNOWN_LEADER_EPOCH) {
            return Optional.of(true);
        }
        if (epoch > this.quorum.epoch() || error == Errors.FENCED_LEADER_EPOCH || error == Errors.NOT_LEADER_OR_FOLLOWER) {
            this.maybeTransition(leader, epoch, currentTimeMs);
            return Optional.of(true);
        }
        if (epoch == this.quorum.epoch() && leader.isPresent() && !this.quorum.hasLeader()) {
            this.transitionToFollower(epoch, leader.get(), currentTimeMs);
            if (error == Errors.NONE) {
                return Optional.empty();
            }
            return Optional.of(true);
        }
        if (error == Errors.BROKER_NOT_AVAILABLE) {
            return Optional.of(false);
        }
        if (error == Errors.INCONSISTENT_GROUP_PROTOCOL) {
            throw new IllegalStateException("Received error indicating inconsistent voter sets");
        }
        if (error == Errors.INVALID_REQUEST) {
            throw new IllegalStateException("Received unexpected invalid request error");
        }
        return Optional.empty();
    }

    private void maybeTransition(Optional<Node> leader, int epoch, long currentTimeMs) {
        OptionalInt leaderId;
        OptionalInt optionalInt = leaderId = leader.isPresent() ? OptionalInt.of(leader.get().id()) : OptionalInt.empty();
        if (!this.hasConsistentLeader(epoch, leaderId)) {
            throw new IllegalStateException("Received request or response with leader " + leader + " and epoch " + epoch + " which is inconsistent with current leader " + this.quorum.leaderId() + " and epoch " + this.quorum.epoch());
        }
        if (epoch > this.quorum.epoch()) {
            if (leader.isPresent()) {
                this.transitionToFollower(epoch, leader.get(), currentTimeMs);
            } else {
                this.transitionToUnattached(epoch);
            }
        } else if (leader.isPresent() && !this.quorum.hasLeader()) {
            this.transitionToFollower(epoch, leader.get(), currentTimeMs);
        }
    }

    private boolean handleTopLevelError(Errors error, RaftResponse.Inbound response) {
        if (error == Errors.BROKER_NOT_AVAILABLE) {
            return false;
        }
        if (error == Errors.CLUSTER_AUTHORIZATION_FAILED) {
            throw new ClusterAuthorizationException("Received cluster authorization error in response " + response);
        }
        return this.handleUnexpectedError(error, response);
    }

    private boolean handleUnexpectedError(Errors error, RaftResponse.Inbound response) {
        this.logger.error("Unexpected error {} in {} response: {}", new Object[]{error, ApiKeys.forId((int)response.data().apiKey()), response});
        return false;
    }

    private void handleResponse(RaftResponse.Inbound response, long currentTimeMs) {
        boolean handledSuccessfully;
        ApiKeys apiKey = ApiKeys.forId((int)response.data().apiKey());
        switch (apiKey) {
            case FETCH: {
                handledSuccessfully = this.handleFetchResponse(response, currentTimeMs);
                break;
            }
            case VOTE: {
                handledSuccessfully = this.handleVoteResponse(response, currentTimeMs);
                break;
            }
            case BEGIN_QUORUM_EPOCH: {
                handledSuccessfully = this.handleBeginQuorumEpochResponse(response, currentTimeMs);
                break;
            }
            case END_QUORUM_EPOCH: {
                handledSuccessfully = this.handleEndQuorumEpochResponse(response, currentTimeMs);
                break;
            }
            case FETCH_SNAPSHOT: {
                handledSuccessfully = this.handleFetchSnapshotResponse(response, currentTimeMs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Received unexpected response type: " + apiKey);
            }
        }
        this.requestManager.onResponseResult(response.source(), response.correlationId(), handledSuccessfully, currentTimeMs);
    }

    private Optional<Errors> validateVoterOnlyRequest(int remoteNodeId, int requestEpoch) {
        if (requestEpoch < this.quorum.epoch()) {
            return Optional.of(Errors.FENCED_LEADER_EPOCH);
        }
        if (remoteNodeId < 0) {
            return Optional.of(Errors.INVALID_REQUEST);
        }
        return Optional.empty();
    }

    private Optional<Errors> validateLeaderOnlyRequest(int requestEpoch) {
        if (requestEpoch < this.quorum.epoch()) {
            return Optional.of(Errors.FENCED_LEADER_EPOCH);
        }
        if (requestEpoch > this.quorum.epoch()) {
            return Optional.of(Errors.UNKNOWN_LEADER_EPOCH);
        }
        if (!this.quorum.isLeader()) {
            return Optional.of(Errors.NOT_LEADER_OR_FOLLOWER);
        }
        if (this.shutdown.get() != null) {
            return Optional.of(Errors.BROKER_NOT_AVAILABLE);
        }
        return Optional.empty();
    }

    private void handleRequest(RaftRequest.Inbound request, long currentTimeMs) {
        CompletableFuture<FetchResponseData> responseFuture;
        ApiKeys apiKey = ApiKeys.forId((int)request.data().apiKey());
        switch (apiKey) {
            case FETCH: {
                responseFuture = this.handleFetchRequest(request, currentTimeMs);
                break;
            }
            case VOTE: {
                responseFuture = CompletableFuture.completedFuture(this.handleVoteRequest(request));
                break;
            }
            case BEGIN_QUORUM_EPOCH: {
                responseFuture = CompletableFuture.completedFuture(this.handleBeginQuorumEpochRequest(request, currentTimeMs));
                break;
            }
            case END_QUORUM_EPOCH: {
                responseFuture = CompletableFuture.completedFuture(this.handleEndQuorumEpochRequest(request, currentTimeMs));
                break;
            }
            case DESCRIBE_QUORUM: {
                responseFuture = CompletableFuture.completedFuture(this.handleDescribeQuorumRequest(request, currentTimeMs));
                break;
            }
            case FETCH_SNAPSHOT: {
                responseFuture = CompletableFuture.completedFuture(this.handleFetchSnapshotRequest(request, currentTimeMs));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected request type " + apiKey);
            }
        }
        responseFuture.whenComplete((response, exception) -> {
            ApiMessage message = response != null ? response : RaftUtil.errorResponse(apiKey, Errors.forException((Throwable)exception));
            RaftResponse.Outbound responseMessage = new RaftResponse.Outbound(request.correlationId(), message);
            request.completion.complete(responseMessage);
            this.logger.trace("Sent response {} to inbound request {}", (Object)responseMessage, (Object)request);
        });
    }

    private void handleInboundMessage(RaftMessage message, long currentTimeMs) {
        this.logger.trace("Received inbound message {}", (Object)message);
        if (message instanceof RaftRequest.Inbound) {
            RaftRequest.Inbound request = (RaftRequest.Inbound)message;
            this.handleRequest(request, currentTimeMs);
        } else if (message instanceof RaftResponse.Inbound) {
            RaftResponse.Inbound response = (RaftResponse.Inbound)message;
            if (this.requestManager.isResponseExpected(response.source(), response.correlationId())) {
                this.handleResponse(response, currentTimeMs);
            } else {
                this.logger.debug("Ignoring response {} since it is no longer needed", (Object)response);
            }
        } else {
            throw new IllegalArgumentException("Unexpected message " + message);
        }
    }

    private long maybeSendRequest(long currentTimeMs, Node destination, Supplier<ApiMessage> requestSupplier) {
        if (this.requestManager.isBackingOff(destination, currentTimeMs)) {
            long remainingBackoffMs = this.requestManager.remainingBackoffMs(destination, currentTimeMs);
            this.logger.debug("Connection for {} is backing off for {} ms", (Object)destination, (Object)remainingBackoffMs);
            return remainingBackoffMs;
        }
        if (this.requestManager.isReady(destination, currentTimeMs)) {
            int correlationId = this.channel.newCorrelationId();
            ApiMessage request = requestSupplier.get();
            RaftRequest.Outbound requestMessage = new RaftRequest.Outbound(correlationId, request, destination, currentTimeMs);
            requestMessage.completion.whenComplete((response, exception) -> {
                if (exception != null) {
                    ApiKeys api = ApiKeys.forId((int)request.apiKey());
                    Errors error = Errors.forException((Throwable)exception);
                    ApiMessage errorResponse = RaftUtil.errorResponse(api, error);
                    response = new RaftResponse.Inbound(correlationId, errorResponse, destination);
                }
                this.messageQueue.add((RaftMessage)response);
            });
            this.requestManager.onRequestSent(destination, correlationId, currentTimeMs);
            this.channel.send(requestMessage);
            this.logger.trace("Sent outbound request: {}", (Object)requestMessage);
        }
        return this.requestManager.remainingRequestTimeMs(destination, currentTimeMs);
    }

    private EndQuorumEpochRequestData buildEndQuorumEpochRequest(ResignedState state) {
        return EndQuorumEpochRequest.singletonRequest((TopicPartition)this.log.topicPartition(), (String)this.clusterId, (int)this.quorum.epoch(), (int)this.quorum.localIdOrThrow(), state.preferredSuccessors());
    }

    private long maybeSendRequests(long currentTimeMs, Set<Node> destinations, Supplier<ApiMessage> requestSupplier) {
        long minBackoffMs = Long.MAX_VALUE;
        for (Node destination : destinations) {
            long backoffMs = this.maybeSendRequest(currentTimeMs, destination, requestSupplier);
            if (backoffMs >= minBackoffMs) continue;
            minBackoffMs = backoffMs;
        }
        return minBackoffMs;
    }

    private BeginQuorumEpochRequestData buildBeginQuorumEpochRequest() {
        return BeginQuorumEpochRequest.singletonRequest((TopicPartition)this.log.topicPartition(), (String)this.clusterId, (int)this.quorum.epoch(), (int)this.quorum.localIdOrThrow());
    }

    private VoteRequestData buildVoteRequest() {
        OffsetAndEpoch endOffset = this.endOffset();
        return VoteRequest.singletonRequest((TopicPartition)this.log.topicPartition(), (String)this.clusterId, (int)this.quorum.epoch(), (int)this.quorum.localIdOrThrow(), (int)endOffset.epoch(), (long)endOffset.offset());
    }

    private FetchRequestData buildFetchRequest() {
        FetchRequestData request = RaftUtil.singletonFetchRequest(this.log.topicPartition(), this.log.topicId(), fetchPartition -> fetchPartition.setCurrentLeaderEpoch(this.quorum.epoch()).setLastFetchedEpoch(this.log.lastFetchedEpoch()).setFetchOffset(this.log.endOffset().offset));
        return request.setMaxBytes(0x800000).setMaxWaitMs(this.fetchMaxWaitMs).setClusterId(this.clusterId).setReplicaState(new FetchRequestData.ReplicaState().setReplicaId(this.quorum.localIdOrSentinel()));
    }

    private long maybeSendAnyVoterFetch(long currentTimeMs) {
        Optional<Node> readyNode = this.requestManager.findReadyBootstrapServer(currentTimeMs);
        if (readyNode.isPresent()) {
            return this.maybeSendRequest(currentTimeMs, readyNode.get(), this::buildFetchRequest);
        }
        return this.requestManager.backoffBeforeAvailableBootstrapServer(currentTimeMs);
    }

    private FetchSnapshotRequestData buildFetchSnapshotRequest(OffsetAndEpoch snapshotId, long snapshotSize) {
        FetchSnapshotRequestData.SnapshotId requestSnapshotId = new FetchSnapshotRequestData.SnapshotId().setEpoch(snapshotId.epoch()).setEndOffset(snapshotId.offset());
        FetchSnapshotRequestData request = FetchSnapshotRequest.singleton((String)this.clusterId, (int)this.quorum().localIdOrSentinel(), (TopicPartition)this.log.topicPartition(), snapshotPartition -> snapshotPartition.setCurrentLeaderEpoch(this.quorum.epoch()).setSnapshotId(requestSnapshotId).setPosition(snapshotSize));
        return request.setReplicaId(this.quorum.localIdOrSentinel());
    }

    private FetchSnapshotResponseData.PartitionSnapshot addQuorumLeader(FetchSnapshotResponseData.PartitionSnapshot partitionSnapshot) {
        partitionSnapshot.currentLeader().setLeaderEpoch(this.quorum.epoch()).setLeaderId(this.quorum.leaderIdOrSentinel());
        return partitionSnapshot;
    }

    public boolean isRunning() {
        GracefulShutdown gracefulShutdown = this.shutdown.get();
        return gracefulShutdown == null || !gracefulShutdown.isFinished();
    }

    public boolean isShuttingDown() {
        GracefulShutdown gracefulShutdown = this.shutdown.get();
        return gracefulShutdown != null && !gracefulShutdown.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendBatch(LeaderState<T> state, BatchAccumulator.CompletedBatch<T> batch, long appendTimeMs) {
        try {
            int epoch = state.epoch();
            LogAppendInfo info = this.appendAsLeader((Records)batch.data);
            OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(info.lastOffset, epoch);
            CompletableFuture<Long> future = this.appendPurgatory.await(offsetAndEpoch.offset() + 1L, Integer.MAX_VALUE);
            future.whenComplete((commitTimeMs, exception) -> {
                if (exception != null) {
                    this.logger.debug("Failed to commit {} records up to last offset {}", new Object[]{batch.numRecords, offsetAndEpoch, exception});
                } else {
                    long elapsedTime = Math.max(0L, commitTimeMs - appendTimeMs);
                    double elapsedTimePerRecord = (double)elapsedTime / (double)batch.numRecords;
                    this.kafkaRaftMetrics.updateCommitLatency(elapsedTimePerRecord, appendTimeMs);
                    this.logger.debug("Completed commit of {} records up to last offset {}", (Object)batch.numRecords, (Object)offsetAndEpoch);
                    batch.records.ifPresent(records -> this.maybeFireHandleCommit(batch.baseOffset, epoch, batch.appendTimestamp(), batch.sizeInBytes(), (List<T>)records));
                }
            });
        }
        finally {
            batch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long maybeAppendBatches(LeaderState<T> state, long currentTimeMs) {
        long timeUntilDrain = state.accumulator().timeUntilDrain(currentTimeMs);
        if (timeUntilDrain <= 0L) {
            List<BatchAccumulator.CompletedBatch<T>> batches = state.accumulator().drain();
            Iterator<BatchAccumulator.CompletedBatch<T>> iterator = batches.iterator();
            try {
                while (iterator.hasNext()) {
                    BatchAccumulator.CompletedBatch<T> batch = iterator.next();
                    this.appendBatch(state, batch, currentTimeMs);
                }
                this.flushLeaderLog(state, currentTimeMs);
            }
            finally {
                while (iterator.hasNext()) {
                    iterator.next().release();
                }
            }
        }
        return timeUntilDrain;
    }

    private long pollResigned(long currentTimeMs) {
        long stateTimeoutMs;
        ResignedState state = this.quorum.resignedStateOrThrow();
        long endQuorumBackoffMs = this.maybeSendRequests(currentTimeMs, this.partitionState.lastVoterSet().voterNodes(state.unackedVoters().stream(), this.channel.listenerName()), () -> this.buildEndQuorumEpochRequest(state));
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown != null) {
            stateTimeoutMs = shutdown.remainingTimeMs();
        } else if (state.hasElectionTimeoutExpired(currentTimeMs)) {
            this.transitionToCandidate(currentTimeMs);
            stateTimeoutMs = 0L;
        } else {
            stateTimeoutMs = state.remainingElectionTimeMs(currentTimeMs);
        }
        return Math.min(stateTimeoutMs, endQuorumBackoffMs);
    }

    private long pollLeader(long currentTimeMs) {
        LeaderState state = this.quorum.leaderStateOrThrow();
        this.maybeFireLeaderChange(state);
        long timeUntilCheckQuorumExpires = state.timeUntilCheckQuorumExpires(currentTimeMs);
        if (this.shutdown.get() != null || state.isResignRequested() || timeUntilCheckQuorumExpires == 0L) {
            this.transitionToResigned(state.nonLeaderVotersByDescendingFetchOffset());
            return 0L;
        }
        long timeUntilFlush = this.maybeAppendBatches(state, currentTimeMs);
        long timeUntilSend = this.maybeSendRequests(currentTimeMs, this.partitionState.lastVoterSet().voterNodes(state.nonAcknowledgingVoters().stream(), this.channel.listenerName()), this::buildBeginQuorumEpochRequest);
        return Math.min(timeUntilFlush, Math.min(timeUntilSend, timeUntilCheckQuorumExpires));
    }

    private long maybeSendVoteRequests(CandidateState state, long currentTimeMs) {
        if (!state.isVoteRejected()) {
            return this.maybeSendRequests(currentTimeMs, this.partitionState.lastVoterSet().voterNodes(state.unrecordedVoters().stream(), this.channel.listenerName()), this::buildVoteRequest);
        }
        return Long.MAX_VALUE;
    }

    private long pollCandidate(long currentTimeMs) {
        CandidateState state = this.quorum.candidateStateOrThrow();
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown != null) {
            long minRequestBackoffMs = this.maybeSendVoteRequests(state, currentTimeMs);
            return Math.min(shutdown.remainingTimeMs(), minRequestBackoffMs);
        }
        if (state.isBackingOff()) {
            if (state.isBackoffComplete(currentTimeMs)) {
                this.logger.info("Re-elect as candidate after election backoff has completed");
                this.transitionToCandidate(currentTimeMs);
                return 0L;
            }
            return state.remainingBackoffMs(currentTimeMs);
        }
        if (state.hasElectionTimeoutExpired(currentTimeMs)) {
            long backoffDurationMs = this.binaryExponentialElectionBackoffMs(state.retries());
            this.logger.info("Election has timed out, backing off for {}ms before becoming a candidate again", (Object)backoffDurationMs);
            state.startBackingOff(currentTimeMs, backoffDurationMs);
            return backoffDurationMs;
        }
        long minRequestBackoffMs = this.maybeSendVoteRequests(state, currentTimeMs);
        return Math.min(minRequestBackoffMs, state.remainingElectionTimeMs(currentTimeMs));
    }

    private long pollFollower(long currentTimeMs) {
        FollowerState state = this.quorum.followerStateOrThrow();
        if (this.quorum.isVoter()) {
            return this.pollFollowerAsVoter(state, currentTimeMs);
        }
        return this.pollFollowerAsObserver(state, currentTimeMs);
    }

    private long pollFollowerAsVoter(FollowerState state, long currentTimeMs) {
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown != null) {
            return 0L;
        }
        if (state.hasFetchTimeoutExpired(currentTimeMs)) {
            this.logger.info("Become candidate due to fetch timeout");
            this.transitionToCandidate(currentTimeMs);
            return 0L;
        }
        long backoffMs = this.maybeSendFetchOrFetchSnapshot(state, currentTimeMs);
        return Math.min(backoffMs, state.remainingFetchTimeMs(currentTimeMs));
    }

    private long pollFollowerAsObserver(FollowerState state, long currentTimeMs) {
        long backoffMs;
        if (state.hasFetchTimeoutExpired(currentTimeMs)) {
            return this.maybeSendAnyVoterFetch(currentTimeMs);
        }
        if (this.requestManager.hasRequestTimedOut(state.leader(), currentTimeMs)) {
            this.requestManager.reset(state.leader());
            backoffMs = this.maybeSendAnyVoterFetch(currentTimeMs);
        } else {
            backoffMs = this.requestManager.isBackingOff(state.leader(), currentTimeMs) ? this.maybeSendAnyVoterFetch(currentTimeMs) : (!this.requestManager.hasAnyInflightRequest(currentTimeMs) ? this.maybeSendFetchOrFetchSnapshot(state, currentTimeMs) : this.requestManager.backoffBeforeAvailableBootstrapServer(currentTimeMs));
        }
        return Math.min(backoffMs, state.remainingFetchTimeMs(currentTimeMs));
    }

    private long maybeSendFetchOrFetchSnapshot(FollowerState state, long currentTimeMs) {
        Supplier<ApiMessage> requestSupplier;
        if (state.fetchingSnapshot().isPresent()) {
            RawSnapshotWriter snapshot = state.fetchingSnapshot().get();
            long snapshotSize = snapshot.sizeInBytes();
            requestSupplier = () -> this.buildFetchSnapshotRequest(snapshot.snapshotId(), snapshotSize);
        } else {
            requestSupplier = this::buildFetchRequest;
        }
        return this.maybeSendRequest(currentTimeMs, state.leader(), requestSupplier);
    }

    private long pollVoted(long currentTimeMs) {
        VotedState state = this.quorum.votedStateOrThrow();
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown != null) {
            return shutdown.remainingTimeMs();
        }
        if (state.hasElectionTimeoutExpired(currentTimeMs)) {
            this.transitionToCandidate(currentTimeMs);
            return 0L;
        }
        return state.remainingElectionTimeMs(currentTimeMs);
    }

    private long pollUnattached(long currentTimeMs) {
        UnattachedState state = this.quorum.unattachedStateOrThrow();
        if (this.quorum.isVoter()) {
            return this.pollUnattachedAsVoter(state, currentTimeMs);
        }
        return this.pollUnattachedAsObserver(state, currentTimeMs);
    }

    private long pollUnattachedAsVoter(UnattachedState state, long currentTimeMs) {
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown != null) {
            return shutdown.remainingTimeMs();
        }
        if (state.hasElectionTimeoutExpired(currentTimeMs)) {
            this.transitionToCandidate(currentTimeMs);
            return 0L;
        }
        return state.remainingElectionTimeMs(currentTimeMs);
    }

    private long pollUnattachedAsObserver(UnattachedState state, long currentTimeMs) {
        long fetchBackoffMs = this.maybeSendAnyVoterFetch(currentTimeMs);
        return Math.min(fetchBackoffMs, state.remainingElectionTimeMs(currentTimeMs));
    }

    private long pollCurrentState(long currentTimeMs) {
        if (this.quorum.isLeader()) {
            return this.pollLeader(currentTimeMs);
        }
        if (this.quorum.isCandidate()) {
            return this.pollCandidate(currentTimeMs);
        }
        if (this.quorum.isFollower()) {
            return this.pollFollower(currentTimeMs);
        }
        if (this.quorum.isVoted()) {
            return this.pollVoted(currentTimeMs);
        }
        if (this.quorum.isUnattached()) {
            return this.pollUnattached(currentTimeMs);
        }
        if (this.quorum.isResigned()) {
            return this.pollResigned(currentTimeMs);
        }
        throw new IllegalStateException("Unexpected quorum state " + this.quorum);
    }

    private void pollListeners() {
        Registration<T> registration;
        while ((registration = this.pendingRegistrations.poll()) != null) {
            this.processRegistration(registration);
        }
        this.quorum.highWatermark().ifPresent(highWatermarkMetadata -> this.updateListenersProgress(highWatermarkMetadata.offset));
        Optional leaderState = this.quorum.maybeLeaderState();
        if (leaderState.isPresent()) {
            this.maybeFireLeaderChange(leaderState.get());
        } else {
            this.maybeFireLeaderChange();
        }
    }

    private void processRegistration(Registration<T> registration) {
        RaftClient.Listener listener = ((Registration)registration).listener();
        Registration.Ops ops = ((Registration)registration).ops();
        if (ops == Registration.Ops.REGISTER) {
            if (this.listenerContexts.putIfAbsent(listener, new ListenerContext(listener)) != null) {
                this.logger.error("Attempting to add a listener that already exists: {}", (Object)KafkaRaftClient.listenerName(listener));
            } else {
                this.logger.info("Registered the listener {}", (Object)KafkaRaftClient.listenerName(listener));
            }
        } else if (this.listenerContexts.remove(listener) == null) {
            this.logger.error("Attempting to remove a listener that doesn't exists: {}", (Object)KafkaRaftClient.listenerName(listener));
        } else {
            this.logger.info("Unregistered the listener {}", (Object)KafkaRaftClient.listenerName(listener));
        }
    }

    private boolean maybeCompleteShutdown(long currentTimeMs) {
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown == null) {
            return false;
        }
        shutdown.update(currentTimeMs);
        if (shutdown.hasTimedOut()) {
            shutdown.failWithTimeout();
            return true;
        }
        if (this.quorum.isObserver() || this.quorum.isOnlyVoter() || this.quorum.hasRemoteLeader()) {
            shutdown.complete();
            return true;
        }
        return false;
    }

    private void wakeup() {
        this.messageQueue.wakeup();
    }

    public void handle(RaftRequest.Inbound request) {
        this.messageQueue.add(Objects.requireNonNull(request));
    }

    public void poll() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Replica needs to be initialized before polling");
        }
        long startPollTimeMs = this.time.milliseconds();
        if (this.maybeCompleteShutdown(startPollTimeMs)) {
            return;
        }
        long pollStateTimeoutMs = this.pollCurrentState(startPollTimeMs);
        long cleaningTimeoutMs = this.snapshotCleaner.maybeClean(startPollTimeMs);
        long pollTimeoutMs = Math.min(pollStateTimeoutMs, cleaningTimeoutMs);
        long startWaitTimeMs = this.time.milliseconds();
        this.kafkaRaftMetrics.updatePollStart(startWaitTimeMs);
        RaftMessage message = this.messageQueue.poll(pollTimeoutMs);
        long endWaitTimeMs = this.time.milliseconds();
        this.kafkaRaftMetrics.updatePollEnd(endWaitTimeMs);
        if (message != null) {
            this.handleInboundMessage(message, endWaitTimeMs);
        }
        this.pollListeners();
    }

    @Override
    public long scheduleAppend(int epoch, List<T> records) {
        return this.append(epoch, records, OptionalLong.empty(), false);
    }

    @Override
    public long scheduleAtomicAppend(int epoch, OptionalLong requiredBaseOffset, List<T> records) {
        return this.append(epoch, records, requiredBaseOffset, true);
    }

    private long append(int epoch, List<T> records, OptionalLong requiredBaseOffset, boolean isAtomic) {
        if (!this.isInitialized()) {
            throw new NotLeaderException("Append failed because the replica is not the current leader");
        }
        LeaderState leaderState = this.quorum.maybeLeaderState().orElseThrow(() -> new NotLeaderException("Append failed because the replica is not the current leader"));
        BatchAccumulator<T> accumulator = leaderState.accumulator();
        boolean isFirstAppend = accumulator.isEmpty();
        long offset = accumulator.append(epoch, records, requiredBaseOffset, isAtomic);
        if (isFirstAppend || accumulator.needsDrain(this.time.milliseconds())) {
            this.wakeup();
        }
        return offset;
    }

    @Override
    public CompletableFuture<Void> shutdown(int timeoutMs) {
        this.logger.info("Beginning graceful shutdown");
        CompletableFuture<Void> shutdownComplete = new CompletableFuture<Void>();
        this.shutdown.set(new GracefulShutdown(timeoutMs, shutdownComplete));
        this.wakeup();
        return shutdownComplete;
    }

    @Override
    public void resign(int epoch) {
        if (epoch < 0) {
            throw new IllegalArgumentException("Attempt to resign from an invalid negative epoch " + epoch);
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("Replica needs to be initialized before resigning");
        }
        if (!this.quorum.isVoter()) {
            throw new IllegalStateException("Attempt to resign by a non-voter");
        }
        LeaderAndEpoch leaderAndEpoch = this.leaderAndEpoch();
        int currentEpoch = leaderAndEpoch.epoch();
        if (epoch > currentEpoch) {
            throw new IllegalArgumentException("Attempt to resign from epoch " + epoch + " which is larger than the current epoch " + currentEpoch);
        }
        if (epoch < currentEpoch) {
            this.logger.debug("Ignoring call to resign from epoch {} since it is smaller than the current epoch {}", (Object)epoch, (Object)currentEpoch);
        } else {
            if (!leaderAndEpoch.isLeader(this.quorum.localIdOrThrow())) {
                throw new IllegalArgumentException("Cannot resign from epoch " + epoch + " since we are not the leader");
            }
            Optional leaderStateOpt = this.quorum.maybeLeaderState();
            if (!leaderStateOpt.isPresent()) {
                this.logger.debug("Ignoring call to resign from epoch {} since this node is no longer the leader", (Object)epoch);
                return;
            }
            LeaderState leaderState = leaderStateOpt.get();
            if (leaderState.epoch() != epoch) {
                this.logger.debug("Ignoring call to resign from epoch {} since it is smaller than the current epoch {}", (Object)epoch, (Object)leaderState.epoch());
            } else {
                this.logger.info("Received user request to resign from the current epoch {}", (Object)currentEpoch);
                leaderState.requestResign();
                this.wakeup();
            }
        }
    }

    @Override
    public Optional<SnapshotWriter<T>> createSnapshot(OffsetAndEpoch snapshotId, long lastContainedLogTimestamp) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Cannot create snapshot before the replica has been initialized");
        }
        return this.log.createNewSnapshot(snapshotId).map(writer -> {
            long lastContainedLogOffset = snapshotId.offset() - 1L;
            NotifyingRawSnapshotWriter wrappedWriter = new NotifyingRawSnapshotWriter((RawSnapshotWriter)writer, offsetAndEpoch -> this.partitionState.truncateOldEntries(offsetAndEpoch.offset()));
            return new RecordsSnapshotWriter.Builder().setLastContainedLogTimestamp(lastContainedLogTimestamp).setTime(this.time).setMaxBatchSize(0x800000).setMemoryPool(this.memoryPool).setRawSnapshotWriter(wrappedWriter).setKraftVersion(this.partitionState.kraftVersionAtOffset(lastContainedLogOffset)).setVoterSet(this.partitionState.voterSetAtOffset(lastContainedLogOffset)).build(this.serde);
        });
    }

    @Override
    public Optional<OffsetAndEpoch> latestSnapshotId() {
        return this.log.latestSnapshotId();
    }

    @Override
    public long logEndOffset() {
        return this.log.endOffset().offset;
    }

    @Override
    public void close() {
        this.log.flush(true);
        if (this.kafkaRaftMetrics != null) {
            this.kafkaRaftMetrics.close();
        }
        if (this.memoryPool instanceof BatchMemoryPool) {
            BatchMemoryPool batchMemoryPool = (BatchMemoryPool)this.memoryPool;
            batchMemoryPool.releaseRetained();
        }
    }

    @Override
    public OptionalLong highWatermark() {
        if (this.isInitialized() && this.quorum.highWatermark().isPresent()) {
            return OptionalLong.of(this.quorum.highWatermark().get().offset);
        }
        return OptionalLong.empty();
    }

    public Optional<Node> voterNode(int id, ListenerName listenerName) {
        return this.partitionState.lastVoterSet().voterNode(id, listenerName);
    }

    QuorumState quorum() {
        return this.quorum;
    }

    private boolean isInitialized() {
        return this.partitionState != null && this.quorum != null && this.requestManager != null && this.kafkaRaftMetrics != null;
    }

    private final class ListenerContext
    implements CloseListener<BatchReader<T>> {
        private final RaftClient.Listener<T> listener;
        private LeaderAndEpoch lastFiredLeaderChange = LeaderAndEpoch.UNKNOWN;
        private BatchReader<T> lastSent = null;
        private long nextOffset = 0L;

        private ListenerContext(RaftClient.Listener<T> listener) {
            this.listener = listener;
        }

        private synchronized long nextOffset() {
            return this.nextOffset;
        }

        private synchronized OptionalLong nextExpectedOffset() {
            if (this.lastSent != null) {
                OptionalLong lastSentOffset = this.lastSent.lastOffset();
                if (lastSentOffset.isPresent()) {
                    return OptionalLong.of(lastSentOffset.getAsLong() + 1L);
                }
                return OptionalLong.empty();
            }
            return OptionalLong.of(this.nextOffset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireHandleSnapshot(SnapshotReader<T> reader) {
            ListenerContext listenerContext = this;
            synchronized (listenerContext) {
                this.nextOffset = reader.snapshotId().offset();
                this.lastSent = null;
            }
            KafkaRaftClient.this.logger.debug("Notifying listener {} of snapshot {}", (Object)this.listenerName(), (Object)reader.snapshotId());
            this.listener.handleLoadSnapshot(reader);
        }

        private void fireHandleCommit(long baseOffset, Records records) {
            this.fireHandleCommit(RecordsBatchReader.of(baseOffset, records, KafkaRaftClient.this.serde, BufferSupplier.create(), 0x800000, this, true));
        }

        private void fireHandleCommit(long baseOffset, int epoch, long appendTimestamp, int sizeInBytes, List<T> records) {
            Batch batch = Batch.data(baseOffset, epoch, appendTimestamp, sizeInBytes, records);
            MemoryBatchReader reader = MemoryBatchReader.of(Collections.singletonList(batch), this);
            this.fireHandleCommit(reader);
        }

        private String listenerName() {
            return KafkaRaftClient.listenerName(this.listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireHandleCommit(BatchReader<T> reader) {
            ListenerContext listenerContext = this;
            synchronized (listenerContext) {
                this.lastSent = reader;
            }
            KafkaRaftClient.this.logger.debug("Notifying listener {} of batch for baseOffset {} and lastOffset {}", new Object[]{this.listenerName(), reader.baseOffset(), reader.lastOffset()});
            this.listener.handleCommit(reader);
        }

        private void maybeFireLeaderChange(LeaderAndEpoch leaderAndEpoch) {
            if (this.shouldFireLeaderChange(leaderAndEpoch)) {
                this.lastFiredLeaderChange = leaderAndEpoch;
                KafkaRaftClient.this.logger.debug("Notifying listener {} of leader change {}", (Object)this.listenerName(), (Object)leaderAndEpoch);
                this.listener.handleLeaderChange(leaderAndEpoch);
            }
        }

        private boolean shouldFireLeaderChange(LeaderAndEpoch leaderAndEpoch) {
            if (leaderAndEpoch.equals(this.lastFiredLeaderChange)) {
                return false;
            }
            if (leaderAndEpoch.epoch() > this.lastFiredLeaderChange.epoch()) {
                return true;
            }
            return leaderAndEpoch.leaderId().isPresent() && !this.lastFiredLeaderChange.leaderId().isPresent();
        }

        private void maybeFireLeaderChange(LeaderAndEpoch leaderAndEpoch, long epochStartOffset) {
            if (this.shouldFireLeaderChange(leaderAndEpoch) && this.nextOffset() > epochStartOffset) {
                this.lastFiredLeaderChange = leaderAndEpoch;
                this.listener.handleLeaderChange(leaderAndEpoch);
            }
        }

        @Override
        public synchronized void onClose(BatchReader<T> reader) {
            OptionalLong lastOffset = reader.lastOffset();
            if (lastOffset.isPresent()) {
                this.nextOffset = lastOffset.getAsLong() + 1L;
            }
            if (this.lastSent == reader) {
                this.lastSent = null;
                KafkaRaftClient.this.wakeup();
            }
        }
    }

    private static final class Registration<T> {
        private final Ops ops;
        private final RaftClient.Listener<T> listener;

        private Registration(Ops ops, RaftClient.Listener<T> listener) {
            this.ops = ops;
            this.listener = listener;
        }

        private Ops ops() {
            return this.ops;
        }

        private RaftClient.Listener<T> listener() {
            return this.listener;
        }

        private static <T> Registration<T> register(RaftClient.Listener<T> listener) {
            return new Registration<T>(Ops.REGISTER, listener);
        }

        private static <T> Registration<T> unregister(RaftClient.Listener<T> listener) {
            return new Registration<T>(Ops.UNREGISTER, listener);
        }

        private static enum Ops {
            REGISTER,
            UNREGISTER;

        }
    }

    private class GracefulShutdown {
        final Timer finishTimer;
        final CompletableFuture<Void> completeFuture;

        public GracefulShutdown(long shutdownTimeoutMs, CompletableFuture<Void> completeFuture) {
            this.finishTimer = KafkaRaftClient.this.time.timer(shutdownTimeoutMs);
            this.completeFuture = completeFuture;
        }

        public void update(long currentTimeMs) {
            this.finishTimer.update(currentTimeMs);
        }

        public boolean hasTimedOut() {
            return this.finishTimer.isExpired();
        }

        public boolean isFinished() {
            return this.completeFuture.isDone();
        }

        public long remainingTimeMs() {
            return this.finishTimer.remainingMs();
        }

        public void failWithTimeout() {
            KafkaRaftClient.this.logger.warn("Graceful shutdown timed out after {}ms", (Object)this.finishTimer.timeoutMs());
            this.completeFuture.completeExceptionally(new TimeoutException("Timeout expired before graceful shutdown completed"));
        }

        public void complete() {
            KafkaRaftClient.this.logger.info("Graceful shutdown completed");
            this.completeFuture.complete(null);
        }
    }

    private static class RaftMetadataLogCleanerManager {
        private final Logger logger;
        private final Timer timer;
        private final long delayMs;
        private final Runnable cleaner;

        RaftMetadataLogCleanerManager(Logger logger, Time time, long delayMs, Runnable cleaner) {
            this.logger = logger;
            this.timer = time.timer(delayMs);
            this.delayMs = delayMs;
            this.cleaner = cleaner;
        }

        public long maybeClean(long currentTimeMs) {
            this.timer.update(currentTimeMs);
            if (this.timer.isExpired()) {
                try {
                    this.cleaner.run();
                }
                catch (Throwable t) {
                    this.logger.error("Had an error during log cleaning", t);
                }
                this.timer.reset(this.delayMs);
            }
            return this.timer.remainingMs();
        }
    }
}

