/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.StoreToProcessorContextAdapter;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;

public interface StateStore {
    public String name();

    @Deprecated
    public void init(ProcessorContext var1, StateStore var2);

    default public void init(StateStoreContext context, StateStore root) {
        this.init(StoreToProcessorContextAdapter.adapt(context), root);
    }

    public void flush();

    public void close();

    public boolean persistent();

    public boolean isOpen();

    @InterfaceStability.Evolving
    default public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        return QueryResult.forUnknownQueryType(query, this);
    }

    @InterfaceStability.Evolving
    default public Position getPosition() {
        throw new UnsupportedOperationException("getPosition is not implemented by this StateStore (" + this.getClass() + ")");
    }
}

