/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.LinkedList;

final class ExceptionUtils {
    private ExceptionUtils() {
    }

    static LinkedList<RuntimeException> executeAll(Runnable ... actions) {
        LinkedList<RuntimeException> suppressed = new LinkedList<RuntimeException>();
        for (Runnable action : actions) {
            try {
                action.run();
            }
            catch (RuntimeException exception) {
                suppressed.add(exception);
            }
        }
        return suppressed;
    }

    static void throwSuppressed(String message, LinkedList<RuntimeException> suppressed) {
        if (!suppressed.isEmpty()) {
            RuntimeException firstCause = suppressed.pollFirst();
            RuntimeException toThrow = new RuntimeException(message, firstCause);
            for (RuntimeException e : suppressed) {
                toThrow.addSuppressed(e);
            }
            throw toThrow;
        }
    }
}

