/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.WorkerSourceTask;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.LoggingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SourceTaskOffsetCommitter {
    private static final Logger log = LoggerFactory.getLogger(SourceTaskOffsetCommitter.class);
    private final WorkerConfig config;
    private final ScheduledExecutorService commitExecutorService;
    private final ConcurrentMap<ConnectorTaskId, ScheduledFuture<?>> committers;

    SourceTaskOffsetCommitter(WorkerConfig config, ScheduledExecutorService commitExecutorService, ConcurrentMap<ConnectorTaskId, ScheduledFuture<?>> committers) {
        this.config = config;
        this.commitExecutorService = commitExecutorService;
        this.committers = committers;
    }

    public SourceTaskOffsetCommitter(WorkerConfig config) {
        this(config, Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)(SourceTaskOffsetCommitter.class.getSimpleName() + "-%d"), (boolean)false)), new ConcurrentHashMap());
    }

    public void close(long timeoutMs) {
        ThreadUtils.shutdownExecutorServiceQuietly((ExecutorService)this.commitExecutorService, (long)timeoutMs, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void schedule(ConnectorTaskId id, WorkerSourceTask workerTask) {
        long commitIntervalMs = this.config.getLong("offset.flush.interval.ms");
        ScheduledFuture<?> commitFuture = this.commitExecutorService.scheduleWithFixedDelay(() -> {
            try (LoggingContext loggingContext = LoggingContext.forOffsets(id);){
                SourceTaskOffsetCommitter.commit(workerTask);
            }
        }, commitIntervalMs, commitIntervalMs, TimeUnit.MILLISECONDS);
        this.committers.put(id, commitFuture);
    }

    public void remove(ConnectorTaskId id) {
        ScheduledFuture task = (ScheduledFuture)this.committers.remove(id);
        if (task == null) {
            return;
        }
        try (LoggingContext loggingContext = LoggingContext.forTask(id);){
            task.cancel(false);
            if (!task.isDone()) {
                task.get();
            }
        }
        catch (CancellationException e) {
            log.trace("Offset commit thread was cancelled by another thread while removing connector task with id: {}", (Object)id);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ConnectException("Unexpected interruption in SourceTaskOffsetCommitter while removing task with id: " + id, (Throwable)e);
        }
    }

    static void commit(WorkerSourceTask workerTask) {
        if (!workerTask.shouldCommitOffsets()) {
            log.trace("{} Skipping offset commit as there are no offsets that should be committed", (Object)workerTask);
            return;
        }
        log.debug("{} Committing offsets", (Object)workerTask);
        try {
            if (workerTask.commitOffsets()) {
                return;
            }
            log.error("{} Failed to commit offsets", (Object)workerTask);
        }
        catch (Throwable t) {
            log.error("{} Unhandled exception when committing: ", (Object)workerTask, (Object)t);
        }
    }
}

