/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.state.internals.AbstractSegments;
import org.apache.kafka.streams.state.internals.TimestampedSegment;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;

class TimestampedSegments
extends AbstractSegments<TimestampedSegment> {
    private final RocksDBMetricsRecorder metricsRecorder;

    TimestampedSegments(String name, String metricsScope, long retentionPeriod, long segmentInterval) {
        super(name, retentionPeriod, segmentInterval);
        this.metricsRecorder = new RocksDBMetricsRecorder(metricsScope, name);
    }

    @Override
    public TimestampedSegment getOrCreateSegment(long segmentId, ProcessorContext context) {
        if (this.segments.containsKey(segmentId)) {
            return (TimestampedSegment)this.segments.get(segmentId);
        }
        TimestampedSegment newSegment = new TimestampedSegment(this.segmentName(segmentId), this.name, segmentId, this.position, this.metricsRecorder);
        if (this.segments.put(segmentId, newSegment) != null) {
            throw new IllegalStateException("TimestampedSegment already exists. Possible concurrent access.");
        }
        newSegment.openDB(context.appConfigs(), context.stateDir());
        return newSegment;
    }

    @Override
    public TimestampedSegment getOrCreateSegmentIfLive(long segmentId, ProcessorContext context, long streamTime) {
        TimestampedSegment segment = (TimestampedSegment)super.getOrCreateSegmentIfLive(segmentId, context, streamTime);
        this.cleanupExpiredSegments(streamTime);
        return segment;
    }

    @Override
    public void openExisting(ProcessorContext context, long streamTime) {
        this.metricsRecorder.init(ProcessorContextUtils.getMetricsImpl(context), context.taskId());
        super.openExisting(context, streamTime);
    }
}

