/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.ReplicaKey;
import org.slf4j.Logger;

public class UnattachedState
implements EpochState {
    private final int epoch;
    private final OptionalInt leaderId;
    private final Optional<ReplicaKey> votedKey;
    private final Set<Integer> voters;
    private final long electionTimeoutMs;
    private final Timer electionTimer;
    private final Optional<LogOffsetMetadata> highWatermark;
    private final Logger log;

    public UnattachedState(Time time, int epoch, OptionalInt leaderId, Optional<ReplicaKey> votedKey, Set<Integer> voters, Optional<LogOffsetMetadata> highWatermark, long electionTimeoutMs, LogContext logContext) {
        this.epoch = epoch;
        this.leaderId = leaderId;
        this.votedKey = votedKey;
        this.voters = voters;
        this.highWatermark = highWatermark;
        this.electionTimeoutMs = electionTimeoutMs;
        this.electionTimer = time.timer(electionTimeoutMs);
        this.log = logContext.logger(UnattachedState.class);
    }

    @Override
    public ElectionState election() {
        if (this.votedKey.isPresent()) {
            return ElectionState.withVotedCandidate(this.epoch, this.votedKey().get(), this.voters);
        }
        if (this.leaderId.isPresent()) {
            return ElectionState.withElectedLeader(this.epoch, this.leaderId.getAsInt(), this.voters);
        }
        return ElectionState.withUnknownLeader(this.epoch, this.voters);
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public Endpoints leaderEndpoints() {
        return Endpoints.empty();
    }

    @Override
    public String name() {
        return "Unattached";
    }

    public Optional<ReplicaKey> votedKey() {
        return this.votedKey;
    }

    public long electionTimeoutMs() {
        return this.electionTimeoutMs;
    }

    public long remainingElectionTimeMs(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.remainingMs();
    }

    public boolean hasElectionTimeoutExpired(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.isExpired();
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    @Override
    public boolean canGrantVote(ReplicaKey candidateKey, boolean isLogUpToDate) {
        if (this.votedKey.isPresent()) {
            ReplicaKey votedReplicaKey = this.votedKey.get();
            if (votedReplicaKey.id() == candidateKey.id()) {
                return !votedReplicaKey.directoryId().isPresent() || votedReplicaKey.directoryId().equals(candidateKey.directoryId());
            }
            this.log.debug("Rejecting vote request from candidate ({}), already have voted for another candidate ({}) in epoch {}", new Object[]{candidateKey, this.votedKey, this.epoch});
            return false;
        }
        if (this.leaderId.isPresent()) {
            this.log.debug("Rejecting vote request from candidate ({}) since we already have a leader {} in epoch {}", new Object[]{candidateKey, this.leaderId, this.epoch});
            return false;
        }
        if (!isLogUpToDate) {
            this.log.debug("Rejecting vote request from candidate ({}) since candidate epoch/offset is not up to date with us", (Object)candidateKey);
        }
        return isLogUpToDate;
    }

    public String toString() {
        return "Unattached(epoch=" + this.epoch + ", votedKey=" + this.votedKey.map(ReplicaKey::toString).orElse("null") + ", voters=" + this.voters + ", electionTimeoutMs=" + this.electionTimeoutMs + ", highWatermark=" + this.highWatermark + ')';
    }

    @Override
    public void close() {
    }
}

