/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;

public abstract class ApiMessageFormatter
implements MessageFormatter {
    private static final String VERSION = "version";
    private static final String DATA = "data";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    static final String UNKNOWN = "unknown";

    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
        byte[] key = (byte[])consumerRecord.key();
        if (Objects.nonNull(key)) {
            short keyVersion = ByteBuffer.wrap(key).getShort();
            JsonNode dataNode = this.readToKeyJson(ByteBuffer.wrap(key), keyVersion);
            if (dataNode instanceof NullNode) {
                return;
            }
            json.putObject(KEY).put(VERSION, keyVersion).set(DATA, dataNode);
        } else {
            json.set(KEY, (JsonNode)NullNode.getInstance());
        }
        byte[] value = (byte[])consumerRecord.value();
        if (Objects.nonNull(value)) {
            short valueVersion = ByteBuffer.wrap(value).getShort();
            JsonNode dataNode = this.readToValueJson(ByteBuffer.wrap(value), valueVersion);
            json.putObject(VALUE).put(VERSION, valueVersion).set(DATA, dataNode);
        } else {
            json.set(VALUE, (JsonNode)NullNode.getInstance());
        }
        try {
            output.write(json.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract JsonNode readToKeyJson(ByteBuffer var1, short var2);

    protected abstract JsonNode readToValueJson(ByteBuffer var1, short var2);
}

