/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class OffsetCommitValue
implements ApiMessage {
    long offset;
    int leaderEpoch;
    String metadata;
    long commitTimestamp;
    long expireTimestamp;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64, ""), new Field("metadata", (Type)Type.STRING, ""), new Field("commit_timestamp", (Type)Type.INT64, "")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64, ""), new Field("metadata", (Type)Type.STRING, ""), new Field("commit_timestamp", (Type)Type.INT64, ""), new Field("expire_timestamp", (Type)Type.INT64, "")});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64, ""), new Field("metadata", (Type)Type.STRING, ""), new Field("commit_timestamp", (Type)Type.INT64, "")});
    public static final Schema SCHEMA_3 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64, ""), new Field("leader_epoch", (Type)Type.INT32, ""), new Field("metadata", (Type)Type.STRING, ""), new Field("commit_timestamp", (Type)Type.INT64, "")});
    public static final Schema SCHEMA_4 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64, ""), new Field("leader_epoch", (Type)Type.INT32, ""), new Field("metadata", (Type)Type.COMPACT_STRING, ""), new Field("commit_timestamp", (Type)Type.INT64, ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 4;

    public OffsetCommitValue(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public OffsetCommitValue() {
        this.offset = 0L;
        this.leaderEpoch = -1;
        this.metadata = "";
        this.commitTimestamp = 0L;
        this.expireTimestamp = -1L;
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 4;
    }

    public final void read(Readable _readable, short _version) {
        this.offset = _readable.readLong();
        this.leaderEpoch = _version >= 3 ? _readable.readInt() : -1;
        int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field metadata was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field metadata had invalid length " + length);
        }
        this.metadata = _readable.readString(length);
        this.commitTimestamp = _readable.readLong();
        this.expireTimestamp = _version >= 1 && _version <= 1 ? _readable.readLong() : -1L;
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeLong(this.offset);
        if (_version >= 3) {
            _writable.writeInt(this.leaderEpoch);
        }
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.metadata);
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
        } else {
            _writable.writeShort((short)_stringBytes.length);
        }
        _writable.writeByteArray(_stringBytes);
        _writable.writeLong(this.commitTimestamp);
        if (_version >= 1 && _version <= 1) {
            _writable.writeLong(this.expireTimestamp);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _size.addBytes(8);
        if (_version >= 3) {
            _size.addBytes(4);
        }
        if ((_stringBytes = this.metadata.getBytes(StandardCharsets.UTF_8)).length > Short.MAX_VALUE) {
            throw new RuntimeException("'metadata' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.metadata, _stringBytes);
        if (_version >= 4) {
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        } else {
            _size.addBytes(_stringBytes.length + 2);
        }
        _size.addBytes(8);
        if (_version >= 1 && _version <= 1) {
            _size.addBytes(8);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetCommitValue)) {
            return false;
        }
        OffsetCommitValue other = (OffsetCommitValue)obj;
        if (this.offset != other.offset) {
            return false;
        }
        if (this.leaderEpoch != other.leaderEpoch) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.commitTimestamp != other.commitTimestamp) {
            return false;
        }
        if (this.expireTimestamp != other.expireTimestamp) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
        hashCode = 31 * hashCode + this.leaderEpoch;
        hashCode = 31 * hashCode + (this.metadata == null ? 0 : this.metadata.hashCode());
        hashCode = 31 * hashCode + ((int)(this.commitTimestamp >> 32) ^ (int)this.commitTimestamp);
        hashCode = 31 * hashCode + ((int)(this.expireTimestamp >> 32) ^ (int)this.expireTimestamp);
        return hashCode;
    }

    public OffsetCommitValue duplicate() {
        OffsetCommitValue _duplicate = new OffsetCommitValue();
        _duplicate.offset = this.offset;
        _duplicate.leaderEpoch = this.leaderEpoch;
        _duplicate.metadata = this.metadata;
        _duplicate.commitTimestamp = this.commitTimestamp;
        _duplicate.expireTimestamp = this.expireTimestamp;
        return _duplicate;
    }

    public String toString() {
        return "OffsetCommitValue(offset=" + this.offset + ", leaderEpoch=" + this.leaderEpoch + ", metadata=" + (this.metadata == null ? "null" : "'" + this.metadata.toString() + "'") + ", commitTimestamp=" + this.commitTimestamp + ", expireTimestamp=" + this.expireTimestamp + ")";
    }

    public long offset() {
        return this.offset;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public String metadata() {
        return this.metadata;
    }

    public long commitTimestamp() {
        return this.commitTimestamp;
    }

    public long expireTimestamp() {
        return this.expireTimestamp;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public OffsetCommitValue setOffset(long v) {
        this.offset = v;
        return this;
    }

    public OffsetCommitValue setLeaderEpoch(int v) {
        this.leaderEpoch = v;
        return this;
    }

    public OffsetCommitValue setMetadata(String v) {
        this.metadata = v;
        return this;
    }

    public OffsetCommitValue setCommitTimestamp(long v) {
        this.commitTimestamp = v;
        return this;
    }

    public OffsetCommitValue setExpireTimestamp(long v) {
        this.expireTimestamp = v;
        return this;
    }
}

