/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.MemberSubscription;
import org.apache.kafka.coordinator.group.modern.Assignment;

public class MemberSubscriptionAndAssignmentImpl
implements MemberSubscription,
MemberAssignment {
    private final Optional<String> rackId;
    private final Optional<String> instanceId;
    private final Set<Uuid> subscribedTopicIds;
    private final Assignment memberAssignment;

    public MemberSubscriptionAndAssignmentImpl(Optional<String> rackId, Optional<String> instanceId, Set<Uuid> subscribedTopicIds, Assignment memberAssignment) {
        this.rackId = Objects.requireNonNull(rackId);
        this.instanceId = Objects.requireNonNull(instanceId);
        this.subscribedTopicIds = Objects.requireNonNull(subscribedTopicIds);
        this.memberAssignment = Objects.requireNonNull(memberAssignment);
    }

    public Optional<String> rackId() {
        return this.rackId;
    }

    public Optional<String> instanceId() {
        return this.instanceId;
    }

    public Set<Uuid> subscribedTopicIds() {
        return this.subscribedTopicIds;
    }

    public Map<Uuid, Set<Integer>> partitions() {
        return this.memberAssignment.partitions();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberSubscriptionAndAssignmentImpl that = (MemberSubscriptionAndAssignmentImpl)o;
        return this.rackId.equals(that.rackId) && this.instanceId.equals(that.instanceId) && this.subscribedTopicIds.equals(that.subscribedTopicIds) && this.memberAssignment.equals(that.memberAssignment);
    }

    public int hashCode() {
        int result = this.rackId.hashCode();
        result = 31 * result + this.instanceId.hashCode();
        result = 31 * result + this.subscribedTopicIds.hashCode();
        result = 31 * result + this.memberAssignment.hashCode();
        return result;
    }

    public String toString() {
        return "MemberSubscriptionAndAssignmentImpl(rackId=" + this.rackId.orElse("N/A") + ", instanceId=" + this.instanceId + ", subscribedTopicIds=" + this.subscribedTopicIds + ", memberAssignment=" + this.memberAssignment + ')';
    }
}

