/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.Maybe;

public interface TimeOrderedKeyValueBuffer<K, V, T>
extends StateStore {
    public void setSerdesIfNull(SerdeGetter var1);

    public void evictWhile(Supplier<Boolean> var1, Consumer<Eviction<K, T>> var2);

    public Maybe<ValueAndTimestamp<V>> priorValueForBuffered(K var1);

    public boolean put(long var1, Record<K, T> var3, ProcessorRecordContext var4);

    public int numRecords();

    public long bufferSize();

    public long minTimestamp();

    public static final class Eviction<K, T> {
        private final K key;
        private final T value;
        private final ProcessorRecordContext recordContext;

        Eviction(K key, T value, ProcessorRecordContext recordContext) {
            this.key = key;
            this.value = value;
            this.recordContext = recordContext;
        }

        public K key() {
            return this.key;
        }

        public T value() {
            return this.value;
        }

        public Record<K, T> record() {
            return new Record<K, T>(this.key, this.value, this.recordContext.timestamp());
        }

        public ProcessorRecordContext recordContext() {
            return this.recordContext;
        }

        public String toString() {
            return "Eviction{key=" + this.key + ", value=" + this.value + ", recordContext=" + this.recordContext + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Eviction eviction = (Eviction)o;
            return Objects.equals(this.key, eviction.key) && Objects.equals(this.value, eviction.value) && Objects.equals(this.recordContext, eviction.recordContext);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value, this.recordContext);
        }
    }
}

