/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.Set;

public interface PartitionFilter {
    public boolean isPartitionAllowed(int var1);

    public static class PartitionRangeFilter
    implements PartitionFilter {
        private final int lowerRange;
        private final int upperRange;

        public PartitionRangeFilter(int lowerRange, int upperRange) {
            this.lowerRange = lowerRange;
            this.upperRange = upperRange;
        }

        @Override
        public boolean isPartitionAllowed(int partition) {
            return partition >= this.lowerRange && partition < this.upperRange;
        }
    }

    public static class UniquePartitionFilter
    implements PartitionFilter {
        private final int partition;

        public UniquePartitionFilter(int partition) {
            this.partition = partition;
        }

        @Override
        public boolean isPartitionAllowed(int partition) {
            return partition == this.partition;
        }
    }

    public static class PartitionsSetFilter
    implements PartitionFilter {
        private final Set<Integer> partitionIds;

        public PartitionsSetFilter(Set<Integer> partitionIds) {
            this.partitionIds = partitionIds;
        }

        @Override
        public boolean isPartitionAllowed(int partition) {
            return this.partitionIds.isEmpty() || this.partitionIds.contains(partition);
        }
    }
}

