/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.CoordinatorRecord;
import org.apache.kafka.coordinator.group.CoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.GroupSpecImpl;
import org.apache.kafka.coordinator.group.modern.MemberSubscriptionAndAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.ModernGroupMember;
import org.apache.kafka.coordinator.group.modern.SubscribedTopicDescriberImpl;
import org.apache.kafka.coordinator.group.modern.TopicIds;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.image.TopicsImage;

public class TargetAssignmentBuilder<T extends ModernGroupMember> {
    private final String groupId;
    private final int groupEpoch;
    private final PartitionAssignor assignor;
    private Map<String, T> members = Collections.emptyMap();
    private Map<String, TopicMetadata> subscriptionMetadata = Collections.emptyMap();
    private SubscriptionType subscriptionType;
    private Map<String, Assignment> targetAssignment = Collections.emptyMap();
    private Map<Uuid, Map<Integer, String>> invertedTargetAssignment = Collections.emptyMap();
    private TopicsImage topicsImage = TopicsImage.EMPTY;
    private final Map<String, T> updatedMembers = new HashMap<String, T>();
    private Map<String, String> staticMembers = new HashMap<String, String>();

    public TargetAssignmentBuilder(String groupId, int groupEpoch, PartitionAssignor assignor) {
        this.groupId = Objects.requireNonNull(groupId);
        this.groupEpoch = groupEpoch;
        this.assignor = Objects.requireNonNull(assignor);
    }

    public TargetAssignmentBuilder<T> withMembers(Map<String, T> members) {
        this.members = members;
        return this;
    }

    public TargetAssignmentBuilder<T> withStaticMembers(Map<String, String> staticMembers) {
        this.staticMembers = staticMembers;
        return this;
    }

    public TargetAssignmentBuilder<T> withSubscriptionMetadata(Map<String, TopicMetadata> subscriptionMetadata) {
        this.subscriptionMetadata = subscriptionMetadata;
        return this;
    }

    public TargetAssignmentBuilder<T> withSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
        return this;
    }

    public TargetAssignmentBuilder<T> withTargetAssignment(Map<String, Assignment> targetAssignment) {
        this.targetAssignment = targetAssignment;
        return this;
    }

    public TargetAssignmentBuilder<T> withInvertedTargetAssignment(Map<Uuid, Map<Integer, String>> invertedTargetAssignment) {
        this.invertedTargetAssignment = invertedTargetAssignment;
        return this;
    }

    public TargetAssignmentBuilder<T> withTopicsImage(TopicsImage topicsImage) {
        this.topicsImage = topicsImage;
        return this;
    }

    public TargetAssignmentBuilder<T> addOrUpdateMember(String memberId, T member) {
        this.updatedMembers.put(memberId, member);
        return this;
    }

    public TargetAssignmentBuilder<T> removeMember(String memberId) {
        return this.addOrUpdateMember(memberId, null);
    }

    public TargetAssignmentResult build() throws PartitionAssignorException {
        HashMap memberSpecs = new HashMap();
        this.members.forEach((memberId, member) -> memberSpecs.put(memberId, TargetAssignmentBuilder.createMemberSubscriptionAndAssignment(member, this.targetAssignment.getOrDefault(memberId, Assignment.EMPTY), this.topicsImage)));
        this.updatedMembers.forEach((memberId, updatedMemberOrNull) -> {
            if (updatedMemberOrNull == null) {
                memberSpecs.remove(memberId);
            } else {
                String previousMemberId;
                Assignment assignment = this.targetAssignment.getOrDefault(memberId, Assignment.EMPTY);
                if (updatedMemberOrNull.instanceId() != null && (previousMemberId = this.staticMembers.get(updatedMemberOrNull.instanceId())) != null && !previousMemberId.equals(memberId)) {
                    assignment = this.targetAssignment.getOrDefault(previousMemberId, Assignment.EMPTY);
                }
                memberSpecs.put(memberId, TargetAssignmentBuilder.createMemberSubscriptionAndAssignment(updatedMemberOrNull, assignment, this.topicsImage));
            }
        });
        HashMap<Uuid, TopicMetadata> topicMetadataMap = new HashMap<Uuid, TopicMetadata>();
        this.subscriptionMetadata.forEach((topicName, topicMetadata) -> topicMetadataMap.put(topicMetadata.id(), (TopicMetadata)topicMetadata));
        GroupAssignment newGroupAssignment = this.assignor.assign((GroupSpec)new GroupSpecImpl(Collections.unmodifiableMap(memberSpecs), this.subscriptionType, this.invertedTargetAssignment), (SubscribedTopicDescriber)new SubscribedTopicDescriberImpl(topicMetadataMap));
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        for (String memberId2 : memberSpecs.keySet()) {
            Assignment oldMemberAssignment = this.targetAssignment.get(memberId2);
            Assignment newMemberAssignment = this.newMemberAssignment(newGroupAssignment, memberId2);
            if (newMemberAssignment.equals(oldMemberAssignment)) continue;
            records.add(CoordinatorRecordHelpers.newTargetAssignmentRecord(this.groupId, memberId2, newMemberAssignment.partitions()));
        }
        records.add(CoordinatorRecordHelpers.newTargetAssignmentEpochRecord(this.groupId, this.groupEpoch));
        return new TargetAssignmentResult(records, newGroupAssignment.members());
    }

    private Assignment newMemberAssignment(GroupAssignment newGroupAssignment, String memberId) {
        MemberAssignment newMemberAssignment = (MemberAssignment)newGroupAssignment.members().get(memberId);
        if (newMemberAssignment != null) {
            return new Assignment(newMemberAssignment.partitions());
        }
        return Assignment.EMPTY;
    }

    static <T extends ModernGroupMember> MemberSubscriptionAndAssignmentImpl createMemberSubscriptionAndAssignment(T member, Assignment memberAssignment, TopicsImage topicsImage) {
        return new MemberSubscriptionAndAssignmentImpl(Optional.ofNullable(member.rackId()), Optional.ofNullable(member.instanceId()), new TopicIds(member.subscribedTopicNames(), topicsImage), memberAssignment);
    }

    public static class TargetAssignmentResult {
        private final List<CoordinatorRecord> records;
        private final Map<String, MemberAssignment> targetAssignment;

        TargetAssignmentResult(List<CoordinatorRecord> records, Map<String, MemberAssignment> targetAssignment) {
            Objects.requireNonNull(records);
            Objects.requireNonNull(targetAssignment);
            this.records = records;
            this.targetAssignment = targetAssignment;
        }

        public List<CoordinatorRecord> records() {
            return this.records;
        }

        public Map<String, MemberAssignment> targetAssignment() {
            return this.targetAssignment;
        }
    }
}

