/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.KeyValueStoreWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KTableSource<KIn, VIn>
implements ProcessorSupplier<KIn, VIn, KIn, Change<VIn>> {
    private static final Logger LOG = LoggerFactory.getLogger(KTableSource.class);
    private final String storeName;
    private final StoreFactory storeFactory;
    private String queryableName;
    private boolean sendOldValues;

    public KTableSource(MaterializedInternal<KIn, VIn, KeyValueStore<Bytes, byte[]>> materialized) {
        this.storeName = materialized.storeName();
        Objects.requireNonNull(this.storeName, "storeName can't be null");
        this.queryableName = materialized.queryableStoreName();
        this.sendOldValues = false;
        this.storeFactory = new KeyValueStoreMaterializer<KIn, VIn>(materialized);
    }

    public String queryableName() {
        return this.queryableName;
    }

    @Override
    public Processor<KIn, VIn, KIn, Change<VIn>> get() {
        return new KTableSourceProcessor();
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        if (this.materialized()) {
            return Set.of(new StoreFactory.FactoryWrappingStoreBuilder(this.storeFactory));
        }
        return null;
    }

    public void enableSendingOldValues() {
        this.sendOldValues = true;
        this.queryableName = this.storeName;
    }

    public void materialize() {
        this.queryableName = this.storeName;
    }

    public boolean materialized() {
        return this.queryableName != null;
    }

    private class KTableSourceProcessor
    implements Processor<KIn, VIn, KIn, Change<VIn>> {
        private ProcessorContext<KIn, Change<VIn>> context;
        private KeyValueStoreWrapper<KIn, VIn> store;
        private TimestampedTupleForwarder<KIn, VIn> tupleForwarder;
        private Sensor droppedRecordsSensor;

        private KTableSourceProcessor() {
        }

        @Override
        public void init(ProcessorContext<KIn, Change<VIn>> context) {
            this.context = context;
            StreamsMetricsImpl metrics = (StreamsMetricsImpl)context.metrics();
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), metrics);
            if (KTableSource.this.queryableName != null) {
                this.store = new KeyValueStoreWrapper(context, KTableSource.this.queryableName);
                this.tupleForwarder = new TimestampedTupleForwarder(this.store.store(), context, new TimestampedCacheFlushListener(context), KTableSource.this.sendOldValues);
            }
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            if (record.key() == null) {
                if (this.context.recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context.recordMetadata().get();
                    LOG.warn("Skipping record due to null key. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                } else {
                    LOG.warn("Skipping record due to null key. Topic, partition, and offset not known.");
                }
                this.droppedRecordsSensor.record();
                return;
            }
            if (KTableSource.this.queryableName != null) {
                long putReturnCode;
                Object oldValue;
                ValueAndTimestamp oldValueAndTimestamp = this.store.get(record.key());
                if (oldValueAndTimestamp != null) {
                    oldValue = oldValueAndTimestamp.value();
                    if (record.timestamp() < oldValueAndTimestamp.timestamp()) {
                        if (this.context.recordMetadata().isPresent()) {
                            RecordMetadata recordMetadata = this.context.recordMetadata().get();
                            LOG.warn("Detected out-of-order KTable update for {}, old timestamp=[{}] new timestamp=[{}]. topic=[{}] partition=[{}] offset=[{}].", new Object[]{this.store.name(), oldValueAndTimestamp.timestamp(), record.timestamp(), recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                        } else {
                            LOG.warn("Detected out-of-order KTable update for {}, old timestamp=[{}] new timestamp=[{}]. Topic, partition and offset not known.", new Object[]{this.store.name(), oldValueAndTimestamp.timestamp(), record.timestamp()});
                        }
                    }
                } else {
                    oldValue = null;
                }
                if ((putReturnCode = this.store.put(record.key(), record.value(), record.timestamp())) != Long.MIN_VALUE) {
                    this.tupleForwarder.maybeForward(record.withValue(new Change<Object>(record.value(), oldValue, putReturnCode == -1L)));
                }
            } else {
                this.context.forward(record.withValue(new Change<Object>(record.value(), null, true)));
            }
        }
    }
}

