/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupRegularExpressionKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupRegularExpressionValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.LegacyOffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.LegacyOffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupStatePartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupStatePartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTopologyKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTopologyValue;

public enum CoordinatorRecordType {
    LEGACY_OFFSET_COMMIT("LegacyOffsetCommit", 0, 0, 0),
    OFFSET_COMMIT("OffsetCommit", 1, 0, 4),
    GROUP_METADATA("GroupMetadata", 2, 0, 4),
    CONSUMER_GROUP_METADATA("ConsumerGroupMetadata", 3, 0, 0),
    CONSUMER_GROUP_PARTITION_METADATA("ConsumerGroupPartitionMetadata", 4, 0, 0),
    CONSUMER_GROUP_MEMBER_METADATA("ConsumerGroupMemberMetadata", 5, 0, 0),
    CONSUMER_GROUP_TARGET_ASSIGNMENT_METADATA("ConsumerGroupTargetAssignmentMetadata", 6, 0, 0),
    CONSUMER_GROUP_TARGET_ASSIGNMENT_MEMBER("ConsumerGroupTargetAssignmentMember", 7, 0, 0),
    CONSUMER_GROUP_CURRENT_MEMBER_ASSIGNMENT("ConsumerGroupCurrentMemberAssignment", 8, 0, 0),
    SHARE_GROUP_MEMBER_METADATA("ShareGroupMemberMetadata", 10, 0, 0),
    SHARE_GROUP_METADATA("ShareGroupMetadata", 11, 0, 0),
    SHARE_GROUP_TARGET_ASSIGNMENT_METADATA("ShareGroupTargetAssignmentMetadata", 12, 0, 0),
    SHARE_GROUP_TARGET_ASSIGNMENT_MEMBER("ShareGroupTargetAssignmentMember", 13, 0, 0),
    SHARE_GROUP_CURRENT_MEMBER_ASSIGNMENT("ShareGroupCurrentMemberAssignment", 14, 0, 0),
    SHARE_GROUP_STATE_PARTITION_METADATA("ShareGroupStatePartitionMetadata", 15, 0, 0),
    CONSUMER_GROUP_REGULAR_EXPRESSION("ConsumerGroupRegularExpression", 16, 0, 0),
    STREAMS_GROUP_METADATA("StreamsGroupMetadata", 17, 0, 0),
    STREAMS_GROUP_MEMBER_METADATA("StreamsGroupMemberMetadata", 19, 0, 0),
    STREAMS_GROUP_TARGET_ASSIGNMENT_METADATA("StreamsGroupTargetAssignmentMetadata", 20, 0, 0),
    STREAMS_GROUP_TARGET_ASSIGNMENT_MEMBER("StreamsGroupTargetAssignmentMember", 21, 0, 0),
    STREAMS_GROUP_CURRENT_MEMBER_ASSIGNMENT("StreamsGroupCurrentMemberAssignment", 22, 0, 0),
    STREAMS_GROUP_TOPOLOGY("StreamsGroupTopology", 23, 0, 0);

    private final String name;
    private final short id;
    private final short lowestSupportedVersion;
    private final short highestSupportedVersion;

    private CoordinatorRecordType(String name, short id, short lowestSupportedVersion, short highestSupportedVersion) {
        this.name = name;
        this.id = id;
        this.lowestSupportedVersion = lowestSupportedVersion;
        this.highestSupportedVersion = highestSupportedVersion;
    }

    public static CoordinatorRecordType fromId(short id) {
        switch (id) {
            case 0: {
                return LEGACY_OFFSET_COMMIT;
            }
            case 1: {
                return OFFSET_COMMIT;
            }
            case 2: {
                return GROUP_METADATA;
            }
            case 3: {
                return CONSUMER_GROUP_METADATA;
            }
            case 4: {
                return CONSUMER_GROUP_PARTITION_METADATA;
            }
            case 5: {
                return CONSUMER_GROUP_MEMBER_METADATA;
            }
            case 6: {
                return CONSUMER_GROUP_TARGET_ASSIGNMENT_METADATA;
            }
            case 7: {
                return CONSUMER_GROUP_TARGET_ASSIGNMENT_MEMBER;
            }
            case 8: {
                return CONSUMER_GROUP_CURRENT_MEMBER_ASSIGNMENT;
            }
            case 10: {
                return SHARE_GROUP_MEMBER_METADATA;
            }
            case 11: {
                return SHARE_GROUP_METADATA;
            }
            case 12: {
                return SHARE_GROUP_TARGET_ASSIGNMENT_METADATA;
            }
            case 13: {
                return SHARE_GROUP_TARGET_ASSIGNMENT_MEMBER;
            }
            case 14: {
                return SHARE_GROUP_CURRENT_MEMBER_ASSIGNMENT;
            }
            case 15: {
                return SHARE_GROUP_STATE_PARTITION_METADATA;
            }
            case 16: {
                return CONSUMER_GROUP_REGULAR_EXPRESSION;
            }
            case 17: {
                return STREAMS_GROUP_METADATA;
            }
            case 19: {
                return STREAMS_GROUP_MEMBER_METADATA;
            }
            case 20: {
                return STREAMS_GROUP_TARGET_ASSIGNMENT_METADATA;
            }
            case 21: {
                return STREAMS_GROUP_TARGET_ASSIGNMENT_MEMBER;
            }
            case 22: {
                return STREAMS_GROUP_CURRENT_MEMBER_ASSIGNMENT;
            }
            case 23: {
                return STREAMS_GROUP_TOPOLOGY;
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + id);
    }

    public ApiMessage newRecordKey() {
        switch (this.id) {
            case 0: {
                return new LegacyOffsetCommitKey();
            }
            case 1: {
                return new OffsetCommitKey();
            }
            case 2: {
                return new GroupMetadataKey();
            }
            case 3: {
                return new ConsumerGroupMetadataKey();
            }
            case 4: {
                return new ConsumerGroupPartitionMetadataKey();
            }
            case 5: {
                return new ConsumerGroupMemberMetadataKey();
            }
            case 6: {
                return new ConsumerGroupTargetAssignmentMetadataKey();
            }
            case 7: {
                return new ConsumerGroupTargetAssignmentMemberKey();
            }
            case 8: {
                return new ConsumerGroupCurrentMemberAssignmentKey();
            }
            case 10: {
                return new ShareGroupMemberMetadataKey();
            }
            case 11: {
                return new ShareGroupMetadataKey();
            }
            case 12: {
                return new ShareGroupTargetAssignmentMetadataKey();
            }
            case 13: {
                return new ShareGroupTargetAssignmentMemberKey();
            }
            case 14: {
                return new ShareGroupCurrentMemberAssignmentKey();
            }
            case 15: {
                return new ShareGroupStatePartitionMetadataKey();
            }
            case 16: {
                return new ConsumerGroupRegularExpressionKey();
            }
            case 17: {
                return new StreamsGroupMetadataKey();
            }
            case 19: {
                return new StreamsGroupMemberMetadataKey();
            }
            case 20: {
                return new StreamsGroupTargetAssignmentMetadataKey();
            }
            case 21: {
                return new StreamsGroupTargetAssignmentMemberKey();
            }
            case 22: {
                return new StreamsGroupCurrentMemberAssignmentKey();
            }
            case 23: {
                return new StreamsGroupTopologyKey();
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + this.id);
    }

    public ApiMessage newRecordValue() {
        switch (this.id) {
            case 0: {
                return new LegacyOffsetCommitValue();
            }
            case 1: {
                return new OffsetCommitValue();
            }
            case 2: {
                return new GroupMetadataValue();
            }
            case 3: {
                return new ConsumerGroupMetadataValue();
            }
            case 4: {
                return new ConsumerGroupPartitionMetadataValue();
            }
            case 5: {
                return new ConsumerGroupMemberMetadataValue();
            }
            case 6: {
                return new ConsumerGroupTargetAssignmentMetadataValue();
            }
            case 7: {
                return new ConsumerGroupTargetAssignmentMemberValue();
            }
            case 8: {
                return new ConsumerGroupCurrentMemberAssignmentValue();
            }
            case 10: {
                return new ShareGroupMemberMetadataValue();
            }
            case 11: {
                return new ShareGroupMetadataValue();
            }
            case 12: {
                return new ShareGroupTargetAssignmentMetadataValue();
            }
            case 13: {
                return new ShareGroupTargetAssignmentMemberValue();
            }
            case 14: {
                return new ShareGroupCurrentMemberAssignmentValue();
            }
            case 15: {
                return new ShareGroupStatePartitionMetadataValue();
            }
            case 16: {
                return new ConsumerGroupRegularExpressionValue();
            }
            case 17: {
                return new StreamsGroupMetadataValue();
            }
            case 19: {
                return new StreamsGroupMemberMetadataValue();
            }
            case 20: {
                return new StreamsGroupTargetAssignmentMetadataValue();
            }
            case 21: {
                return new StreamsGroupTargetAssignmentMemberValue();
            }
            case 22: {
                return new StreamsGroupCurrentMemberAssignmentValue();
            }
            case 23: {
                return new StreamsGroupTopologyValue();
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + this.id);
    }

    public short id() {
        return this.id;
    }

    public short lowestSupportedVersion() {
        return this.lowestSupportedVersion;
    }

    public short highestSupportedVersion() {
        return this.highestSupportedVersion;
    }

    public String toString() {
        return this.name();
    }
}

