/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.info.ServerInfo;
import org.apache.karaf.main.BundleInfo;
import org.apache.karaf.main.ConfigProperties;
import org.apache.karaf.main.InstanceHelper;
import org.apache.karaf.main.KarafActivatorManager;
import org.apache.karaf.main.PropertiesLoader;
import org.apache.karaf.main.ServerInfoImpl;
import org.apache.karaf.main.ShutdownCallback;
import org.apache.karaf.main.StartupListener;
import org.apache.karaf.main.lock.Lock;
import org.apache.karaf.main.lock.LockCallBack;
import org.apache.karaf.main.lock.NoLock;
import org.apache.karaf.main.util.ArtifactResolver;
import org.apache.karaf.main.util.BootstrapLogManager;
import org.apache.karaf.main.util.SimpleMavenResolver;
import org.apache.karaf.main.util.StringMap;
import org.apache.karaf.main.util.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public class Main {
    public static final String STARTUP_PROPERTIES_FILE_NAME = "startup.properties";
    Logger LOG = Logger.getLogger(this.getClass().getName());
    private ConfigProperties config;
    private Framework framework = null;
    private final String[] args;
    private int exitCode;
    private ShutdownCallback shutdownCallback;
    private KarafActivatorManager activatorManager;
    private Lock lock;
    private KarafLockCallback lockCallback;
    private boolean exiting;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        while (true) {
            boolean restart = false;
            System.setProperty("karaf.restart", "false");
            Main main = new Main(args);
            try {
                main.launch();
            }
            catch (Throwable ex) {
                System.err.println(ex.getMessage());
                main.LOG.log(Level.SEVERE, "Could not launch framework", ex);
                main.destroy();
                main.setExitCode(-1);
            }
            try {
                main.awaitShutdown();
                boolean stopped = main.destroy();
                restart = Boolean.getBoolean("karaf.restart");
                main.updateInstancePidAfterShutdown();
                if (stopped) continue;
                if (restart) {
                    System.err.println("Timeout waiting for framework to stop.  Restarting now.");
                    continue;
                }
                System.err.println("Timeout waiting for framework to stop.  Exiting VM.");
                main.setExitCode(-3);
                continue;
            }
            catch (Throwable ex) {
                main.setExitCode(-2);
                System.err.println("Error occurred shutting down framework: " + ex);
                ex.printStackTrace();
                continue;
            }
            finally {
                if (!restart) {
                    System.exit(main.getExitCode());
                    continue;
                }
                System.gc();
                continue;
            }
            break;
        }
    }

    public Main(String[] args) {
        this.args = args;
    }

    public void setShutdownCallback(ShutdownCallback shutdownCallback) {
        this.shutdownCallback = shutdownCallback;
    }

    public void updateInstancePidAfterShutdown() throws Exception {
        if (this.config == null) {
            this.config = new ConfigProperties();
        }
        InstanceHelper.updateInstancePid(this.config.karafHome, this.config.karafBase, false);
    }

    public void launch() throws Exception {
        this.config = new ConfigProperties();
        if (this.config.delayConsoleStart) {
            System.out.println(this.config.startupMessage);
        }
        String log4jConfigPath = System.getProperty("karaf.etc") + "/org.ops4j.pax.logging.cfg";
        BootstrapLogManager.setProperties(this.config.props, log4jConfigPath);
        this.lockCallback = new KarafLockCallback();
        InstanceHelper.updateInstancePid(this.config.karafHome, this.config.karafBase, true);
        this.LOG.addHandler(BootstrapLogManager.getDefaultHandler());
        for (String provider : this.config.securityProviders) {
            Main.addSecurityProvider(provider);
        }
        List<File> bundleDirs = this.getBundleRepos();
        SimpleMavenResolver resolver = new SimpleMavenResolver(bundleDirs);
        ClassLoader classLoader = this.createClassLoader(resolver);
        FrameworkFactory factory = this.loadFrameworkFactory(classLoader);
        this.framework = factory.newFramework((Map)new StringMap(this.config.props, false));
        this.framework.init();
        this.framework.getBundleContext().addFrameworkListener((FrameworkListener)this.lockCallback);
        this.framework.start();
        FrameworkStartLevel sl = (FrameworkStartLevel)this.framework.adapt(FrameworkStartLevel.class);
        sl.setInitialBundleStartLevel(this.config.defaultBundleStartlevel);
        if (this.framework.getBundleContext().getBundles().length == 1) {
            this.LOG.info("Installing and starting initial bundles");
            File startupPropsFile = new File(this.config.karafEtc, STARTUP_PROPERTIES_FILE_NAME);
            List<BundleInfo> bundles = this.readBundlesFromStartupProperties(startupPropsFile);
            this.installAndStartBundles(resolver, this.framework.getBundleContext(), bundles);
            this.LOG.info("All initial bundles installed and set to start");
        }
        ServerInfoImpl serverInfo = new ServerInfoImpl(this.args, this.config);
        this.framework.getBundleContext().registerService(ServerInfo.class, (Object)serverInfo, null);
        this.activatorManager = new KarafActivatorManager(classLoader, this.framework);
        this.activatorManager.startKarafActivators();
        this.setStartLevel(this.config.lockStartLevel);
        if (this.config.delayConsoleStart) {
            new StartupListener(this.LOG, this.framework.getBundleContext());
        }
        this.monitor();
    }

    private void monitor() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Main.this.doMonitor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private void doMonitor() throws Exception {
        this.lock = this.createLock();
        File dataDir = new File(System.getProperty("karaf.data"));
        while (!this.exiting) {
            if (this.lock.lock()) {
                this.lockCallback.lockAquired();
                while (true) {
                    if (!dataDir.isDirectory()) {
                        this.LOG.info("Data directory does not exist anymore, halting");
                        this.framework.stop();
                        System.exit(-1);
                        return;
                    }
                    if (!this.lock.isAlive() || this.exiting) break;
                    Thread.sleep(this.config.lockDelay);
                }
                if (!this.exiting) {
                    this.lockCallback.lockLost();
                }
            } else if (this.config.lockSlaveBlock) {
                this.LOG.log(Level.SEVERE, "Can't lock, and lock is exclusive");
                System.err.println("Can't lock (another instance is running), and lock is exclusive");
                System.exit(5);
            } else {
                this.lockCallback.waitingForLock();
            }
            Thread.sleep(this.config.lockDelay);
        }
    }

    Lock getLock() {
        return this.lock;
    }

    private ClassLoader createClassLoader(ArtifactResolver resolver) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(resolver.resolve(this.config.frameworkBundle).toURL());
        File[] libs = new File(this.config.karafHome, "lib").listFiles();
        if (libs != null) {
            for (File f : libs) {
                if (!f.isFile() || !f.canRead() || !f.getName().endsWith(".jar")) continue;
                urls.add(f.toURI().toURL());
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Main.class.getClassLoader());
    }

    private FrameworkFactory loadFrameworkFactory(ClassLoader classLoader) throws Exception {
        String factoryClass = this.config.frameworkFactoryClass;
        if (factoryClass == null) {
            InputStream is = classLoader.getResourceAsStream("META-INF/services/" + FrameworkFactory.class.getName());
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            factoryClass = br.readLine();
            br.close();
        }
        FrameworkFactory factory = (FrameworkFactory)classLoader.loadClass(factoryClass).newInstance();
        return factory;
    }

    private Lock createLock() {
        if (!this.config.useLock) {
            return new NoLock();
        }
        try {
            return (Lock)Lock.class.getClassLoader().loadClass(this.config.lockClass).getConstructor(Properties.class).newInstance(this.config.props);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                throw new RuntimeException("Exception instantiating lock class " + this.config.lockClass + "\n" + ((InvocationTargetException)e).getTargetException().getMessage(), e);
            }
            throw new RuntimeException("Exception instantiating lock class " + this.config.lockClass, e);
        }
    }

    private static void addSecurityProvider(String provider) {
        try {
            Security.addProvider((Provider)Class.forName(provider).newInstance());
        }
        catch (Throwable t) {
            System.err.println("Unable to register security provider: " + t);
        }
    }

    public List<BundleInfo> readBundlesFromStartupProperties(File startupPropsFile) {
        Properties startupProps = PropertiesLoader.loadPropertiesOrFail(startupPropsFile);
        ArrayList<BundleInfo> bundeList = new ArrayList<BundleInfo>();
        for (String key : startupProps.keySet()) {
            try {
                BundleInfo bi = new BundleInfo();
                bi.uri = new URI(key);
                String startlevelSt = startupProps.getProperty(key).trim();
                bi.startLevel = new Integer(startlevelSt);
                bundeList.add(bi);
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading startup bundle list from " + startupPropsFile + " at " + key, e);
            }
        }
        return bundeList;
    }

    private void installAndStartBundles(ArtifactResolver resolver, BundleContext context, List<BundleInfo> bundles) {
        for (BundleInfo bundleInfo : bundles) {
            try {
                Bundle b;
                if (bundleInfo.uri.toString().startsWith("reference:file:")) {
                    URI temp = URI.create(bundleInfo.uri.toString().substring("reference:file:".length()));
                    URI resolvedURI = resolver.resolve(temp);
                    URI finalUri = URI.create("reference:file:" + this.config.karafBase.toURI().relativize(resolvedURI));
                    b = context.installBundle(finalUri.toString());
                } else {
                    URI resolvedURI = resolver.resolve(bundleInfo.uri);
                    b = context.installBundle(bundleInfo.uri.toString(), resolvedURI.toURL().openStream());
                }
                ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(bundleInfo.startLevel.intValue());
                if (!this.isNotFragment(b)) continue;
                b.start();
            }
            catch (Exception e) {
                throw new RuntimeException("Error installing bundle listed in startup.properties with url: " + bundleInfo.uri + " and startlevel: " + bundleInfo.startLevel, e);
            }
        }
    }

    private boolean isNotFragment(Bundle b) {
        String fragmentHostHeader = (String)b.getHeaders().get("Fragment-Host");
        return fragmentHostHeader == null || fragmentHostHeader.trim().length() == 0;
    }

    private List<File> getBundleRepos() {
        StringTokenizer st;
        ArrayList<File> bundleDirs = new ArrayList<File>();
        File baseSystemRepo = new File(this.config.karafHome, this.config.defaultRepo);
        if (!baseSystemRepo.exists() && baseSystemRepo.isDirectory()) {
            throw new RuntimeException("system repo folder not found: " + baseSystemRepo.getAbsolutePath());
        }
        bundleDirs.add(baseSystemRepo);
        File homeSystemRepo = new File(this.config.karafHome, this.config.defaultRepo);
        bundleDirs.add(homeSystemRepo);
        String locations = this.config.bundleLocations;
        if (locations != null && (st = new StringTokenizer(locations, "\" ", true)).countTokens() > 0) {
            String location;
            do {
                if ((location = Utils.nextLocation(st)) == null) continue;
                File f = this.config.karafBase.equals(this.config.karafHome) ? new File(this.config.karafHome, location) : new File(this.config.karafBase, location);
                if (f.exists() && f.isDirectory()) {
                    bundleDirs.add(f);
                    continue;
                }
                System.err.println("Bundle location " + location + " does not exist or is not a directory.");
            } while (location != null);
        }
        return bundleDirs;
    }

    public String[] getArgs() {
        return this.args;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public Framework getFramework() {
        return this.framework;
    }

    protected void setStartLevel(int level) {
        ((FrameworkStartLevel)this.framework.adapt(FrameworkStartLevel.class)).setStartLevel(level, new FrameworkListener[0]);
    }

    public void awaitShutdown() throws Exception {
        FrameworkEvent event;
        if (this.framework == null) {
            return;
        }
        while ((event = this.framework.waitForStop(0L)).getType() == 128) {
            if (this.lock != null) {
                this.lock.release();
            }
            while (this.framework.getState() != 8 && this.framework.getState() != 32) {
                Thread.sleep(10L);
            }
            this.monitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() throws Exception {
        if (this.framework == null) {
            return true;
        }
        try {
            int step = 5000;
            if (this.shutdownCallback != null) {
                this.shutdownCallback.waitingForShutdown(step);
            }
            this.exiting = true;
            if (this.framework.getState() == 32 || this.framework.getState() == 8) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Main.this.framework.stop();
                        }
                        catch (BundleException e) {
                            System.err.println("Error stopping karaf: " + e.getMessage());
                        }
                    }
                }.start();
            }
            int timeout = this.config.shutdownTimeout;
            if (this.config.shutdownTimeout <= 0) {
                timeout = Integer.MAX_VALUE;
            }
            while (timeout > 0) {
                FrameworkEvent event;
                timeout -= step;
                if (this.shutdownCallback != null) {
                    this.shutdownCallback.waitingForShutdown(step * 2);
                }
                if ((event = this.framework.waitForStop((long)step)).getType() == 512) continue;
                this.activatorManager.stopKarafActivators();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.lock != null) {
                this.exiting = true;
                this.lock.release();
            }
        }
    }

    private final class KarafLockCallback
    implements LockCallBack,
    FrameworkListener {
        private Object startLevelLock = new Object();

        private KarafLockCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lockLost() {
            if (Main.this.framework.getState() == 32) {
                Main.this.LOG.warning("Lock lost. Setting startlevel to " + ((Main)Main.this).config.lockStartLevel);
                Object object = this.startLevelLock;
                synchronized (object) {
                    Main.this.setStartLevel(((Main)Main.this).config.lockStartLevel);
                    Main.this.LOG.fine("Waiting for start level change to complete...");
                    try {
                        this.startLevelLock.wait(((Main)Main.this).config.shutdownTimeout);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void lockAquired() {
            Main.this.LOG.info("Lock acquired. Setting startlevel to " + ((Main)Main.this).config.defaultStartLevel);
            InstanceHelper.setupShutdown(Main.this.config, Main.this.framework);
            Main.this.setStartLevel(((Main)Main.this).config.defaultStartLevel);
        }

        @Override
        public void waitingForLock() {
            Main.this.LOG.fine("Waiting for the lock ...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void frameworkEvent(FrameworkEvent event) {
            if (event.getType() == 8) {
                Object object = this.startLevelLock;
                synchronized (object) {
                    Main.this.LOG.fine("Start level change complete.");
                    this.startLevelLock.notifyAll();
                }
            }
        }
    }
}

