/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.karaf.shell.support.table;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

public class ShellTableTest {

    @Test
    public void testLongValueFull() {
        ShellTable table = new ShellTable();
        table.separator("|");
        table.column("col1");
        table.column("col2").maxSize(-1);
        table.addRow().addContent("my first column value", "my second column value is quite long");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        table.print(new PrintStream(baos), false);
        assertEquals(String.format("%s%n","my first column value|my second column value is quite long"), baos.toString());
    }

    @Test
    public void testLongValueCut() {
        ShellTable table = new ShellTable();
        table.separator("|");
        table.column("col1");
        table.column("col2").maxSize(-1);
        table.addRow().addContent("my first column value", "my second column value is quite long");
        table.size(50);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        table.print(new PrintStream(baos), false);
        assertEquals(String.format("%s%n","my first column value|my second column value is q"), baos.toString());
    }

    @Test
    public void testLongValueMultiline() {
        ShellTable table = new ShellTable();
        table.separator("|");
        table.column("col1");
        table.column("col2").maxSize(-1).wrap();
        table.addRow().addContent("my first column value", "my second column value is quite long");
        table.size(50);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        table.print(new PrintStream(baos), false);
        assertEquals(String.format("%1$s\n%2$s%n","my first column value|my second column value is",
                "                     |quite long"), baos.toString());
    }

}
