/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.mina;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Set;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.mina.MinaService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaAcceptor
extends MinaService
implements IoAcceptor,
org.apache.mina.core.service.IoHandler {
    protected volatile org.apache.mina.core.service.IoAcceptor acceptor;
    protected int backlog = 0;
    protected boolean reuseAddress = true;

    public MinaAcceptor(FactoryManager manager, IoHandler handler, IoProcessor<NioSession> ioProcessor) {
        super(manager, handler, ioProcessor);
        String valStr = manager.getProperties().get("socket-backlog");
        if (valStr != null) {
            this.backlog = Integer.parseInt(valStr);
        }
        if ((valStr = manager.getProperties().get("socket-reuseaddr")) != null) {
            this.reuseAddress = Boolean.parseBoolean(valStr);
        }
    }

    protected org.apache.mina.core.service.IoAcceptor createAcceptor() {
        NioSocketAcceptor acceptor = new NioSocketAcceptor(this.ioProcessor);
        acceptor.setCloseOnDeactivation(false);
        acceptor.setReuseAddress(this.reuseAddress);
        acceptor.setBacklog(this.backlog);
        this.configure(acceptor.getSessionConfig());
        return acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.apache.mina.core.service.IoAcceptor getAcceptor() {
        if (this.acceptor == null) {
            MinaAcceptor minaAcceptor = this;
            synchronized (minaAcceptor) {
                if (this.acceptor == null) {
                    this.acceptor = this.createAcceptor();
                    this.acceptor.setHandler((org.apache.mina.core.service.IoHandler)this);
                }
            }
        }
        return this.acceptor;
    }

    @Override
    protected IoService getIoService() {
        return this.getAcceptor();
    }

    @Override
    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        this.getAcceptor().bind(addresses);
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        this.getAcceptor().bind(address);
    }

    @Override
    public void unbind() {
        this.getAcceptor().unbind();
    }

    @Override
    public void unbind(Collection<? extends SocketAddress> addresses) {
        this.getAcceptor().unbind(addresses);
    }

    @Override
    public void unbind(SocketAddress address) {
        this.getAcceptor().unbind(address);
    }

    @Override
    public Set<SocketAddress> getBoundAddresses() {
        return this.getAcceptor().getLocalAddresses();
    }
}

