/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizingComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(NormalizingComparator.class);
    private Normalizer normalizer;
    private LdapComparator<String> comparator;
    private boolean onServer = false;

    public NormalizingComparator(String oid, Normalizer normalizer, LdapComparator<String> comparator) {
        super(oid);
        this.normalizer = normalizer;
        this.comparator = comparator;
    }

    @Override
    public int compare(String o1, String o2) {
        String n2;
        String n1;
        if (this.onServer) {
            return this.comparator.compare(o1, o2);
        }
        try {
            n1 = this.normalizer.normalize(o1);
        }
        catch (LdapException e) {
            LOG.warn("Failed to normalize: " + o1, e);
            n1 = o1;
        }
        try {
            n2 = this.normalizer.normalize(o2);
        }
        catch (LdapException e) {
            LOG.warn("Failed to normalize: " + o2, e);
            n2 = o2;
        }
        return this.comparator.compare(n1, n2);
    }

    @Override
    public void setOid(String oid) {
        super.setOid(oid);
        this.normalizer.setOid(oid);
        this.comparator.setOid(oid);
    }

    public void setOnServer() {
        this.onServer = true;
    }
}

