/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.subtree;

import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecification;
import org.apache.directory.server.core.api.event.Evaluator;
import org.apache.directory.server.core.api.event.ExpressionEvaluator;

public class SubtreeEvaluator {
    private final Evaluator evaluator;

    public SubtreeEvaluator(SchemaManager schemaManager) {
        this.evaluator = new ExpressionEvaluator(schemaManager);
    }

    public boolean evaluate(SubtreeSpecification subtree, Dn apDn, Dn entryDn, Entry entry) throws LdapException {
        Dn subentryBaseDn = apDn;
        if (!entryDn.isDescendantOf(subentryBaseDn = subentryBaseDn.add(subtree.getBase()))) {
            return false;
        }
        int entryRelativeDnSize = entryDn.size() - subentryBaseDn.size();
        if (subtree.getMaxBaseDistance() != -1 && entryRelativeDnSize > subtree.getMaxBaseDistance()) {
            return false;
        }
        if (subtree.getMinBaseDistance() > 0 && entryRelativeDnSize < subtree.getMinBaseDistance()) {
            return false;
        }
        if (subtree.getChopBeforeExclusions().size() != 0 || subtree.getChopAfterExclusions().size() != 0) {
            Dn entryRelativeDn = entryDn.getDescendantOf(apDn).getDescendantOf(subtree.getBase());
            for (Dn chopBeforeDn : subtree.getChopBeforeExclusions()) {
                if (!entryRelativeDn.isDescendantOf(chopBeforeDn)) continue;
                return false;
            }
            for (Dn chopAfterDn : subtree.getChopAfterExclusions()) {
                if (!entryRelativeDn.isDescendantOf(chopAfterDn) || chopAfterDn.equals(entryRelativeDn)) continue;
                return false;
            }
        }
        if (subtree.getRefinement() != null) {
            return this.evaluator.evaluate(subtree.getRefinement(), entryDn, entry);
        }
        return true;
    }
}

