/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.security.EncryptionResult;

public class ConfigurableEncryptor {
    private static final GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    private static final int ITERATION_COUNT = 65536;
    private static final int KEY_LENGTH = 128;
    private char[] passPhrase = null;
    private String alg = "AES";
    private String pbeAlg = "PBKDF2WithHmacSHA1";
    private String transformation = "AES/CBC/PKCS5Padding";
    private int saltSize = 8;
    private int iterationCount = 65536;
    private int keyLength = 128;

    public ConfigurableEncryptor(String passPhrase) {
        this.passPhrase = passPhrase.toCharArray();
    }

    public void init(GatewayConfig config) {
        if (config != null) {
            String keyLength;
            String iterationCount;
            String saltSize;
            String transformation;
            String pbeAlg;
            String alg = config.getAlgorithm();
            if (alg != null) {
                this.alg = alg;
            }
            if ((pbeAlg = config.getPBEAlgorithm()) != null) {
                this.pbeAlg = pbeAlg;
            }
            if ((transformation = config.getTransformation()) != null) {
                this.transformation = transformation;
            }
            if ((saltSize = config.getSaltSize()) != null) {
                this.saltSize = Integer.parseInt(saltSize);
            }
            if ((iterationCount = config.getIterationCount()) != null) {
                this.iterationCount = Integer.parseInt(iterationCount);
            }
            if ((keyLength = config.getKeyLength()) != null) {
                this.keyLength = Integer.parseInt(keyLength);
            }
        }
    }

    public SecretKey getKeyFromPassword(String passPhrase, byte[] salt) {
        SecretKey key = null;
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.pbeAlg);
            PBEKeySpec spec = new PBEKeySpec(passPhrase.toCharArray(), salt, this.iterationCount, this.keyLength);
            key = factory.generateSecret(spec);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.failedToGenerateKeyFromPassword(e);
        }
        catch (InvalidKeySpecException e) {
            LOG.failedToGenerateKeyFromPassword(e);
        }
        return key;
    }

    public EncryptionResult encrypt(String encrypt) throws Exception {
        byte[] bytes = encrypt.getBytes(StandardCharsets.UTF_8);
        return this.encrypt(bytes);
    }

    public EncryptionResult encrypt(byte[] plain) throws Exception {
        byte[] salt = new byte[this.saltSize];
        SecureRandom rnd = new SecureRandom();
        rnd.nextBytes(salt);
        SecretKey tmp = this.getKeyFromPassword(new String(this.passPhrase), salt);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), this.alg);
        Cipher ecipher = Cipher.getInstance(this.transformation);
        ecipher.init(1, secret);
        EncryptionResult atom = new EncryptionResult(salt, ecipher.getParameters().getParameterSpec(IvParameterSpec.class).getIV(), ecipher.doFinal(plain));
        return atom;
    }

    public byte[] decrypt(byte[] salt, byte[] iv, byte[] encrypt) throws Exception {
        SecretKey tmp = this.getKeyFromPassword(new String(this.passPhrase), salt);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), this.alg);
        Cipher dcipher = Cipher.getInstance(this.transformation);
        dcipher.init(2, (Key)secret, new IvParameterSpec(iv));
        return dcipher.doFinal(encrypt);
    }
}

