/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import java.util.List;
import java.util.Map;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.core.client.Client;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;

public class Saml2ClientBuilder
extends AbstractBuilder {
    public Saml2ClientBuilder(Map<String, String> properties) {
        super(properties);
    }

    public void tryCreateSaml2Client(List<Client> clients) {
        for (int i = 0; i <= 10; ++i) {
            String keystorePassword = this.getProperty("saml.keystorePassword", i);
            String privateKeyPassword = this.getProperty("saml.privateKeyPassword", i);
            String keystorePath = this.getProperty("saml.keystorePath", i);
            String identityProviderMetadataPath = this.getProperty("saml.identityProviderMetadataPath", i);
            if (!CommonHelper.isNotBlank((String)keystorePassword) || !CommonHelper.isNotBlank((String)privateKeyPassword) || !CommonHelper.isNotBlank((String)keystorePath) || !CommonHelper.isNotBlank((String)identityProviderMetadataPath)) continue;
            String maximumAuthenticationLifetime = this.getProperty("saml.maximumAuthenticationLifetime", i);
            String serviceProviderEntityId = this.getProperty("saml.serviceProviderEntityId", i);
            String serviceProviderMetadataPath = this.getProperty("saml.serviceProviderMetadataPath", i);
            String destinationBindingType = this.getProperty("saml.destinationBindingType", i);
            String keystoreAlias = this.getProperty("saml.keystoreAlias", i);
            SAML2Configuration cfg = new SAML2Configuration(keystorePath, keystorePassword, privateKeyPassword, identityProviderMetadataPath);
            if (CommonHelper.isNotBlank((String)maximumAuthenticationLifetime)) {
                cfg.setMaximumAuthenticationLifetime(Integer.parseInt(maximumAuthenticationLifetime));
            }
            if (CommonHelper.isNotBlank((String)serviceProviderEntityId)) {
                cfg.setServiceProviderEntityId(serviceProviderEntityId);
            }
            if (CommonHelper.isNotBlank((String)serviceProviderMetadataPath)) {
                cfg.setServiceProviderMetadataPath(serviceProviderMetadataPath);
            }
            if (CommonHelper.isNotBlank((String)destinationBindingType)) {
                cfg.setDestinationBindingType(destinationBindingType);
            }
            if (CommonHelper.isNotBlank((String)keystoreAlias)) {
                cfg.setKeystoreAlias(keystoreAlias);
            }
            SAML2Client saml2Client = new SAML2Client(cfg);
            saml2Client.setName(this.concat(saml2Client.getName(), i));
            clients.add((Client)saml2Client);
        }
    }
}

