/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.BatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourceAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.DynamicSQLBatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.ParameterizedSQLBatchWritingMechanism;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.LOBValueWriter;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.helper.ThreadCursoredList;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ArrayRecord;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Login;

public class DatabaseAccessor
extends DatasourceAccessor {
    public static boolean shouldUseDynamicStatements = true;
    protected Map<String, Statement> statementCache;
    protected DatabaseMetaData metaData;
    protected BatchWritingMechanism activeBatchWritingMechanism;
    protected DynamicSQLBatchWritingMechanism dynamicSQLMechanism;
    protected ParameterizedSQLBatchWritingMechanism parameterizedMechanism;
    protected LOBValueWriter lobWriter = null;
    protected Statement dynamicStatement;
    protected boolean isDynamicStatementInUse = false;

    public DatabaseAccessor() {
    }

    public DatabaseAccessor(Object connection) {
        this();
        this.datasourceConnection = connection;
    }

    protected DynamicSQLBatchWritingMechanism getDynamicSQLMechanism() {
        if (this.dynamicSQLMechanism == null) {
            this.dynamicSQLMechanism = new DynamicSQLBatchWritingMechanism(this);
        }
        return this.dynamicSQLMechanism;
    }

    protected ParameterizedSQLBatchWritingMechanism getParameterizedMechanism() {
        if (this.parameterizedMechanism == null) {
            this.parameterizedMechanism = new ParameterizedSQLBatchWritingMechanism(this);
        }
        return this.parameterizedMechanism;
    }

    @Override
    public void flushSelectCalls(AbstractSession session) {
        if (this.lobWriter != null) {
            this.lobWriter.buildAndExecuteSelectCalls(session);
        }
    }

    public LOBValueWriter getLOBWriter() {
        if (this.lobWriter == null) {
            this.lobWriter = new LOBValueWriter(this);
        }
        return this.lobWriter;
    }

    public synchronized Statement allocateDynamicStatement(Connection connection) throws SQLException {
        if (this.dynamicStatement == null) {
            this.dynamicStatement = connection.createStatement();
        }
        if (this.isDynamicStatementInUse()) {
            return connection.createStatement();
        }
        this.setIsDynamicStatementInUse(true);
        return this.dynamicStatement;
    }

    public boolean isDynamicStatementInUse() {
        return this.isDynamicStatementInUse;
    }

    @Override
    public void setDatasourcePlatform(DatasourcePlatform platform) {
        super.setDatasourcePlatform(platform);
        this.lobWriter = null;
    }

    public synchronized void setIsDynamicStatementInUse(boolean isDynamicStatementInUse) {
        this.isDynamicStatementInUse = isDynamicStatementInUse;
    }

    @Override
    public void basicBeginTransaction(AbstractSession session) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().setAutoCommit(false);
            } else {
                this.getPlatform().beginTransaction(this);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    @Override
    protected void buildConnectLog(AbstractSession session) {
        try {
            if (session.shouldLog(4, "connection")) {
                DatabaseMetaData metaData = this.getConnectionMetaData();
                Object[] args = new Object[]{metaData.getURL(), metaData.getUserName(), metaData.getDatabaseProductName(), metaData.getDatabaseProductVersion(), metaData.getDriverName(), metaData.getDriverVersion(), String.valueOf(Helper.cr()) + "\t"};
                session.log(4, "connection", "connected_user_database_driver", args, this);
            }
        }
        catch (Exception exception) {
            session.warning("JDBC_driver_does_not_support_meta_data", "connection");
        }
    }

    public AbstractRecord buildOutputRow(CallableStatement statement, DatabaseCall call, AbstractSession session) throws DatabaseException {
        try {
            return call.buildOutputRow(statement, this, session);
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    public Vector buildSortedFields(Vector fields, ResultSet resultSet, AbstractSession session) throws DatabaseException {
        Vector sortedFields;
        try {
            Vector columnNames = this.getColumnNames(resultSet, session);
            sortedFields = fields == null ? columnNames : this.sortFields(fields, columnNames);
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
        return sortedFields;
    }

    @Override
    protected void connectInternal(Login login, AbstractSession session) throws DatabaseException {
        super.connectInternal(login, session);
        this.checkTransactionIsolation(session);
        try {
            session.getPlatform().initializeConnectionData(this.getConnection());
        }
        catch (SQLException sqlEx) {
            DatabaseException commException = this.processExceptionForCommError(session, sqlEx, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(sqlEx, this, session, false);
        }
    }

    protected void checkTransactionIsolation(AbstractSession session) throws DatabaseException {
        if (!this.isInTransaction && this.login != null && ((DatabaseLogin)this.login).getTransactionIsolation() != -1) {
            try {
                this.getConnection().setTransactionIsolation(((DatabaseLogin)this.login).getTransactionIsolation());
            }
            catch (SQLException sqlEx) {
                DatabaseException commException = this.processExceptionForCommError(session, sqlEx, null);
                if (commException != null) {
                    throw commException;
                }
                throw DatabaseException.sqlException(sqlEx, this, session, false);
            }
        }
    }

    public void clearStatementCache(AbstractSession session) {
        if (this.hasStatementCache()) {
            for (Statement statement : this.getStatementCache().values()) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.statementCache = null;
        }
        if (this.dynamicStatement != null) {
            try {
                this.dynamicStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.dynamicStatement = null;
            this.setIsDynamicStatementInUse(false);
        }
    }

    @Override
    public Object clone() {
        DatabaseAccessor accessor = (DatabaseAccessor)super.clone();
        accessor.dynamicSQLMechanism = null;
        if (this.activeBatchWritingMechanism != null) {
            accessor.activeBatchWritingMechanism = this.activeBatchWritingMechanism.clone();
        }
        accessor.parameterizedMechanism = null;
        accessor.statementCache = null;
        return accessor;
    }

    public void closeCursor(ResultSet resultSet, AbstractSession session) throws DatabaseException {
        try {
            resultSet.close();
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    public void closeStatement(Statement statement, AbstractSession session, DatabaseCall call) throws SQLException {
        if (statement == null) {
            this.decrementCallCount();
            return;
        }
        DatabaseQuery query = call == null ? null : call.getQuery();
        try {
            session.startOperationProfile("Timer:StatementExecute", query, Integer.MAX_VALUE);
            statement.close();
        }
        finally {
            session.endOperationProfile("Timer:StatementExecute", query, Integer.MAX_VALUE);
            this.decrementCallCount();
            if (statement == this.dynamicStatement) {
                this.dynamicStatement = null;
                this.setIsDynamicStatementInUse(false);
            }
        }
    }

    @Override
    public void commitTransaction(AbstractSession session) throws DatabaseException {
        this.writesCompleted(session);
        super.commitTransaction(session);
    }

    @Override
    public void basicCommitTransaction(AbstractSession session) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().commit();
                this.getConnection().setAutoCommit(true);
            } else {
                this.getPlatform().commitTransaction(this);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    public AbstractRecord cursorRetrieveNextRow(Vector fields, ResultSet resultSet, AbstractSession session) throws DatabaseException {
        try {
            if (resultSet.next()) {
                return this.fetchRow(fields, resultSet, resultSet.getMetaData(), session);
            }
            return null;
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    public AbstractRecord cursorRetrievePreviousRow(Vector fields, ResultSet resultSet, AbstractSession session) throws DatabaseException {
        try {
            if (resultSet.previous()) {
                return this.fetchRow(fields, resultSet, resultSet.getMetaData(), session);
            }
            return null;
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    @Override
    public void closeDatasourceConnection() throws DatabaseException {
        try {
            this.getConnection().close();
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, null, false);
        }
    }

    @Override
    public void disconnect(AbstractSession session) throws DatabaseException {
        this.clearStatementCache(session);
        super.disconnect(session);
    }

    @Override
    public void closeConnection() {
        this.clearStatementCache(null);
        super.closeConnection();
    }

    protected void executeBatchedStatement(PreparedStatement statement, AbstractSession session) throws DatabaseException {
        try {
            this.executeDirectNoSelect(statement, null, session);
        }
        catch (RuntimeException exception) {
            try {
                this.closeStatement(statement, session, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw exception;
        }
        try {
            this.closeStatement(statement, session, null);
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    @Override
    public Object executeCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        return this.basicExecuteCall(call, translationRow, session, true);
    }

    @Override
    public Object basicExecuteCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        return this.basicExecuteCall(call, translationRow, session, true);
    }

    public Object basicExecuteCall(Call call, AbstractRecord translationRow, AbstractSession session, boolean batch) throws DatabaseException {
        Statement statement = null;
        Object result = null;
        DatabaseCall dbCall = null;
        ResultSet resultSet = null;
        try {
            dbCall = (DatabaseCall)call;
        }
        catch (ClassCastException e) {
            throw QueryException.invalidDatabaseCall(call);
        }
        if (this.login == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        if (batch && this.isInBatchWritingMode(session)) {
            if (dbCall.isBatchExecutionSupported()) {
                this.getActiveBatchWritingMechanism(session).appendCall(session, dbCall);
                return 1;
            }
            this.getActiveBatchWritingMechanism(session).executeBatchedStatements(session);
        }
        try {
            this.incrementCallCount(session);
            if (session.shouldLog(3, "sql")) {
                session.log(3, "sql", dbCall.getLogString(this), null, this, false);
            }
            session.startOperationProfile("Timer:SqlPrepare", dbCall.getQuery(), Integer.MAX_VALUE);
            try {
                statement = dbCall.prepareStatement(this, translationRow, session);
            }
            finally {
                session.endOperationProfile("Timer:SqlPrepare", dbCall.getQuery(), Integer.MAX_VALUE);
            }
            if (dbCall.isExecuteUpdate()) {
                dbCall.setExecuteReturnValue(this.execute(dbCall, statement, session));
                dbCall.setStatement(statement);
                this.possibleFailure = false;
                return dbCall;
            }
            if (dbCall.isNothingReturned()) {
                result = this.executeNoSelect(dbCall, statement, session);
                ++this.writeStatementsCount;
                if (dbCall.isLOBLocatorNeeded()) {
                    this.getLOBWriter().addCall(dbCall);
                }
            } else if (!dbCall.getReturnsResultSet() || dbCall.getReturnsResultSet() && dbCall.shouldBuildOutputRow()) {
                result = session.getPlatform().executeStoredProcedure(dbCall, (PreparedStatement)statement, this, session);
                ++this.storedProcedureStatementsCount;
            } else {
                resultSet = this.executeSelect(dbCall, statement, session);
                ++this.readStatementsCount;
                if (!dbCall.shouldIgnoreFirstRowSetting() && dbCall.getFirstResult() != 0) {
                    resultSet.absolute(dbCall.getFirstResult());
                }
                dbCall.matchFieldOrder(resultSet, this, session);
                if (dbCall.isCursorReturned()) {
                    dbCall.setStatement(statement);
                    dbCall.setResult(resultSet);
                    this.possibleFailure = false;
                    return dbCall;
                }
                result = this.processResultSet(resultSet, dbCall, statement, session);
            }
            if (result instanceof ThreadCursoredList) {
                this.possibleFailure = false;
                return result;
            }
            if (session.shouldLog(1, "sql")) {
                SQLWarning warning = statement.getWarnings();
                while (warning != null) {
                    String message = String.valueOf(warning.getMessage()) + ":" + warning.getSQLState() + " - " + warning.getCause();
                    session.log(1, "sql", message, null, this, false);
                    warning = warning.getNextWarning();
                }
            }
        }
        catch (SQLException exception) {
            DatabaseException exceptionToThrow = this.processExceptionForCommError(session, exception, dbCall);
            try {
                this.closeStatement(statement, session, dbCall);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (exceptionToThrow == null) {
                throw DatabaseException.sqlException(exception, dbCall, this, session, false);
            }
            throw exceptionToThrow;
        }
        catch (RuntimeException exception) {
            try {
                this.closeStatement(statement, session, dbCall);
            }
            catch (Exception exceptionToThrow) {
                // empty catch block
            }
            if (exception instanceof DatabaseException) {
                ((DatabaseException)exception).setCall(dbCall);
                if (((DatabaseException)exception).getAccessor() == null) {
                    ((DatabaseException)exception).setAccessor(this);
                }
            }
            throw exception;
        }
        try {
            this.releaseStatement(statement, dbCall.getSQLString(), dbCall, session);
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
        this.possibleFailure = false;
        return result;
    }

    public Object processResultSet(ResultSet resultSet, DatabaseCall call, Statement statement, AbstractSession session) throws SQLException {
        Cloneable result = null;
        ResultSetMetaData metaData = resultSet.getMetaData();
        if (metaData.getColumnCount() == 0 && statement.getUpdateCount() > -1) {
            resultSet.close();
            throw new IllegalStateException(ExceptionLocalization.buildMessage("jpa21_invalid_call_with_no_result_sets_returned"));
        }
        session.startOperationProfile("Timer:RowFetch", call.getQuery(), Integer.MAX_VALUE);
        try {
            block21: {
                block20: {
                    if (!call.isOneRowReturned()) break block20;
                    if (!resultSet.next()) break block21;
                    if (call.isLOBLocatorNeeded()) {
                        this.getLOBWriter().fetchLocatorAndWriteValue(call, resultSet);
                    } else {
                        result = this.fetchRow(call.getFields(), call.getFieldsArray(), resultSet, metaData, session);
                    }
                    if (!resultSet.next() || !session.hasEventManager()) break block21;
                    session.getEventManager().moreRowsDetected(call);
                    break block21;
                }
                boolean hasMultipleResultsSets = call.hasMultipleResultSets();
                Vector<AbstractRecord> results = null;
                boolean hasMoreResultsSets = true;
                while (hasMoreResultsSets) {
                    boolean hasNext = resultSet.next();
                    if (hasNext) {
                        if (session.isConcurrent()) {
                            Vector vector = this.buildThreadCursoredResult(call, resultSet, statement, metaData, session);
                            return vector;
                        }
                        results = new Vector(16);
                        while (hasNext) {
                            results.add(this.fetchRow(call.getFields(), call.getFieldsArray(), resultSet, metaData, session));
                            hasNext = resultSet.next();
                        }
                    } else {
                        results = new Vector<AbstractRecord>(0);
                    }
                    if (result == null) {
                        if (call.returnMultipleResultSetCollections()) {
                            result = new Vector();
                            ((List)((Object)result)).add(results);
                        } else {
                            result = results;
                        }
                    } else if (call.returnMultipleResultSetCollections()) {
                        ((List)((Object)result)).add(results);
                    } else {
                        ((List)((Object)result)).addAll(results);
                    }
                    if (hasMultipleResultsSets) {
                        hasMoreResultsSets = statement.getMoreResults();
                        if (!hasMoreResultsSets) continue;
                        resultSet = statement.getResultSet();
                        metaData = resultSet.getMetaData();
                        call.setFields(null);
                        call.matchFieldOrder(resultSet, this, session);
                        continue;
                    }
                    hasMoreResultsSets = false;
                }
            }
            resultSet.close();
        }
        finally {
            session.endOperationProfile("Timer:RowFetch", call.getQuery(), Integer.MAX_VALUE);
        }
        return result;
    }

    protected Vector buildThreadCursoredResult(final DatabaseCall dbCall, final ResultSet resultSet, final Statement statement, final ResultSetMetaData metaData, final AbstractSession session) {
        final ThreadCursoredList results = new ThreadCursoredList(20);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    block20: {
                        session.startOperationProfile("Timer:RowFetch", dbCall.getQuery(), Integer.MAX_VALUE);
                        try {
                            boolean hasNext = true;
                            while (hasNext) {
                                results.add(DatabaseAccessor.this.fetchRow(dbCall.getFields(), dbCall.getFieldsArray(), resultSet, metaData, session));
                                hasNext = resultSet.next();
                            }
                            resultSet.close();
                        }
                        catch (SQLException exception) {
                            DatabaseException exceptionToThrow = DatabaseAccessor.this.processExceptionForCommError(session, exception, dbCall);
                            try {
                                DatabaseAccessor.this.closeStatement(statement, session, dbCall);
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            if (exceptionToThrow == null) {
                                results.throwException(DatabaseException.sqlException(exception, dbCall, DatabaseAccessor.this, session, false));
                            }
                            results.throwException(exceptionToThrow);
                            session.endOperationProfile("Timer:RowFetch", dbCall.getQuery(), Integer.MAX_VALUE);
                            break block20;
                        }
                        catch (RuntimeException exception) {
                            try {
                                try {
                                    DatabaseAccessor.this.closeStatement(statement, session, dbCall);
                                }
                                catch (Exception exceptionToThrow) {
                                    // empty catch block
                                }
                                if (exception instanceof DatabaseException) {
                                    ((DatabaseException)exception).setCall(dbCall);
                                }
                                results.throwException(exception);
                                break block20;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                session.endOperationProfile("Timer:RowFetch", dbCall.getQuery(), Integer.MAX_VALUE);
                            }
                        }
                        session.endOperationProfile("Timer:RowFetch", dbCall.getQuery(), Integer.MAX_VALUE);
                    }
                    try {
                        DatabaseAccessor.this.releaseStatement(statement, dbCall.getSQLString(), dbCall, session);
                    }
                    catch (SQLException exception) {
                        DatabaseException commException = DatabaseAccessor.this.processExceptionForCommError(session, exception, dbCall);
                        if (commException != null) {
                            results.throwException(commException);
                        }
                        results.throwException(DatabaseException.sqlException(exception, DatabaseAccessor.this, session, false));
                    }
                }
                finally {
                    results.setIsComplete(true);
                    session.releaseReadConnection(DatabaseAccessor.this);
                }
            }
        };
        dbCall.returnCursor();
        session.getServerPlatform().launchContainerRunnable(runnable);
        return results;
    }

    public Integer executeDirectNoSelect(Statement statement, DatabaseCall call, AbstractSession session) throws DatabaseException {
        int rowCount;
        block16: {
            rowCount = 0;
            try {
                try {
                    if (call != null) {
                        session.startOperationProfile("Timer:StatementExecute", call.getQuery(), Integer.MAX_VALUE);
                    } else {
                        session.startOperationProfile("Timer:StatementExecute", null, Integer.MAX_VALUE);
                    }
                    rowCount = call != null && call.isDynamicCall(session) ? statement.executeUpdate(call.getSQLString()) : ((PreparedStatement)statement).executeUpdate();
                    if (!this.getPlatform().supportsAutoCommit() && !this.isInTransaction) {
                        this.getPlatform().autoCommit(this);
                    }
                }
                catch (SQLException exception) {
                    if (!this.getPlatform().shouldIgnoreException(exception)) {
                        DatabaseException commException = this.processExceptionForCommError(session, exception, call);
                        if (commException != null) {
                            throw commException;
                        }
                        throw DatabaseException.sqlException(exception, this, session, false);
                    }
                    if (call != null) {
                        session.endOperationProfile("Timer:StatementExecute", call.getQuery(), Integer.MAX_VALUE);
                    } else {
                        session.endOperationProfile("Timer:StatementExecute", null, Integer.MAX_VALUE);
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (call != null) {
                    session.endOperationProfile("Timer:StatementExecute", call.getQuery(), Integer.MAX_VALUE);
                } else {
                    session.endOperationProfile("Timer:StatementExecute", null, Integer.MAX_VALUE);
                }
                throw throwable;
            }
            if (call != null) {
                session.endOperationProfile("Timer:StatementExecute", call.getQuery(), Integer.MAX_VALUE);
            } else {
                session.endOperationProfile("Timer:StatementExecute", null, Integer.MAX_VALUE);
            }
        }
        return rowCount;
    }

    protected int executeJDK12BatchStatement(Statement statement, DatabaseCall dbCall, AbstractSession session, boolean isStatementPrepared) throws DatabaseException {
        int returnValue = 0;
        try {
            returnValue = this.getPlatform().executeBatch(statement, isStatementPrepared);
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, dbCall);
            if (commException != null) {
                throw commException;
            }
            try {
                this.closeStatement(statement, session, dbCall);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
        catch (RuntimeException exception) {
            try {
                this.closeStatement(statement, session, dbCall);
            }
            catch (SQLException commException) {
                // empty catch block
            }
            throw exception;
        }
        try {
            if (dbCall != null) {
                this.releaseStatement(statement, dbCall.getSQLString(), dbCall, session);
            } else {
                this.closeStatement(statement, session, null);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, dbCall);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
        return returnValue;
    }

    protected Integer executeNoSelect(DatabaseCall call, Statement statement, AbstractSession session) throws DatabaseException {
        Integer rowCount = this.executeDirectNoSelect(statement, call, session);
        if (call.shouldBuildOutputRow()) {
            AbstractRecord outputRow = this.buildOutputRow((CallableStatement)statement, call, session);
            call.getQuery().setProperty("output", outputRow);
            if (session.hasEventManager()) {
                session.getEventManager().outputParametersDetected(outputRow, call);
            }
        }
        return rowCount;
    }

    public boolean execute(DatabaseCall call, Statement statement, AbstractSession session) throws SQLException {
        boolean result;
        session.startOperationProfile("Timer:StatementExecute", call.getQuery(), Integer.MAX_VALUE);
        try {
            result = call.isDynamicCall(session) ? statement.execute(call.getSQLString()) : ((PreparedStatement)statement).execute();
        }
        finally {
            session.endOperationProfile("Timer:StatementExecute", call.getQuery(), Integer.MAX_VALUE);
        }
        return result;
    }

    public ResultSet executeSelect(DatabaseCall call, Statement statement, AbstractSession session) throws SQLException {
        ResultSet resultSet;
        session.startOperationProfile("Timer:StatementExecute", call.getQuery(), Integer.MAX_VALUE);
        try {
            resultSet = call.isDynamicCall(session) ? statement.executeQuery(call.getSQLString()) : ((PreparedStatement)statement).executeQuery();
        }
        finally {
            session.endOperationProfile("Timer:StatementExecute", call.getQuery(), Integer.MAX_VALUE);
        }
        if (call.shouldBuildOutputRow() && this.getPlatform().isOutputAllowWithResultSet()) {
            AbstractRecord outputRow = this.buildOutputRow((CallableStatement)statement, call, session);
            call.getQuery().setProperty("output", outputRow);
            if (session.hasEventManager()) {
                session.getEventManager().outputParametersDetected(outputRow, call);
            }
        }
        return resultSet;
    }

    protected AbstractRecord fetchRow(Vector fields, ResultSet resultSet, ResultSetMetaData metaData, AbstractSession session) throws DatabaseException {
        int size = fields.size();
        NonSynchronizedVector values = NonSynchronizedVector.newInstance(size);
        DatabasePlatform platform = this.getPlatform();
        boolean optimizeData = platform.shouldOptimizeDataConversion();
        int index = 0;
        while (index < size) {
            DatabaseField field = (DatabaseField)fields.elementAt(index);
            if (field != null) {
                ((Vector)values).add(this.getObject(resultSet, field, metaData, index + 1, platform, optimizeData, session));
            } else {
                ((Vector)values).add(null);
            }
            ++index;
        }
        return new DatabaseRecord(fields, values);
    }

    public AbstractRecord fetchRow(Vector fields, DatabaseField[] fieldsArray, ResultSet resultSet, ResultSetMetaData metaData, AbstractSession session) throws DatabaseException {
        int size = fieldsArray.length;
        Object[] values = new Object[size];
        DatabasePlatform platform = this.getPlatform();
        boolean optimizeData = platform.shouldOptimizeDataConversion();
        int index = 0;
        while (index < size) {
            DatabaseField field = fieldsArray[index];
            values[index] = field != null ? this.getObject(resultSet, field, metaData, index + 1, platform, optimizeData, session) : null;
            ++index;
        }
        return new ArrayRecord(fields, fieldsArray, values);
    }

    public void populateRow(DatabaseField[] fieldsArray, Object[] values, ResultSet resultSet, ResultSetMetaData metaData, AbstractSession session, int startIndex, int endIndex) throws DatabaseException {
        DatabasePlatform platform = this.getPlatform();
        boolean optimizeData = platform.shouldOptimizeDataConversion();
        int index = startIndex;
        while (index < endIndex) {
            DatabaseField field = fieldsArray[index];
            if (field != null) {
                values[index] = this.getObject(resultSet, field, metaData, index + 1, platform, optimizeData, session);
            }
            ++index;
        }
    }

    public BatchWritingMechanism getActiveBatchWritingMechanism(AbstractSession session) {
        if (this.activeBatchWritingMechanism == null) {
            if (((DatabasePlatform)this.platform).getBatchWritingMechanism() != null) {
                this.activeBatchWritingMechanism = ((DatabasePlatform)this.platform).getBatchWritingMechanism().clone();
                this.activeBatchWritingMechanism.setAccessor(this, session);
            } else {
                this.activeBatchWritingMechanism = this.getParameterizedMechanism();
            }
        }
        return this.activeBatchWritingMechanism;
    }

    @Override
    public Vector getColumnInfo(String catalog, String schema, String tableName, String columnName, AbstractSession session) throws DatabaseException {
        if (session.shouldLog(1, "query")) {
            Object[] args = new Object[]{catalog, schema, tableName, columnName};
            session.log(1, "query", "query_column_meta_data_with_column", args, this);
        }
        Vector<AbstractRecord> result = new Vector<AbstractRecord>();
        ResultSet resultSet = null;
        try {
            try {
                this.incrementCallCount(session);
                resultSet = this.getConnectionMetaData().getColumns(catalog, schema, tableName, columnName);
                Vector fields = this.buildSortedFields(null, resultSet, session);
                ResultSetMetaData metaData = resultSet.getMetaData();
                while (resultSet.next()) {
                    result.addElement(this.fetchRow(fields, resultSet, metaData, session));
                }
                resultSet.close();
            }
            catch (SQLException sqlException) {
                DatabaseException commException;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException metaData) {
                    // empty catch block
                }
                if ((commException = this.processExceptionForCommError(session, sqlException, null)) != null) {
                    throw commException;
                }
                throw DatabaseException.sqlException(sqlException, this, session, false);
            }
        }
        finally {
            this.decrementCallCount();
        }
        return result;
    }

    protected Vector getColumnNames(ResultSet resultSet, AbstractSession session) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        Vector<DatabaseField> columnNames = new Vector<DatabaseField>(metaData.getColumnCount());
        int index = 0;
        while (index < metaData.getColumnCount()) {
            String columnName = metaData.getColumnLabel(index + 1);
            if (columnName == null || columnName.equals("")) {
                columnName = "C" + (index + 1);
            }
            DatabaseField column = new DatabaseField(columnName);
            if (this.getPlatform().shouldForceFieldNamesToUpperCase()) {
                column.useUpperCaseForComparisons(true);
            }
            columnNames.addElement(column);
            ++index;
        }
        return columnNames;
    }

    @Override
    public Connection getConnection() throws DatabaseException {
        return (Connection)this.datasourceConnection;
    }

    public DatabasePlatform getPlatform() {
        return (DatabasePlatform)this.platform;
    }

    public DatabaseMetaData getConnectionMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObject(ResultSet resultSet, DatabaseField field, ResultSetMetaData metaData, int columnNumber, DatabasePlatform platform, boolean optimizeData, AbstractSession session) throws DatabaseException {
        Object value = null;
        try {
            int type;
            block23: {
                type = field.sqlType;
                if (type == Integer.MIN_VALUE) {
                    type = metaData.getColumnType(columnNumber);
                    field.setSqlType(type);
                }
                if (optimizeData) {
                    try {
                        value = this.getObjectThroughOptimizedDataConversion(resultSet, field, type, columnNumber, platform, session);
                        if (value == null) {
                            return null;
                        }
                        if (value == this) {
                            value = null;
                        }
                    }
                    catch (SQLException exception) {
                        if (!session.shouldLog(6, "sql")) break block23;
                        session.logThrowable(6, "sql", exception);
                    }
                }
            }
            if (value == null) {
                if (type == -4 && platform.usesStreamsForBinding()) {
                    InputStream tempInputStream = resultSet.getBinaryStream(columnNumber);
                    if (tempInputStream != null) {
                        try {
                            ByteArrayOutputStream tempOutputStream = new ByteArrayOutputStream();
                            int tempInt = tempInputStream.read();
                            while (true) {
                                if (tempInt == -1) {
                                    value = tempOutputStream.toByteArray();
                                    break;
                                }
                                tempOutputStream.write(tempInt);
                                tempInt = tempInputStream.read();
                            }
                        }
                        catch (IOException exception) {
                            throw DatabaseException.errorReadingBlobData();
                        }
                    }
                } else {
                    value = platform.getObjectFromResultSet(resultSet, columnNumber, type, session);
                    if (DatabaseAccessor.isBlob(type)) {
                        Object originalValue = value;
                        value = platform.convertObject(value, ClassConstants.APBYTE);
                        platform.freeTemporaryObject(originalValue);
                    } else if (DatabaseAccessor.isClob(type)) {
                        Object originalValue = value;
                        value = platform.convertObject(value, ClassConstants.STRING);
                        platform.freeTemporaryObject(originalValue);
                    } else if (this.isArray(type)) {
                        value = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromArray(value);
                    } else if (this.isStruct(type, value)) {
                        value = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromStruct(value);
                    }
                }
            }
            if (optimizeData) return value;
            if (!resultSet.wasNull()) return value;
            return null;
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException == null) throw DatabaseException.sqlException(exception, this, session, false);
            throw commException;
        }
    }

    protected Object getObjectThroughOptimizedDataConversion(ResultSet resultSet, DatabaseField field, int type, int columnNumber, DatabasePlatform platform, AbstractSession session) throws SQLException {
        Object value = this;
        Class fieldType = field.type;
        if (platform.shouldUseGetSetNString() && (type == -9 || type == -15)) {
            value = resultSet.getNString(columnNumber);
            if (type == -15 && value != null && platform.shouldTrimStrings()) {
                value = Helper.rightTrimString((String)value);
            }
            return value;
        }
        if (type == 12 || type == 1 || type == -9 || type == -15) {
            value = resultSet.getString(columnNumber);
            if ((type == 1 || type == -15) && value != null && platform.shouldTrimStrings()) {
                value = Helper.rightTrimString((String)value);
            }
            return value;
        }
        if (fieldType == null) {
            return this;
        }
        boolean isPrimitive = false;
        if (fieldType == ClassConstants.PLONG || fieldType == ClassConstants.LONG) {
            value = resultSet.getLong(columnNumber);
            isPrimitive = (Long)value == 0L;
        } else if (fieldType == ClassConstants.INTEGER || fieldType == ClassConstants.PINT) {
            value = resultSet.getInt(columnNumber);
            isPrimitive = (Integer)value == 0;
        } else if (fieldType == ClassConstants.FLOAT || fieldType == ClassConstants.PFLOAT) {
            value = Float.valueOf(resultSet.getFloat(columnNumber));
            isPrimitive = ((Float)value).floatValue() == 0.0f;
        } else if (fieldType == ClassConstants.DOUBLE || fieldType == ClassConstants.PDOUBLE) {
            value = resultSet.getDouble(columnNumber);
            isPrimitive = (Double)value == 0.0;
        } else if (fieldType == ClassConstants.SHORT || fieldType == ClassConstants.PSHORT) {
            value = resultSet.getShort(columnNumber);
            isPrimitive = (Short)value == 0;
        } else if (type == 92 || type == 91 || type == 93) {
            if (Helper.shouldOptimizeDates) {
                String dateString = resultSet.getString(columnNumber);
                value = platform.convertObject(dateString, fieldType);
            } else if (fieldType == ClassConstants.SQLDATE) {
                value = resultSet.getDate(columnNumber);
            } else if (fieldType == ClassConstants.TIME) {
                value = resultSet.getTime(columnNumber);
            } else if (fieldType == ClassConstants.TIMESTAMP) {
                value = resultSet.getTimestamp(columnNumber);
            } else if (fieldType == ClassConstants.TIME_LTIME) {
                Timestamp ts = resultSet.getTimestamp(columnNumber);
                value = ts != null ? ts.toLocalDateTime().toLocalTime() : platform.getConversionManager().getDefaultNullValue(ClassConstants.TIME_LTIME);
            } else if (fieldType == ClassConstants.TIME_LDATE) {
                Date dt = resultSet.getDate(columnNumber);
                value = dt != null ? dt.toLocalDate() : platform.getConversionManager().getDefaultNullValue(ClassConstants.TIME_LDATE);
            } else if (fieldType == ClassConstants.TIME_LDATETIME) {
                Timestamp ts = resultSet.getTimestamp(columnNumber);
                value = ts != null ? ts.toLocalDateTime() : platform.getConversionManager().getDefaultNullValue(ClassConstants.TIME_LDATETIME);
            } else if (fieldType == ClassConstants.TIME_OTIME) {
                Timestamp ts = resultSet.getTimestamp(columnNumber);
                value = ts != null ? ts.toLocalDateTime().toLocalTime().atOffset(OffsetDateTime.now().getOffset()) : platform.getConversionManager().getDefaultNullValue(ClassConstants.TIME_OTIME);
            } else if (fieldType == ClassConstants.TIME_ODATETIME) {
                Timestamp ts = resultSet.getTimestamp(columnNumber);
                value = ts != null ? OffsetDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault()) : platform.getConversionManager().getDefaultNullValue(ClassConstants.TIME_ODATETIME);
            }
        } else if (fieldType == ClassConstants.BIGINTEGER) {
            value = resultSet.getBigDecimal(columnNumber);
            if (value != null) {
                return ((BigDecimal)value).toBigInteger();
            }
        } else if (fieldType == ClassConstants.BIGDECIMAL) {
            value = resultSet.getBigDecimal(columnNumber);
        }
        if (isPrimitive && resultSet.wasNull()) {
            value = null;
        }
        return value;
    }

    protected boolean hasStatementCache() {
        return this.statementCache != null && !this.statementCache.isEmpty();
    }

    protected synchronized Map<String, Statement> getStatementCache() {
        if (this.statementCache == null) {
            this.statementCache = new HashMap<String, Statement>(50);
        }
        return this.statementCache;
    }

    @Override
    public Vector getTableInfo(String catalog, String schema, String tableName, String[] types, AbstractSession session) throws DatabaseException {
        if (session.shouldLog(1, "query")) {
            Object[] args = new Object[]{catalog, schema, tableName};
            session.log(1, "query", "query_column_meta_data", args, this);
        }
        Vector<AbstractRecord> result = new Vector<AbstractRecord>();
        ResultSet resultSet = null;
        try {
            try {
                this.incrementCallCount(session);
                resultSet = this.getConnectionMetaData().getTables(catalog, schema, tableName, types);
                Vector fields = this.buildSortedFields(null, resultSet, session);
                ResultSetMetaData metaData = resultSet.getMetaData();
                while (resultSet.next()) {
                    result.addElement(this.fetchRow(fields, resultSet, metaData, session));
                }
                resultSet.close();
            }
            catch (SQLException sqlException) {
                DatabaseException commException;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException metaData) {
                    // empty catch block
                }
                if ((commException = this.processExceptionForCommError(session, sqlException, null)) != null) {
                    throw commException;
                }
                throw DatabaseException.sqlException(sqlException, this, session, false);
            }
        }
        finally {
            this.decrementCallCount();
        }
        return result;
    }

    @Override
    public boolean isDatasourceConnected() {
        try {
            return !this.getConnection().isClosed();
        }
        catch (SQLException exception) {
            return false;
        }
    }

    protected boolean isInBatchWritingMode(AbstractSession session) {
        return this.getPlatform().usesBatchWriting() && this.isInTransaction;
    }

    public Statement prepareStatement(DatabaseCall call, AbstractSession session) throws SQLException {
        return this.prepareStatement(call, session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement prepareStatement(DatabaseCall call, AbstractSession session, boolean unwrapConnection) throws SQLException {
        Statement statement = null;
        if (call.usesBinding(session) && call.shouldCacheStatement(session)) {
            Map<String, Statement> statementCache;
            Map<String, Statement> map = statementCache = this.getStatementCache();
            synchronized (map) {
                statement = (PreparedStatement)statementCache.get(call.getSQLString());
                if (statement != null) {
                    statementCache.remove(call.getSQLString());
                }
            }
        }
        if (statement == null) {
            Connection nativeConnection = this.getConnection();
            if (nativeConnection == null) {
                throw DatabaseException.databaseAccessorConnectionIsNull(this, session);
            }
            if (unwrapConnection || call.isNativeConnectionRequired()) {
                nativeConnection = this.getPlatform().getConnection(session, nativeConnection);
            }
            if (call.isCallableStatementRequired()) {
                if (call.isResultSetScrollable()) {
                    statement = nativeConnection.prepareCall(call.getSQLString(), call.getResultSetType(), call.getResultSetConcurrency());
                    statement.setFetchSize(call.getResultSetFetchSize());
                } else {
                    statement = nativeConnection.prepareCall(call.getSQLString());
                }
            } else if (call.isResultSetScrollable()) {
                statement = nativeConnection.prepareStatement(call.getSQLString(), call.getResultSetType(), call.getResultSetConcurrency());
                statement.setFetchSize(call.getResultSetFetchSize());
            } else {
                statement = call.isDynamicCall(session) ? this.allocateDynamicStatement(nativeConnection) : nativeConnection.prepareStatement(call.getSQLString());
            }
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql, AbstractSession session, boolean callable) throws SQLException {
        PreparedStatement statement = null;
        if (this.getPlatform().shouldCacheAllStatements()) {
            Map<String, Statement> statementCache;
            Map<String, Statement> map = statementCache = this.getStatementCache();
            synchronized (map) {
                statement = (PreparedStatement)statementCache.get(sql);
                if (statement != null) {
                    statementCache.remove(sql);
                }
            }
        }
        if (statement == null) {
            Connection nativeConnection = this.getConnection();
            if (nativeConnection == null) {
                throw DatabaseException.databaseAccessorConnectionIsNull(this, session);
            }
            statement = callable ? nativeConnection.prepareCall(sql) : nativeConnection.prepareStatement(sql);
        }
        return statement;
    }

    public DatabaseException processExceptionForCommError(AbstractSession session, SQLException exception, Call call) {
        if (session.getLogin().isConnectionHealthValidatedOnError((DatabaseCall)call, this) && this.getConnection() != null && session.getServerPlatform().wasFailureCommunicationBased(exception, this, session)) {
            this.setIsValid(false);
            this.setPossibleFailure(false);
            return DatabaseException.sqlException(exception, call, this, session, true);
        }
        return null;
    }

    @Override
    protected void reconnect(AbstractSession session) {
        this.clearStatementCache(session);
        super.reconnect(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseStatement(Statement statement, String sqlString, DatabaseCall call, AbstractSession session) throws SQLException {
        if (call == null && this.getPlatform().shouldCacheAllStatements() || call != null && call.usesBinding(session) && call.shouldCacheStatement(session)) {
            Map<String, Statement> statementCache;
            Map<String, Statement> map = statementCache = this.getStatementCache();
            synchronized (map) {
                PreparedStatement preparedStatement = (PreparedStatement)statement;
                if (!statementCache.containsKey(sqlString)) {
                    preparedStatement.clearParameters();
                    if (call != null) {
                        this.resetStatementFromCall(preparedStatement, call);
                    }
                    if (statementCache.size() > this.getPlatform().getStatementCacheSize()) {
                        PreparedStatement removedStatement = (PreparedStatement)statementCache.remove(statementCache.keySet().iterator().next());
                        this.closeStatement(removedStatement, session, call);
                    } else {
                        this.decrementCallCount();
                    }
                    statementCache.put(sqlString, preparedStatement);
                } else {
                    this.closeStatement(statement, session, call);
                }
            }
        } else if (statement == this.dynamicStatement) {
            if (call != null) {
                this.resetStatementFromCall(statement, call);
            }
            this.setIsDynamicStatementInUse(false);
            this.decrementCallCount();
        } else {
            this.closeStatement(statement, session, call);
        }
    }

    protected void resetStatementFromCall(Statement statement, DatabaseCall call) throws SQLException {
        if (call.getQueryTimeout() > 0) {
            statement.setQueryTimeout(0);
        }
        if (call.getMaxRows() > 0) {
            statement.setMaxRows(0);
        }
        if (call.getResultSetFetchSize() > 0) {
            statement.setFetchSize(0);
        }
    }

    @Override
    public void rollbackTransaction(AbstractSession session) throws DatabaseException {
        this.getActiveBatchWritingMechanism(session).clear();
        super.rollbackTransaction(session);
    }

    @Override
    public void basicRollbackTransaction(AbstractSession session) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().rollback();
                this.getConnection().setAutoCommit(true);
            } else {
                this.getPlatform().rollbackTransaction(this);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    public void setActiveBatchWritingMechanismToParameterizedSQL() {
        this.activeBatchWritingMechanism = this.getParameterizedMechanism();
        if (((DatabaseLogin)this.login).getMaxBatchWritingSize() == 32000) {
            ((DatabaseLogin)this.login).setMaxBatchWritingSize(100);
        }
    }

    public void setActiveBatchWritingMechanismToDynamicSQL() {
        this.activeBatchWritingMechanism = this.getDynamicSQLMechanism();
        if (((DatabaseLogin)this.login).getMaxBatchWritingSize() == 100) {
            ((DatabaseLogin)this.login).setMaxBatchWritingSize(32000);
        }
    }

    public void setActiveBatchWritingMechanism(BatchWritingMechanism mechanism) {
        this.activeBatchWritingMechanism = mechanism;
    }

    protected void setStatementCache(Hashtable statementCache) {
        this.statementCache = statementCache;
    }

    protected Vector sortFields(Vector fields, Vector columnNames) {
        Vector<DatabaseField> sortedFields = new Vector<DatabaseField>(columnNames.size());
        Vector eligableFields = (Vector)fields.clone();
        Enumeration columnNamesEnum = columnNames.elements();
        while (columnNamesEnum.hasMoreElements()) {
            DatabaseField field = null;
            boolean valueFound = false;
            DatabaseField column = (DatabaseField)columnNamesEnum.nextElement();
            Enumeration fieldEnum = eligableFields.elements();
            while (fieldEnum.hasMoreElements()) {
                field = (DatabaseField)fieldEnum.nextElement();
                if (field == null || !field.equals(column)) continue;
                valueFound = true;
                sortedFields.addElement(field);
                break;
            }
            if (valueFound) {
                eligableFields.removeElement(field);
                continue;
            }
            sortedFields.addElement(new DatabaseField());
        }
        return sortedFields;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("DatabaseAccessor(");
        if (this.isConnected()) {
            writer.write(ToStringLocalization.buildMessage("connected", null));
        } else {
            writer.write(ToStringLocalization.buildMessage("disconnected", null));
        }
        writer.write(")");
        return writer.toString();
    }

    private boolean isArray(int type) {
        return type == 2003;
    }

    public static boolean isBlob(int type) {
        return type == 2004 || type == -4;
    }

    public static boolean isClob(int type) {
        return type == 2005 || type == -1 || type == 2011 || type == -16;
    }

    private boolean isStruct(int type, Object value) {
        return type == 2002 && value instanceof Struct;
    }

    @Override
    public void writesCompleted(AbstractSession session) {
        if (this.isConnected && this.isInBatchWritingMode(session)) {
            this.getActiveBatchWritingMechanism(session).executeBatchedStatements(session);
        }
    }
}

