"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const core_1 = require("@angular-devkit/core");
class UnknownActionException extends core_1.BaseException {
    constructor(action) { super(`Unknown action: "${action.kind}".`); }
}
exports.UnknownActionException = UnknownActionException;
let _id = 1;
class ActionList {
    constructor() {
        this._actions = [];
    }
    _action(action) {
        this._actions.push(Object.assign({
            id: _id++,
            parent: this._actions[this._actions.length - 1] || 0,
        }, action));
    }
    create(path, content) {
        this._action({ kind: 'c', path, content });
    }
    overwrite(path, content) {
        this._action({ kind: 'o', path, content });
    }
    rename(path, to) {
        this._action({ kind: 'r', path, to });
    }
    delete(path) {
        this._action({ kind: 'd', path });
    }
    optimize() {
        let changed = false;
        const actions = this._actions;
        const deleted = new Set();
        this._actions = [];
        // Handles files we create.
        for (let i = 0; i < actions.length; i++) {
            const iAction = actions[i];
            if (iAction.kind == 'c') {
                let path = iAction.path;
                let content = iAction.content;
                let toDelete = false;
                deleted.delete(path);
                for (let j = i + 1; j < actions.length; j++) {
                    const action = actions[j];
                    if (path == action.path) {
                        changed = true;
                        switch (action.kind) {
                            case 'c':
                                content = action.content;
                                actions.splice(j--, 1);
                                break;
                            case 'o':
                                content = action.content;
                                actions.splice(j--, 1);
                                break;
                            case 'r':
                                path = action.to;
                                actions.splice(j--, 1);
                                break;
                            case 'd':
                                toDelete = true;
                                actions.splice(j--, 1);
                                break;
                        }
                    }
                    if (toDelete) {
                        break;
                    }
                }
                if (!toDelete) {
                    this.create(path, content);
                }
                else {
                    deleted.add(path);
                }
            }
            else if (deleted.has(iAction.path)) {
                // DoNothing
            }
            else {
                switch (iAction.kind) {
                    case 'o':
                        this.overwrite(iAction.path, iAction.content);
                        break;
                    case 'r':
                        this.rename(iAction.path, iAction.to);
                        break;
                    case 'd':
                        this.delete(iAction.path);
                        break;
                }
            }
        }
        // TODO: fix the optimization and remove this recursivity.
        if (changed) {
            this.optimize();
        }
    }
    push(action) { this._actions.push(action); }
    get(i) { return this._actions[i]; }
    has(action) {
        for (let i = 0; i < this._actions.length; i++) {
            const a = this._actions[i];
            if (a.id == action.id) {
                return true;
            }
            if (a.id > action.id) {
                return false;
            }
        }
        return false;
    }
    find(predicate) {
        return this._actions.find(predicate) || null;
    }
    forEach(fn, thisArg) {
        this._actions.forEach(fn, thisArg);
    }
    get length() { return this._actions.length; }
    [Symbol.iterator]() { return this._actions[Symbol.iterator](); }
}
exports.ActionList = ActionList;
function isContentAction(action) {
    return action.kind == 'c' || action.kind == 'o';
}
exports.isContentAction = isContentAction;
function isAction(action) {
    const kind = action && action.kind;
    return action !== null
        && typeof action.id == 'number'
        && typeof action.path == 'string'
        && (kind == 'c' || kind == 'o' || kind == 'r' || kind == 'd');
}
exports.isAction = isAction;
//# sourceMappingURL=data:application/json;base64,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