"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const core_1 = require("@angular-devkit/core");
class InMemoryFileSystemTreeHost {
    constructor(content) {
        this._content = Object.create(null);
        Object.keys(content).forEach(path => {
            path = core_1.normalize(path);
            this._content[path] = new Buffer(content[path]);
        });
        this._files = Object.keys(this._content);
    }
    listDirectory(path) {
        path = core_1.normalize(path).replace(/\/?$/, '/');
        return Object.keys(this._files
            .filter(p => p.startsWith(path))
            .map(p => p.substr(path.length))
            .map(p => p.replace(/\/.*$/, ''))
            .reduce((acc, p) => (acc[p] = true, acc), {})).sort();
    }
    isDirectory(path) {
        path = core_1.normalize(path);
        return path == '/' || this._files.some(p => p.split('/').slice(0, -1).join('/') == path);
    }
    readFile(path) {
        path = core_1.normalize(path);
        return this._content[path] || new Buffer('');
    }
    exists(path) {
        path = core_1.normalize(path);
        return this._content[path] != undefined;
    }
    join(path1, path2) {
        return core_1.normalize(path1 + '/' + path2);
    }
}
exports.InMemoryFileSystemTreeHost = InMemoryFileSystemTreeHost;
//# sourceMappingURL=data:application/json;base64,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