import { OnInit, AfterViewInit, OnChanges, OnDestroy, EventEmitter, ElementRef, NgZone } from '@angular/core';
import 'rxjs/add/observable/fromEvent';
import 'rxjs/add/observable/merge';
import 'rxjs/add/observable/of';
import 'rxjs/add/observable/zip';
import 'rxjs/add/operator/do';
import 'rxjs/add/operator/filter';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/share';
import 'rxjs/add/operator/take';
import 'rxjs/add/operator/toPromise';
import { BsModalHideType } from './models';
import { BsModalService } from './modal-service';
export declare class BsModalComponent implements OnInit, AfterViewInit, OnChanges, OnDestroy {
    private element;
    private service;
    private zone;
    private overrideSize;
    private $modal;
    private $dialog;
    private onShowEvent$;
    private onShownEvent$;
    private onHideEvent$;
    private onHiddenEvent$;
    private onLoadedEvent$;
    private onShown$;
    private onInternalClose$;
    private onDismiss$;
    private onHide$;
    private onHidden$;
    private subscriptions;
    private readonly options;
    visible: boolean;
    showing: boolean;
    hiding: boolean;
    animation: boolean;
    backdrop: string | boolean;
    keyboard: boolean;
    size: string;
    cssClass: string;
    onShow: EventEmitter<Event>;
    onOpen: EventEmitter<any>;
    onHide: EventEmitter<any>;
    onClose: EventEmitter<any>;
    onDismiss: EventEmitter<BsModalHideType>;
    onLoaded: EventEmitter<any>;
    readonly fadeClass: boolean;
    readonly modalClass: boolean;
    readonly roleAttr: string;
    readonly tabindexAttr: string;
    constructor(element: ElementRef, service: BsModalService, zone: NgZone);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    ngOnChanges(): void;
    ngOnDestroy(): Promise<BsModalHideType>;
    focus(): void;
    routerCanDeactivate(): any;
    open(size?: string): Promise<any>;
    close(value?: any): Promise<{}>;
    dismiss(): Promise<{}>;
    getCssClasses(): string;
    private isSmall();
    private isLarge();
    private show();
    private transitionFix();
    private hide();
    private init();
    private wireUpEventEmitters();
    private wireUpEventEmitter<T>(emitter, stream$);
    private setVisible;
    private setOptions;
    private destroy();
}
