/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util.urltemplate;

import org.apache.knox.gateway.util.urltemplate.Segment;
import org.apache.knox.gateway.util.urltemplate.Token;

public class Query
extends Segment {
    private String queryName;

    public Query(String queryName, String paramName, String valuePattern, boolean literal) {
        super(new Token(paramName, valuePattern, literal));
        this.queryName = queryName;
    }

    public Query(Query that) {
        super(that.getToken());
        this.queryName = that.queryName;
    }

    Query(String queryName, Token token) {
        super(token);
        this.queryName = queryName;
    }

    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public boolean matches(Segment that) {
        boolean matches = super.matches(that);
        if (matches) {
            Query thatQuery = (Query)that;
            matches = this.queryName.equals(thatQuery.queryName);
        }
        return matches;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Query) {
            Query that = (Query)obj;
            return super.equals(that) && that.getQueryName().equals(this.getQueryName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return 31 * result + this.getQueryName().hashCode();
    }
}

