/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.matching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.matching.HttpMethodMatcher;
import org.pac4j.core.matching.Matcher;
import org.pac4j.core.matching.MatchingChecker;
import org.pac4j.core.util.CommonHelper;

public class RequireAllMatchersChecker
implements MatchingChecker {
    private static final String GET_MATCHER_NAME = "get";
    private static final Matcher GET_MATCHER = new HttpMethodMatcher(HttpConstants.HTTP_METHOD.GET);
    private static final String POST_MATCHER_NAME = "post";
    private static final Matcher POST_MATCHER = new HttpMethodMatcher(HttpConstants.HTTP_METHOD.POST);
    private static final String PUT_MATCHER_NAME = "put";
    private static final Matcher PUT_MATCHER = new HttpMethodMatcher(HttpConstants.HTTP_METHOD.PUT);
    private static final String DELETE_MATCHER_NAME = "delete";
    private static final Matcher DELETE_MATCHER = new HttpMethodMatcher(HttpConstants.HTTP_METHOD.DELETE);

    @Override
    public boolean matches(WebContext context, String matcherNames, Map<String, Matcher> matchersMap) {
        if (CommonHelper.isNotBlank(matcherNames)) {
            ArrayList<Matcher> matchers = new ArrayList<Matcher>();
            CommonHelper.assertNotNull("matchersMap", matchersMap);
            Map<String, Matcher> allMatchers = this.buildAllMatchers(matchersMap);
            for (String name : matcherNames.split(",")) {
                Matcher result = null;
                for (Map.Entry<String, Matcher> entry : allMatchers.entrySet()) {
                    if (!CommonHelper.areEqualsIgnoreCaseAndTrim(entry.getKey(), name)) continue;
                    result = entry.getValue();
                    break;
                }
                CommonHelper.assertNotNull("allMatchers['" + name + "']", result);
                matchers.add(result);
            }
            if (!matchers.isEmpty()) {
                for (Matcher matcher : matchers) {
                    if (matcher.matches(context)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private Map<String, Matcher> buildAllMatchers(Map<String, Matcher> matchersMap) {
        HashMap<String, Matcher> allMatchers = new HashMap<String, Matcher>();
        allMatchers.putAll(matchersMap);
        this.addDefaultMatcherIfNotDefined(allMatchers, GET_MATCHER_NAME, GET_MATCHER);
        this.addDefaultMatcherIfNotDefined(allMatchers, POST_MATCHER_NAME, POST_MATCHER);
        this.addDefaultMatcherIfNotDefined(allMatchers, PUT_MATCHER_NAME, PUT_MATCHER);
        this.addDefaultMatcherIfNotDefined(allMatchers, DELETE_MATCHER_NAME, DELETE_MATCHER);
        return allMatchers;
    }

    private void addDefaultMatcherIfNotDefined(Map<String, Matcher> allMatchers, String name, Matcher matcher) {
        if (!allMatchers.containsKey(name)) {
            allMatchers.put(name, matcher);
        }
    }
}

