/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.encAsRepPart.actions;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.EncKdcRepPart.EncKdcRepPartContainer;
import org.apache.directory.shared.kerberos.codec.encAsRepPart.EncAsRepPartContainer;
import org.apache.directory.shared.kerberos.components.EncKdcRepPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreEncAsRepPart
extends GrammarAction<EncAsRepPartContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreEncAsRepPart.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreEncAsRepPart() {
        super("Add an EncAsRepPart instance");
    }

    public void action(EncAsRepPartContainer encAsRepPartContainer) throws DecoderException {
        TLV tlv = encAsRepPartContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_01308_ZERO_LENGTH_TLV, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_01309_EMPTY_TLV, (Object[])new Object[0]));
        }
        EncKdcRepPartContainer encKdcRepPartContainer = new EncKdcRepPartContainer(encAsRepPartContainer.getStream());
        Asn1Decoder.decode((ByteBuffer)encAsRepPartContainer.getStream(), (Asn1Container)encKdcRepPartContainer);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        encAsRepPartContainer.updateParent();
        EncKdcRepPart encKdcRepPart = encKdcRepPartContainer.getEncKdcRepPart();
        encAsRepPartContainer.getEncAsRepPart().setEncKdcRepPart(encKdcRepPart);
        if (IS_DEBUG) {
            LOG.debug("EncAsRepPart : {}", (Object)encKdcRepPart);
        }
        encAsRepPartContainer.setGrammarEndAllowed(true);
    }
}

