/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SortBehavior {
    UNORDERED,
    ORDERED,
    SORTED;

    public static final String SORT_BEHAVIOR = "org.ldaptive.sortBehavior";
    private static final Logger LOGGER;
    private static SortBehavior defaultSortBehavior;

    public static SortBehavior getDefaultSortBehavior() {
        return defaultSortBehavior;
    }

    static {
        LOGGER = LoggerFactory.getLogger(SortBehavior.class);
        String sb = System.getProperty(SORT_BEHAVIOR);
        if (sb != null) {
            try {
                SortBehavior sortBehavior = sb.startsWith(SortBehavior.class.getName()) ? SortBehavior.valueOf(sb.substring(SortBehavior.class.getName().length() + 1, sb.length())) : SortBehavior.valueOf(sb);
                LOGGER.info("Set default sort behavior to {}", (Object)sortBehavior);
                defaultSortBehavior = sortBehavior;
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Error instantiating {}", (Object)sb, (Object)e);
            }
        }
        if (defaultSortBehavior == null) {
            defaultSortBehavior = UNORDERED;
        }
    }
}

