/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.Iterator;
import java.util.List;
import java.util.regex.MatchResult;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.ServerTraceEvent;
import org.glassfish.jersey.server.internal.routing.Route;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.uri.PathPattern;

class PathPatternRouter
implements Router {
    private final Provider<RoutingContext> contextProvider;
    private final List<Route<PathPattern>> acceptedRoutes;

    private PathPatternRouter(Provider<RoutingContext> provider, List<Route<PathPattern>> routes) {
        this.contextProvider = provider;
        this.acceptedRoutes = routes;
    }

    @Override
    public Router.Continuation apply(ContainerRequest request) {
        RoutingContext rc = (RoutingContext)this.contextProvider.get();
        String path = rc.getFinalMatchingGroup();
        TracingLogger tracingLogger = TracingLogger.getInstance((PropertiesDelegate)request);
        tracingLogger.log((TracingLogger.Event)ServerTraceEvent.MATCH_PATH_FIND, new Object[]{path});
        Router.Continuation result = null;
        Iterator<Route<PathPattern>> iterator = this.acceptedRoutes.iterator();
        while (iterator.hasNext()) {
            Route<PathPattern> acceptedRoute = iterator.next();
            PathPattern routePattern = acceptedRoute.routingPattern();
            MatchResult m = routePattern.match((CharSequence)path);
            if (m != null) {
                rc.pushMatchResult(m);
                result = Router.Continuation.of(request, acceptedRoute.next());
                tracingLogger.log((TracingLogger.Event)ServerTraceEvent.MATCH_PATH_SELECTED, new Object[]{routePattern.getRegex()});
                break;
            }
            tracingLogger.log((TracingLogger.Event)ServerTraceEvent.MATCH_PATH_NOT_MATCHED, new Object[]{routePattern.getRegex()});
        }
        if (tracingLogger.isLogEnabled((TracingLogger.Event)ServerTraceEvent.MATCH_PATH_SKIPPED)) {
            while (iterator.hasNext()) {
                tracingLogger.log((TracingLogger.Event)ServerTraceEvent.MATCH_PATH_SKIPPED, new Object[]{iterator.next().routingPattern().getRegex()});
            }
        }
        if (result == null) {
            result = Router.Continuation.of(request);
        }
        return result;
    }

    public static class Builder {
        @Inject
        private Provider<RoutingContext> contextProvider;

        public PathPatternRouter build(List<Route<PathPattern>> routes) {
            return new PathPatternRouter(this.contextProvider, routes);
        }
    }
}

